/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.metadata.search.AggregationMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class AggregationMetadataArray
extends WrappingArrayTemplate<AggregationMetadata> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.metadata.search,record AggregationMetadata{/**The name of the aggregation, e.g, platform, origin*/name:string/**Name of the filter to be displayed in the UI*/displayName:optional string/**Entity associated with this facet*/entity:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**List of aggregations showing the number of documents falling into each bucket. e.g, for platform aggregation, the bucket can be hive, kafka, etc*/aggregations:map[string,long]filterValues:array[record FilterValue{value:string,entity:optional com.linkedin.common.Urn,facetCount:long,filtered:optional boolean}]}}]", SchemaFormatType.PDL);

    public AggregationMetadataArray() {
        this(new DataList());
    }

    public AggregationMetadataArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public AggregationMetadataArray(Collection<AggregationMetadata> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public AggregationMetadataArray(DataList data) {
        super(data, SCHEMA, AggregationMetadata.class);
    }

    public AggregationMetadataArray(AggregationMetadata first, AggregationMetadata ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public AggregationMetadataArray clone() throws CloneNotSupportedException {
        AggregationMetadataArray __clone = (AggregationMetadataArray)super.clone();
        return __clone;
    }

    @Override
    public AggregationMetadataArray copy() throws CloneNotSupportedException {
        AggregationMetadataArray __copy = (AggregationMetadataArray)super.copy();
        return __copy;
    }

    @Override
    protected AggregationMetadata coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new AggregationMetadata(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private AggregationMetadata.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<AggregationMetadata.ProjectionMask, AggregationMetadata.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? AggregationMetadata.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AggregationMetadata.Fields items() {
            return new AggregationMetadata.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

