/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.validation;

import com.google.common.collect.ImmutableSet;
import com.linkedin.common.urn.Urn;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.AspectRetriever;
import com.linkedin.metadata.aspect.ReadItem;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.validation.AspectPayloadValidator;
import com.linkedin.metadata.aspect.plugins.validation.AspectValidationException;
import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import com.linkedin.util.Pair;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;

public class ConditionalWriteValidator
extends AspectPayloadValidator {
    public static final String UNVERSIONED_ASPECT_VERSION = "-1";
    public static final long DEFAULT_LAST_MODIFIED_TIME = Long.MIN_VALUE;
    public static final String HTTP_HEADER_IF_VERSION_MATCH = "If-Version-Match";
    public static final Set<ChangeType> CREATE_CHANGE_TYPES = ImmutableSet.of(ChangeType.CREATE, ChangeType.CREATE_ENTITY);
    @Nonnull
    private AspectPluginConfig config;

    private static boolean hasTimePrecondition(ChangeMCP item) {
        return item.getHeader("If-Modified-Since").isPresent() || item.getHeader("If-Unmodified-Since").isPresent();
    }

    private static boolean hasVersionPrecondition(ChangeMCP item) {
        return item.getHeader(HTTP_HEADER_IF_VERSION_MATCH).isPresent();
    }

    private static boolean isApplicableFilter(ChangeMCP item) {
        if (ChangeType.RESTATE.equals((Object)item.getChangeType())) {
            return false;
        }
        return ConditionalWriteValidator.hasTimePrecondition(item) || ConditionalWriteValidator.hasVersionPrecondition(item);
    }

    @Override
    protected Stream<AspectValidationException> validatePreCommitAspects(@Nonnull Collection<ChangeMCP> changeMCPs, @Nonnull RetrieverContext retrieverContext) {
        ValidationExceptionCollection exceptions = ValidationExceptionCollection.newCollection();
        AspectRetriever aspectRetriever = retrieverContext.getAspectRetriever();
        List applicableMCPs = changeMCPs.stream().filter(ConditionalWriteValidator::isApplicableFilter).collect(Collectors.toList());
        Map<Urn, Set<String>> missingDataUrnAspects = applicableMCPs.stream().filter(item -> !CREATE_CHANGE_TYPES.contains((Object)item.getChangeType())).filter(item -> item.getPreviousSystemAspect() == null).collect(Collectors.groupingBy(ReadItem::getUrn, Collectors.mapping(ReadItem::getAspectName, Collectors.toSet())));
        Map<Urn, Map<String, SystemAspect>> resolvedData = aspectRetriever.getLatestSystemAspects(missingDataUrnAspects);
        for (ChangeMCP item2 : applicableMCPs) {
            if (ConditionalWriteValidator.hasVersionPrecondition(item2)) {
                item2.getHeader(HTTP_HEADER_IF_VERSION_MATCH).flatMap(headerValue -> ConditionalWriteValidator.validateVersionPrecondition(item2, Pair.of(HTTP_HEADER_IF_VERSION_MATCH, headerValue), resolvedData)).ifPresent(exceptions::addException);
            }
            if (!ConditionalWriteValidator.hasTimePrecondition(item2)) continue;
            item2.getHeader("If-Modified-Since").flatMap(headerValue -> ConditionalWriteValidator.validateTimePrecondition(item2, Pair.of("If-Modified-Since", headerValue), resolvedData)).ifPresent(exceptions::addException);
            item2.getHeader("If-Unmodified-Since").flatMap(headerValue -> ConditionalWriteValidator.validateTimePrecondition(item2, Pair.of("If-Unmodified-Since", headerValue), resolvedData)).ifPresent(exceptions::addException);
        }
        return exceptions.streamAllExceptions();
    }

    private static Optional<AspectValidationException> validateVersionPrecondition(ChangeMCP item, Pair<String, String> header, Map<Urn, Map<String, SystemAspect>> resolvedData) {
        String actualAspectVersion;
        switch (item.getChangeType()) {
            case CREATE: 
            case CREATE_ENTITY: {
                actualAspectVersion = UNVERSIONED_ASPECT_VERSION;
                break;
            }
            default: {
                actualAspectVersion = ConditionalWriteValidator.resolvePreviousSystemAspect(item, resolvedData).map(prevSystemAspect -> {
                    if (prevSystemAspect.getSystemMetadataVersion().isPresent()) {
                        return String.valueOf(prevSystemAspect.getSystemMetadataVersion().get());
                    }
                    return String.valueOf(Math.max(1L, prevSystemAspect.getVersion()));
                }).orElse(UNVERSIONED_ASPECT_VERSION);
            }
        }
        if (!header.getSecond().equals(actualAspectVersion)) {
            return Optional.of(AspectValidationException.forPrecondition(item, String.format("Expected version %s, actual version %s", header.getSecond(), actualAspectVersion)));
        }
        return Optional.empty();
    }

    private static Optional<AspectValidationException> validateTimePrecondition(ChangeMCP item, Pair<String, String> header, Map<Urn, Map<String, SystemAspect>> resolvedData) {
        long lastModifiedTimeMs;
        switch (item.getChangeType()) {
            case CREATE: 
            case CREATE_ENTITY: {
                lastModifiedTimeMs = Long.MIN_VALUE;
                break;
            }
            default: {
                lastModifiedTimeMs = ConditionalWriteValidator.resolvePreviousSystemAspect(item, resolvedData).map(systemAspect -> systemAspect.getAuditStamp().getTime()).orElse(Long.MIN_VALUE);
            }
        }
        long headerValueEpochMs = Instant.parse(header.getValue()).toEpochMilli();
        switch (header.getKey()) {
            case "If-Modified-Since": {
                return lastModifiedTimeMs > headerValueEpochMs ? Optional.empty() : Optional.of(AspectValidationException.forPrecondition(item, String.format("Item last modified %s <= %s (epoch ms)", lastModifiedTimeMs, headerValueEpochMs)));
            }
            case "If-Unmodified-Since": {
                return lastModifiedTimeMs <= headerValueEpochMs ? Optional.empty() : Optional.of(AspectValidationException.forPrecondition(item, String.format("Item last modified %s > %s (epoch ms)", lastModifiedTimeMs, headerValueEpochMs)));
            }
        }
        return Optional.empty();
    }

    private static Optional<SystemAspect> resolvePreviousSystemAspect(ChangeMCP item, Map<Urn, Map<String, SystemAspect>> resolvedData) {
        if (item.getPreviousSystemAspect() != null) {
            return Optional.of(item.getPreviousSystemAspect());
        }
        if (resolvedData.getOrDefault(item.getUrn(), Collections.emptyMap()).get(item.getAspectName()) != null) {
            return Optional.of(resolvedData.get(item.getUrn()).get(item.getAspectName()));
        }
        return Optional.empty();
    }

    @Override
    protected Stream<AspectValidationException> validateProposedAspects(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext) {
        return Stream.empty();
    }

    @Override
    @Generated
    public ConditionalWriteValidator setConfig(@Nonnull AspectPluginConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        return this;
    }

    @Override
    @Nonnull
    @Generated
    public AspectPluginConfig getConfig() {
        return this.config;
    }
}

