/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.models.graph;

import com.google.common.collect.ImmutableList;
import com.linkedin.common.urn.Urn;
import com.linkedin.metadata.query.filter.SortCriterion;
import com.linkedin.metadata.query.filter.SortOrder;
import com.linkedin.util.Pair;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Edge {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Edge.class);
    private Urn source;
    private Urn destination;
    private String relationshipType;
    private Long createdOn;
    private Urn createdActor;
    private Long updatedOn;
    private Urn updatedActor;
    private Map<String, Object> properties;
    private Urn lifecycleOwner;
    private Urn via;
    @Nullable
    private Boolean sourceStatus;
    @Nullable
    private Boolean destinationStatus;
    @Nullable
    private Boolean viaStatus;
    @Nullable
    private Boolean lifecycleOwnerStatus;
    public static final String EDGE_FIELD_SOURCE = "source";
    public static final String EDGE_FIELD_DESTINATION = "destination";
    public static final String EDGE_FIELD_RELNSHIP_TYPE = "relationshipType";
    public static final String EDGE_FIELD_PROPERTIES = "properties";
    public static final String EDGE_FIELD_VIA = "via";
    public static final String EDGE_FIELD_LIFECYCLE_OWNER = "lifecycleOwner";
    public static final String EDGE_SOURCE_URN_FIELD = "source.urn";
    public static final String EDGE_DESTINATION_URN_FIELD = "destination.urn";
    public static final String EDGE_SOURCE_STATUS = "source.removed";
    public static final String EDGE_DESTINATION_STATUS = "destination.removed";
    public static final String EDGE_FIELD_VIA_STATUS = "viaRemoved";
    public static final String EDGE_FIELD_LIFECYCLE_OWNER_STATUS = "lifecycleOwnerRemoved";
    public static final String EDGE_FIELD_UPDATED_ON = "updatedOn";
    public static final String EDGE_FIELD_CREATED_ON = "createdOn";
    public static final List<Pair<String, SortOrder>> KEY_SORTS = ImmutableList.of(new Pair<String, SortOrder>("source.urn", SortOrder.ASCENDING), new Pair<String, SortOrder>("destination.urn", SortOrder.ASCENDING), new Pair<String, SortOrder>("relationshipType", SortOrder.ASCENDING), new Pair<String, SortOrder>("lifecycleOwner", SortOrder.ASCENDING));
    public static List<SortCriterion> EDGE_SORT_CRITERION = KEY_SORTS.stream().map(entry -> {
        SortCriterion sortCriterion = new SortCriterion();
        sortCriterion.setField((String)entry.getKey());
        sortCriterion.setOrder(SortOrder.valueOf(Optional.ofNullable((SortOrder)((Object)((Object)entry.getValue()))).orElse(SortOrder.ASCENDING).toString()));
        return sortCriterion;
    }).collect(Collectors.toList());
    private static final String DOC_DELIMETER = "--";

    public Edge(Urn source, Urn destination, String relationshipType, Long createdOn, Urn createdActor, Long updatedOn, Urn updatedActor, Map<String, Object> properties) {
        this(source, destination, relationshipType, createdOn, createdActor, updatedOn, updatedActor, properties, null, null, null, null, null, null);
    }

    public Edge(Urn source, Urn destination, String relationshipType, Long createdOn, Urn createdActor, Long updatedOn, Urn updatedActor, Map<String, Object> properties, Urn lifecycleOwner, Urn via) {
        this(source, destination, relationshipType, createdOn, createdActor, updatedOn, updatedActor, properties, lifecycleOwner, via, null, null, null, null);
    }

    public String toDocId(@Nonnull String idHashAlgo) {
        StringBuilder rawDocId = new StringBuilder();
        rawDocId.append(this.getSource().toString()).append(DOC_DELIMETER).append(this.getRelationshipType()).append(DOC_DELIMETER).append(this.getDestination().toString());
        if (this.getLifecycleOwner() != null && StringUtils.isNotBlank(this.getLifecycleOwner().toString())) {
            rawDocId.append(DOC_DELIMETER).append(this.getLifecycleOwner().toString());
        }
        try {
            byte[] bytesOfRawDocID = rawDocId.toString().getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance(idHashAlgo);
            byte[] thedigest = md.digest(bytesOfRawDocID);
            return Base64.getEncoder().encodeToString(thedigest);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unable to hash document ID, returning unhashed id: " + String.valueOf(rawDocId));
            return rawDocId.toString();
        }
    }

    @Generated
    public Urn getSource() {
        return this.source;
    }

    @Generated
    public Urn getDestination() {
        return this.destination;
    }

    @Generated
    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Generated
    public Long getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public Urn getCreatedActor() {
        return this.createdActor;
    }

    @Generated
    public Long getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public Urn getUpdatedActor() {
        return this.updatedActor;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Generated
    public Urn getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    @Generated
    public Urn getVia() {
        return this.via;
    }

    @Nullable
    @Generated
    public Boolean getSourceStatus() {
        return this.sourceStatus;
    }

    @Nullable
    @Generated
    public Boolean getDestinationStatus() {
        return this.destinationStatus;
    }

    @Nullable
    @Generated
    public Boolean getViaStatus() {
        return this.viaStatus;
    }

    @Nullable
    @Generated
    public Boolean getLifecycleOwnerStatus() {
        return this.lifecycleOwnerStatus;
    }

    @Generated
    public void setSource(Urn source) {
        this.source = source;
    }

    @Generated
    public void setDestination(Urn destination) {
        this.destination = destination;
    }

    @Generated
    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Generated
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setCreatedActor(Urn createdActor) {
        this.createdActor = createdActor;
    }

    @Generated
    public void setUpdatedOn(Long updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public void setUpdatedActor(Urn updatedActor) {
        this.updatedActor = updatedActor;
    }

    @Generated
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Generated
    public void setLifecycleOwner(Urn lifecycleOwner) {
        this.lifecycleOwner = lifecycleOwner;
    }

    @Generated
    public void setVia(Urn via) {
        this.via = via;
    }

    @Generated
    public void setSourceStatus(@Nullable Boolean sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    @Generated
    public void setDestinationStatus(@Nullable Boolean destinationStatus) {
        this.destinationStatus = destinationStatus;
    }

    @Generated
    public void setViaStatus(@Nullable Boolean viaStatus) {
        this.viaStatus = viaStatus;
    }

    @Generated
    public void setLifecycleOwnerStatus(@Nullable Boolean lifecycleOwnerStatus) {
        this.lifecycleOwnerStatus = lifecycleOwnerStatus;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Urn this$source = this.getSource();
        Urn other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Urn this$destination = this.getDestination();
        Urn other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        String this$relationshipType = this.getRelationshipType();
        String other$relationshipType = other.getRelationshipType();
        if (this$relationshipType == null ? other$relationshipType != null : !this$relationshipType.equals(other$relationshipType)) {
            return false;
        }
        Urn this$lifecycleOwner = this.getLifecycleOwner();
        Urn other$lifecycleOwner = other.getLifecycleOwner();
        if (this$lifecycleOwner == null ? other$lifecycleOwner != null : !((Object)this$lifecycleOwner).equals(other$lifecycleOwner)) {
            return false;
        }
        Urn this$via = this.getVia();
        Urn other$via = other.getVia();
        return !(this$via == null ? other$via != null : !((Object)this$via).equals(other$via));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Edge;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Urn $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Urn $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        String $relationshipType = this.getRelationshipType();
        result = result * 59 + ($relationshipType == null ? 43 : $relationshipType.hashCode());
        Urn $lifecycleOwner = this.getLifecycleOwner();
        result = result * 59 + ($lifecycleOwner == null ? 43 : ((Object)$lifecycleOwner).hashCode());
        Urn $via = this.getVia();
        result = result * 59 + ($via == null ? 43 : ((Object)$via).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Edge(source=" + String.valueOf(this.getSource()) + ", destination=" + String.valueOf(this.getDestination()) + ", relationshipType=" + this.getRelationshipType() + ", createdOn=" + this.getCreatedOn() + ", createdActor=" + String.valueOf(this.getCreatedActor()) + ", updatedOn=" + this.getUpdatedOn() + ", updatedActor=" + String.valueOf(this.getUpdatedActor()) + ", properties=" + String.valueOf(this.getProperties()) + ", lifecycleOwner=" + String.valueOf(this.getLifecycleOwner()) + ", via=" + String.valueOf(this.getVia()) + ", sourceStatus=" + this.getSourceStatus() + ", destinationStatus=" + this.getDestinationStatus() + ", viaStatus=" + this.getViaStatus() + ", lifecycleOwnerStatus=" + this.getLifecycleOwnerStatus() + ")";
    }

    @Generated
    public Edge(Urn source, Urn destination, String relationshipType, Long createdOn, Urn createdActor, Long updatedOn, Urn updatedActor, Map<String, Object> properties, Urn lifecycleOwner, Urn via, @Nullable Boolean sourceStatus, @Nullable Boolean destinationStatus, @Nullable Boolean viaStatus, @Nullable Boolean lifecycleOwnerStatus) {
        this.source = source;
        this.destination = destination;
        this.relationshipType = relationshipType;
        this.createdOn = createdOn;
        this.createdActor = createdActor;
        this.updatedOn = updatedOn;
        this.updatedActor = updatedActor;
        this.properties = properties;
        this.lifecycleOwner = lifecycleOwner;
        this.via = via;
        this.sourceStatus = sourceStatus;
        this.destinationStatus = destinationStatus;
        this.viaStatus = viaStatus;
        this.lifecycleOwnerStatus = lifecycleOwnerStatus;
    }
}

