/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.Constants;
import com.linkedin.metadata.aspect.EntityAspect;
import com.linkedin.metadata.aspect.ReadItem;
import com.linkedin.mxe.SystemMetadata;
import java.sql.Timestamp;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface SystemAspect
extends ReadItem {
    public long getVersion();

    public Timestamp getCreatedOn();

    public String getCreatedBy();

    @Nonnull
    public Optional<SystemAspect> getDatabaseAspect();

    @Nonnull
    default public EntityAspect asLatest() {
        return this.withVersion(Constants.ASPECT_LATEST_VERSION);
    }

    @Nonnull
    public EntityAspect withVersion(long var1);

    @Nonnull
    public SystemAspect copy();

    @Nonnull
    default public AuditStamp getAuditStamp() {
        return new AuditStamp().setActor(UrnUtils.getUrn(this.getCreatedBy())).setTime(this.getCreatedOn().getTime());
    }

    default public Optional<Long> getSystemMetadataVersion() {
        return Optional.ofNullable(this.getSystemMetadata()).filter(SystemMetadata::hasVersion).map(SystemMetadata::getVersion).map(Long::parseLong);
    }

    @Nonnull
    public SystemAspect setSystemMetadata(@Nullable SystemMetadata var1);

    @Nonnull
    public SystemAspect setRecordTemplate(@Nonnull RecordTemplate var1);

    @Nonnull
    public SystemAspect setAuditStamp(@Nonnull AuditStamp var1);

    @Nonnull
    public SystemAspect setDatabaseAspect(@Nonnull SystemAspect var1);
}

