/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ViewProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Details about a View. \ne.g. Gets activated when subTypes is view*/@Aspect.name=\"viewProperties\"record ViewProperties{/**Whether the view is materialized*/@Searchable={\"fieldType\":\"BOOLEAN\",\"weightsPerFieldValue\":{\"true\":0.5}}materialized:boolean/**The view logic*/viewLogic:string/**The formatted view logic. This is particularly used for SQL sources, where the SQL\nlogic is formatted for better readability, and with dbt, where this contains the\ncompiled SQL logic.*/formattedViewLogic:optional string/**The view logic language / dialect*/viewLanguage:string}", SchemaFormatType.PDL);
    private Boolean _materializedField = null;
    private String _viewLogicField = null;
    private String _formattedViewLogicField = null;
    private String _viewLanguageField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Materialized = SCHEMA.getField("materialized");
    private static final RecordDataSchema.Field FIELD_ViewLogic = SCHEMA.getField("viewLogic");
    private static final RecordDataSchema.Field FIELD_FormattedViewLogic = SCHEMA.getField("formattedViewLogic");
    private static final RecordDataSchema.Field FIELD_ViewLanguage = SCHEMA.getField("viewLanguage");

    public ViewProperties() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public ViewProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasMaterialized() {
        if (this._materializedField != null) {
            return true;
        }
        return this._map.containsKey("materialized");
    }

    public void removeMaterialized() {
        this._map.remove("materialized");
    }

    @Nullable
    public Boolean isMaterialized(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isMaterialized();
            }
            case DEFAULT: 
            case NULL: {
                if (this._materializedField != null) {
                    return this._materializedField;
                }
                Object __rawValue = this._map.get("materialized");
                this._materializedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._materializedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isMaterialized() {
        if (this._materializedField != null) {
            return this._materializedField;
        }
        Object __rawValue = this._map.get("materialized");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("materialized");
        }
        this._materializedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._materializedField;
    }

    public ViewProperties setMaterialized(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMaterialized(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field materialized of com.linkedin.dataset.ViewProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "materialized", value);
                this._materializedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMaterialized();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "materialized", value);
                this._materializedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "materialized", value);
                this._materializedField = value;
            }
        }
        return this;
    }

    public ViewProperties setMaterialized(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field materialized of com.linkedin.dataset.ViewProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "materialized", value);
        this._materializedField = value;
        return this;
    }

    public ViewProperties setMaterialized(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "materialized", value);
        this._materializedField = value;
        return this;
    }

    public boolean hasViewLogic() {
        if (this._viewLogicField != null) {
            return true;
        }
        return this._map.containsKey("viewLogic");
    }

    public void removeViewLogic() {
        this._map.remove("viewLogic");
    }

    @Nullable
    public String getViewLogic(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getViewLogic();
            }
            case DEFAULT: 
            case NULL: {
                if (this._viewLogicField != null) {
                    return this._viewLogicField;
                }
                Object __rawValue = this._map.get("viewLogic");
                this._viewLogicField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._viewLogicField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getViewLogic() {
        if (this._viewLogicField != null) {
            return this._viewLogicField;
        }
        Object __rawValue = this._map.get("viewLogic");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("viewLogic");
        }
        this._viewLogicField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._viewLogicField;
    }

    public ViewProperties setViewLogic(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setViewLogic(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field viewLogic of com.linkedin.dataset.ViewProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "viewLogic", value);
                this._viewLogicField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeViewLogic();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "viewLogic", value);
                this._viewLogicField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "viewLogic", value);
                this._viewLogicField = value;
            }
        }
        return this;
    }

    public ViewProperties setViewLogic(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field viewLogic of com.linkedin.dataset.ViewProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "viewLogic", value);
        this._viewLogicField = value;
        return this;
    }

    public boolean hasFormattedViewLogic() {
        if (this._formattedViewLogicField != null) {
            return true;
        }
        return this._map.containsKey("formattedViewLogic");
    }

    public void removeFormattedViewLogic() {
        this._map.remove("formattedViewLogic");
    }

    @Nullable
    public String getFormattedViewLogic(GetMode mode) {
        return this.getFormattedViewLogic();
    }

    @Nullable
    public String getFormattedViewLogic() {
        if (this._formattedViewLogicField != null) {
            return this._formattedViewLogicField;
        }
        Object __rawValue = this._map.get("formattedViewLogic");
        this._formattedViewLogicField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._formattedViewLogicField;
    }

    public ViewProperties setFormattedViewLogic(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFormattedViewLogic(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFormattedViewLogic();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "formattedViewLogic", value);
                this._formattedViewLogicField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "formattedViewLogic", value);
                this._formattedViewLogicField = value;
            }
        }
        return this;
    }

    public ViewProperties setFormattedViewLogic(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field formattedViewLogic of com.linkedin.dataset.ViewProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "formattedViewLogic", value);
        this._formattedViewLogicField = value;
        return this;
    }

    public boolean hasViewLanguage() {
        if (this._viewLanguageField != null) {
            return true;
        }
        return this._map.containsKey("viewLanguage");
    }

    public void removeViewLanguage() {
        this._map.remove("viewLanguage");
    }

    @Nullable
    public String getViewLanguage(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getViewLanguage();
            }
            case DEFAULT: 
            case NULL: {
                if (this._viewLanguageField != null) {
                    return this._viewLanguageField;
                }
                Object __rawValue = this._map.get("viewLanguage");
                this._viewLanguageField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._viewLanguageField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getViewLanguage() {
        if (this._viewLanguageField != null) {
            return this._viewLanguageField;
        }
        Object __rawValue = this._map.get("viewLanguage");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("viewLanguage");
        }
        this._viewLanguageField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._viewLanguageField;
    }

    public ViewProperties setViewLanguage(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setViewLanguage(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field viewLanguage of com.linkedin.dataset.ViewProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "viewLanguage", value);
                this._viewLanguageField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeViewLanguage();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "viewLanguage", value);
                this._viewLanguageField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "viewLanguage", value);
                this._viewLanguageField = value;
            }
        }
        return this;
    }

    public ViewProperties setViewLanguage(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field viewLanguage of com.linkedin.dataset.ViewProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "viewLanguage", value);
        this._viewLanguageField = value;
        return this;
    }

    @Override
    public ViewProperties clone() throws CloneNotSupportedException {
        ViewProperties __clone = (ViewProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ViewProperties copy() throws CloneNotSupportedException {
        ViewProperties __copy = (ViewProperties)super.copy();
        __copy._formattedViewLogicField = null;
        __copy._viewLogicField = null;
        __copy._materializedField = null;
        __copy._viewLanguageField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ViewProperties __objectRef;

        private ChangeListener(ViewProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "formattedViewLogic": {
                    this.__objectRef._formattedViewLogicField = null;
                    break;
                }
                case "viewLogic": {
                    this.__objectRef._viewLogicField = null;
                    break;
                }
                case "materialized": {
                    this.__objectRef._materializedField = null;
                    break;
                }
                case "viewLanguage": {
                    this.__objectRef._viewLanguageField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec materialized() {
            return new PathSpec(this.getPathComponents(), "materialized");
        }

        public PathSpec viewLogic() {
            return new PathSpec(this.getPathComponents(), "viewLogic");
        }

        public PathSpec formattedViewLogic() {
            return new PathSpec(this.getPathComponents(), "formattedViewLogic");
        }

        public PathSpec viewLanguage() {
            return new PathSpec(this.getPathComponents(), "viewLanguage");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withMaterialized() {
            this.getDataMap().put("materialized", 1);
            return this;
        }

        public ProjectionMask withViewLogic() {
            this.getDataMap().put("viewLogic", 1);
            return this;
        }

        public ProjectionMask withFormattedViewLogic() {
            this.getDataMap().put("formattedViewLogic", 1);
            return this;
        }

        public ProjectionMask withViewLanguage() {
            this.getDataMap().put("viewLanguage", 1);
            return this;
        }
    }
}

