/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.dataset.DatasetLineageType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Upstream
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Upstream lineage information about a dataset including the source reporting the lineage*/record Upstream{/**Audit stamp containing who reported the lineage and when.*/auditStamp:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**Audit stamp containing who created the lineage and when.*/created:optional com.linkedin.common.AuditStamp/**The upstream dataset the lineage points to*/@Relationship={\"createdActor\":\"upstreams/*/created/actor\",\"createdOn\":\"upstreams/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"DownstreamOf\",\"properties\":\"upstreams/*/properties\",\"updatedActor\":\"upstreams/*/auditStamp/actor\",\"updatedOn\":\"upstreams/*/auditStamp/time\",\"via\":\"upstreams/*/query\"}@Searchable={\"fieldName\":\"upstreams\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasUpstreams\",\"queryByDefault\":false}dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**The type of the lineage*/type:/**The various types of supported dataset lineage*/enum DatasetLineageType{/**Direct copy without modification*/COPY/**Transformed data with modification (format or content change)*/TRANSFORMED/**Represents a view defined on the sources e.g. Hive view defined on underlying hive tables or a Hive table pointing to a HDFS dataset or DALI view defined on multiple sources*/VIEW}/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]/**If the lineage is generated by a query, a reference to the query*/query:optional com.linkedin.common.Urn}", SchemaFormatType.PDL);
    private AuditStamp _auditStampField = null;
    private AuditStamp _createdField = null;
    private DatasetUrn _datasetField = null;
    private DatasetLineageType _typeField = null;
    private StringMap _propertiesField = null;
    private Urn _queryField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_AuditStamp = SCHEMA.getField("auditStamp");
    private static final AuditStamp DEFAULT_AuditStamp;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_Dataset;
    private static final RecordDataSchema.Field FIELD_Type;
    private static final RecordDataSchema.Field FIELD_Properties;
    private static final RecordDataSchema.Field FIELD_Query;

    public Upstream() {
        super(new DataMap(8, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public Upstream(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAuditStamp() {
        if (this._auditStampField != null) {
            return true;
        }
        return this._map.containsKey("auditStamp");
    }

    public void removeAuditStamp() {
        this._map.remove("auditStamp");
    }

    @Nullable
    public AuditStamp getAuditStamp(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getAuditStamp();
            }
            case NULL: {
                if (this._auditStampField != null) {
                    return this._auditStampField;
                }
                Object __rawValue = this._map.get("auditStamp");
                this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._auditStampField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getAuditStamp() {
        if (this._auditStampField != null) {
            return this._auditStampField;
        }
        Object __rawValue = this._map.get("auditStamp");
        if (__rawValue == null) {
            return DEFAULT_AuditStamp;
        }
        this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditStampField;
    }

    public Upstream setAuditStamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditStamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field auditStamp of com.linkedin.dataset.Upstream");
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditStamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
            }
        }
        return this;
    }

    public Upstream setAuditStamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditStamp of com.linkedin.dataset.Upstream to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
        this._auditStampField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public Upstream setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public Upstream setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.dataset.Upstream to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasDataset() {
        if (this._datasetField != null) {
            return true;
        }
        return this._map.containsKey("dataset");
    }

    public void removeDataset() {
        this._map.remove("dataset");
    }

    @Nullable
    public DatasetUrn getDataset(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDataset();
            }
            case DEFAULT: 
            case NULL: {
                if (this._datasetField != null) {
                    return this._datasetField;
                }
                Object __rawValue = this._map.get("dataset");
                this._datasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
                return this._datasetField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DatasetUrn getDataset() {
        if (this._datasetField != null) {
            return this._datasetField;
        }
        Object __rawValue = this._map.get("dataset");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("dataset");
        }
        this._datasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
        return this._datasetField;
    }

    public Upstream setDataset(@Nullable DatasetUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDataset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dataset of com.linkedin.dataset.Upstream");
                }
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDataset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
            }
        }
        return this;
    }

    public Upstream setDataset(@Nonnull DatasetUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dataset of com.linkedin.dataset.Upstream to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
        this._datasetField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public DatasetLineageType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DatasetLineageType.class, DatasetLineageType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DatasetLineageType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DatasetLineageType.class, DatasetLineageType.$UNKNOWN);
        return this._typeField;
    }

    public Upstream setType(@Nullable DatasetLineageType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.dataset.Upstream");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public Upstream setType(@Nonnull DatasetLineageType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.dataset.Upstream to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasProperties() {
        if (this._propertiesField != null) {
            return true;
        }
        return this._map.containsKey("properties");
    }

    public void removeProperties() {
        this._map.remove("properties");
    }

    @Nullable
    public StringMap getProperties(GetMode mode) {
        return this.getProperties();
    }

    @Nullable
    public StringMap getProperties() {
        if (this._propertiesField != null) {
            return this._propertiesField;
        }
        Object __rawValue = this._map.get("properties");
        this._propertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._propertiesField;
    }

    public Upstream setProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
            }
        }
        return this;
    }

    public Upstream setProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field properties of com.linkedin.dataset.Upstream to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
        this._propertiesField = value;
        return this;
    }

    public boolean hasQuery() {
        if (this._queryField != null) {
            return true;
        }
        return this._map.containsKey("query");
    }

    public void removeQuery() {
        this._map.remove("query");
    }

    @Nullable
    public Urn getQuery(GetMode mode) {
        return this.getQuery();
    }

    @Nullable
    public Urn getQuery() {
        if (this._queryField != null) {
            return this._queryField;
        }
        Object __rawValue = this._map.get("query");
        this._queryField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._queryField;
    }

    public Upstream setQuery(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQuery(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQuery();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "query", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._queryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "query", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._queryField = value;
            }
        }
        return this;
    }

    public Upstream setQuery(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field query of com.linkedin.dataset.Upstream to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "query", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._queryField = value;
        return this;
    }

    @Override
    public Upstream clone() throws CloneNotSupportedException {
        Upstream __clone = (Upstream)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Upstream copy() throws CloneNotSupportedException {
        Upstream __copy = (Upstream)super.copy();
        __copy._auditStampField = null;
        __copy._createdField = null;
        __copy._queryField = null;
        __copy._typeField = null;
        __copy._datasetField = null;
        __copy._propertiesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Created = SCHEMA.getField("created");
        FIELD_Dataset = SCHEMA.getField("dataset");
        FIELD_Type = SCHEMA.getField("type");
        FIELD_Properties = SCHEMA.getField("properties");
        FIELD_Query = SCHEMA.getField("query");
        Custom.initializeCustomClass(DatasetUrn.class);
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_AuditStamp = FIELD_AuditStamp.getDefault() == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(FIELD_AuditStamp.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Upstream __objectRef;

        private ChangeListener(Upstream reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "auditStamp": {
                    this.__objectRef._auditStampField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "query": {
                    this.__objectRef._queryField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "dataset": {
                    this.__objectRef._datasetField = null;
                    break;
                }
                case "properties": {
                    this.__objectRef._propertiesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AuditStamp.Fields auditStamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "auditStamp");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public PathSpec dataset() {
            return new PathSpec(this.getPathComponents(), "dataset");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec properties() {
            return new PathSpec(this.getPathComponents(), "properties");
        }

        public PathSpec query() {
            return new PathSpec(this.getPathComponents(), "query");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _auditStampMask;
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withAuditStamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._auditStampMask = nestedMask.apply(this._auditStampMask == null ? AuditStamp.createMask() : this._auditStampMask);
            this.getDataMap().put("auditStamp", this._auditStampMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp(MaskMap nestedMask) {
            this.getDataMap().put("auditStamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp() {
            this._auditStampMask = null;
            this.getDataMap().put("auditStamp", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withDataset() {
            this.getDataMap().put("dataset", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withProperties() {
            this.getDataMap().put("properties", 1);
            return this;
        }

        public ProjectionMask withQuery() {
            this.getDataMap().put("query", 1);
            return this;
        }
    }
}

