/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IcebergCatalogInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Iceberg Catalog metadata associated with an Iceberg table/view*/@Aspect.name=\"icebergCatalogInfo\"record IcebergCatalogInfo{/**When Datahub is the REST Catalog for an Iceberg Table, stores the current metadata pointer.\nIf the Iceberg table is managed by an external catalog, the metadata pointer is not set.*/metadataPointer:optional string,view:optional boolean}", SchemaFormatType.PDL);
    private String _metadataPointerField = null;
    private Boolean _viewField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_MetadataPointer = SCHEMA.getField("metadataPointer");
    private static final RecordDataSchema.Field FIELD_View = SCHEMA.getField("view");

    public IcebergCatalogInfo() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public IcebergCatalogInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasMetadataPointer() {
        if (this._metadataPointerField != null) {
            return true;
        }
        return this._map.containsKey("metadataPointer");
    }

    public void removeMetadataPointer() {
        this._map.remove("metadataPointer");
    }

    @Nullable
    public String getMetadataPointer(GetMode mode) {
        return this.getMetadataPointer();
    }

    @Nullable
    public String getMetadataPointer() {
        if (this._metadataPointerField != null) {
            return this._metadataPointerField;
        }
        Object __rawValue = this._map.get("metadataPointer");
        this._metadataPointerField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._metadataPointerField;
    }

    public IcebergCatalogInfo setMetadataPointer(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMetadataPointer(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMetadataPointer();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "metadataPointer", value);
                this._metadataPointerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "metadataPointer", value);
                this._metadataPointerField = value;
            }
        }
        return this;
    }

    public IcebergCatalogInfo setMetadataPointer(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field metadataPointer of com.linkedin.dataset.IcebergCatalogInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "metadataPointer", value);
        this._metadataPointerField = value;
        return this;
    }

    public boolean hasView() {
        if (this._viewField != null) {
            return true;
        }
        return this._map.containsKey("view");
    }

    public void removeView() {
        this._map.remove("view");
    }

    @Nullable
    public Boolean isView(GetMode mode) {
        return this.isView();
    }

    @Nullable
    public Boolean isView() {
        if (this._viewField != null) {
            return this._viewField;
        }
        Object __rawValue = this._map.get("view");
        this._viewField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._viewField;
    }

    public IcebergCatalogInfo setView(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setView(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeView();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "view", value);
                this._viewField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "view", value);
                this._viewField = value;
            }
        }
        return this;
    }

    public IcebergCatalogInfo setView(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field view of com.linkedin.dataset.IcebergCatalogInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "view", value);
        this._viewField = value;
        return this;
    }

    public IcebergCatalogInfo setView(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "view", value);
        this._viewField = value;
        return this;
    }

    @Override
    public IcebergCatalogInfo clone() throws CloneNotSupportedException {
        IcebergCatalogInfo __clone = (IcebergCatalogInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IcebergCatalogInfo copy() throws CloneNotSupportedException {
        IcebergCatalogInfo __copy = (IcebergCatalogInfo)super.copy();
        __copy._viewField = null;
        __copy._metadataPointerField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IcebergCatalogInfo __objectRef;

        private ChangeListener(IcebergCatalogInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "view": {
                    this.__objectRef._viewField = null;
                    break;
                }
                case "metadataPointer": {
                    this.__objectRef._metadataPointerField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec metadataPointer() {
            return new PathSpec(this.getPathComponents(), "metadataPointer");
        }

        public PathSpec view() {
            return new PathSpec(this.getPathComponents(), "view");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withMetadataPointer() {
            this.getDataMap().put("metadataPointer", 1);
            return this;
        }

        public ProjectionMask withView() {
            this.getDataMap().put("view", 1);
            return this;
        }
    }
}

