/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.AbstractJacksonDataCodec;
import com.linkedin.data.codec.DataEncodingException;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class JacksonDataTemplateCodec
extends JacksonDataCodec {
    public JacksonDataTemplateCodec() {
    }

    public JacksonDataTemplateCodec(JsonFactory jsonFactory) {
        super(jsonFactory);
    }

    protected void dataTemplateToJsonGenerator(Object data, DataSchema schema, JsonGenerator generator, boolean order) throws IOException {
        if (order) {
            SchemaOrderTraverseCallback callback = new SchemaOrderTraverseCallback(schema, generator);
            Data.traverse(data, callback);
        } else {
            this.objectToJsonGenerator(data, generator);
        }
    }

    public void dataTemplateToJsonGenerator(DataTemplate<?> template, JsonGenerator generator, boolean order) throws IOException {
        this.dataTemplateToJsonGenerator(template.data(), template.schema(), generator, order);
    }

    protected void writeDataTemplate(Object data, DataSchema schema, JsonGenerator generator, boolean order) throws IOException {
        if (order) {
            SchemaOrderTraverseCallback callback = new SchemaOrderTraverseCallback(schema, generator);
            Data.traverse(data, callback);
            generator.flush();
            generator.close();
        } else {
            this.writeObject(data, generator);
        }
    }

    public void writeDataTemplate(DataTemplate<?> template, OutputStream out, boolean order) throws IOException {
        this.writeDataTemplate(template.data(), template.schema(), out, order);
    }

    public void writeDataTemplate(DataTemplate<?> template, Writer out, boolean order) throws IOException {
        this.writeDataTemplate(template.data(), template.schema(), out, order);
    }

    public void writeDataTemplate(Object data, DataSchema schema, OutputStream out, boolean order) throws IOException {
        JsonGenerator generator = this.createJsonGenerator(out);
        this.writeDataTemplate(data, schema, generator, order);
    }

    public void writeDataTemplate(Object data, DataSchema schema, Writer out, boolean order) throws IOException {
        JsonGenerator generator = this.createJsonGenerator(out);
        this.writeDataTemplate(data, schema, generator, order);
    }

    public void writeDataTemplate(DataTemplate<?> template, OutputStream out) throws IOException {
        this.writeObject(template.data(), this.createJsonGenerator(out));
    }

    public void writeDataTemplate(DataTemplate<?> template, Writer out) throws IOException {
        this.writeObject(template.data(), this.createJsonGenerator(out));
    }

    public byte[] dataTemplateToBytes(DataTemplate<?> template, boolean order) throws IOException {
        if (order) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.writeDataTemplate(template, out, order);
            return out.toByteArray();
        }
        return this.dataTemplateToBytes(template);
    }

    public String dataTemplateToString(DataTemplate<?> template, boolean order) throws IOException {
        if (order) {
            StringWriter out = new StringWriter(4096);
            this.writeDataTemplate(template, out, order);
            return out.toString();
        }
        return this.dataTemplateToString(template);
    }

    public byte[] dataTemplateToBytes(DataTemplate<?> template) throws IOException {
        return this.objectToBytes(template.data());
    }

    public String dataTemplateToString(DataTemplate<?> template) throws IOException {
        return this.objectToString(template.data());
    }

    public static class SchemaOrderTraverseCallback
    extends AbstractJacksonDataCodec.JacksonTraverseCallback {
        private DataSchema _currentSchema;
        private DataSchema _pendingSchema;
        private final List<DataSchema> _schemaStack = new ArrayList<DataSchema>();

        SchemaOrderTraverseCallback(DataSchema schema, JsonGenerator jsonGenerator) {
            super(jsonGenerator);
            this._pendingSchema = schema;
        }

        @Override
        public Iterable<Map.Entry<String, Object>> orderMap(DataMap map) {
            if (this._currentSchema != null && this._currentSchema.getType() == DataSchema.Type.RECORD) {
                return SchemaOrderTraverseCallback.orderMapEntries((RecordDataSchema)this._currentSchema, map);
            }
            return Data.orderMapEntries(map);
        }

        @Override
        public void nullValue() throws IOException {
            this.simpleValue();
            super.nullValue();
        }

        @Override
        public void booleanValue(boolean value) throws IOException {
            this.simpleValue();
            super.booleanValue(value);
        }

        @Override
        public void integerValue(int value) throws IOException {
            this.simpleValue();
            super.integerValue(value);
        }

        @Override
        public void longValue(long value) throws IOException {
            this.simpleValue();
            super.longValue(value);
        }

        @Override
        public void floatValue(float value) throws IOException {
            this.simpleValue();
            super.floatValue(value);
        }

        @Override
        public void doubleValue(double value) throws IOException {
            this.simpleValue();
            super.doubleValue(value);
        }

        @Override
        public void stringValue(String value) throws IOException {
            this.simpleValue();
            super.stringValue(value);
        }

        @Override
        public void byteStringValue(ByteString value) throws IOException {
            this.simpleValue();
            super.byteStringValue(value);
        }

        @Override
        public void illegalValue(Object value) throws DataEncodingException {
            super.illegalValue(value);
        }

        @Override
        public void emptyMap() throws IOException {
            this.simpleValue();
            super.emptyMap();
        }

        @Override
        public void startMap(DataMap map) throws IOException {
            this.push();
            super.startMap(map);
        }

        @Override
        public void key(String key) throws IOException {
            DataSchema newSchema = null;
            if (this._currentSchema != null) {
                switch (this._currentSchema.getType()) {
                    case RECORD: {
                        RecordDataSchema recordSchema = (RecordDataSchema)this._currentSchema;
                        RecordDataSchema.Field field = recordSchema.getField(key);
                        if (field == null) break;
                        newSchema = field.getType();
                        break;
                    }
                    case UNION: {
                        UnionDataSchema unionSchema = (UnionDataSchema)this._currentSchema;
                        newSchema = unionSchema.getTypeByMemberKey(key);
                        break;
                    }
                    case MAP: {
                        MapDataSchema mapSchema = (MapDataSchema)this._currentSchema;
                        newSchema = mapSchema.getValues();
                    }
                }
            }
            this._pendingSchema = newSchema;
            super.key(key);
        }

        @Override
        public void endMap() throws IOException {
            super.endMap();
            this.pop();
        }

        @Override
        public void emptyList() throws IOException {
            this.simpleValue();
            super.emptyList();
        }

        @Override
        public void startList(DataList list) throws IOException {
            this.push();
            super.startList(list);
        }

        @Override
        public void index(int index) {
            DataSchema newSchema = null;
            if (this._currentSchema != null && this._currentSchema.getType() == DataSchema.Type.ARRAY) {
                ArrayDataSchema arraySchema = (ArrayDataSchema)this._currentSchema;
                newSchema = arraySchema.getItems();
            }
            this._pendingSchema = newSchema;
            super.index(index);
        }

        @Override
        public void endList() throws IOException {
            super.endList();
            this.pop();
        }

        private static List<Map.Entry<String, Object>> orderMapEntries(RecordDataSchema schema, DataMap map) {
            ArrayList<Map.Entry<String, Object>> output = new ArrayList<Map.Entry<String, Object>>(map.size());
            List<RecordDataSchema.Field> fields = schema.getFields();
            for (RecordDataSchema.Field field : fields) {
                String fieldName = field.getName();
                Object found = map.get(fieldName);
                if (found == null) continue;
                output.add(new AbstractMap.SimpleImmutableEntry<String, Object>(fieldName, found));
            }
            ArrayList uncollected = new ArrayList(map.size() - output.size());
            for (Map.Entry e : map.entrySet()) {
                if (schema.contains((String)e.getKey())) continue;
                uncollected.add(e);
            }
            Collections.sort(uncollected, new Comparator<Map.Entry<String, Object>>(){

                @Override
                public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            output.addAll(uncollected);
            return output;
        }

        private void simpleValue() {
            this._pendingSchema = null;
        }

        private void push() {
            this._schemaStack.add(this._currentSchema);
            this._currentSchema = this._pendingSchema;
        }

        private void pop() {
            this._currentSchema = this._schemaStack.remove(this._schemaStack.size() - 1);
            this._pendingSchema = null;
        }
    }
}

