/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.grammar.PdlSchemaParserFactory;
import com.linkedin.data.schema.resolver.SchemaDirectory;
import com.linkedin.data.schema.resolver.SchemaDirectoryName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMultiFormatDataSchemaResolver
implements DataSchemaResolver {
    public static final String[] BUILTIN_EXTENSIONS = new String[]{".pdsc", ".pdl"};
    private final List<DataSchemaResolver> _resolvers = new ArrayList<DataSchemaResolver>();
    private List<SchemaDirectory> _schemaDirectories = Collections.singletonList(SchemaDirectoryName.PEGASUS);
    public static List<DataSchemaParserFactory> BUILTIN_FORMAT_PARSER_FACTORIES = new ArrayList<DataSchemaParserFactory>(2);

    protected void addResolver(DataSchemaResolver resolver) {
        this._resolvers.add(resolver);
    }

    @Override
    public Map<String, NamedDataSchema> bindings() {
        HashMap<String, NamedDataSchema> results = new HashMap<String, NamedDataSchema>();
        for (DataSchemaResolver resolver : this._resolvers) {
            results.putAll(resolver.bindings());
        }
        return results;
    }

    @Override
    public Map<String, DataSchemaLocation> nameToDataSchemaLocations() {
        HashMap<String, DataSchemaLocation> results = new HashMap<String, DataSchemaLocation>();
        for (DataSchemaResolver resolver : this._resolvers) {
            results.putAll(resolver.nameToDataSchemaLocations());
        }
        return results;
    }

    @Override
    public NamedDataSchema findDataSchema(String name, StringBuilder errorMessageBuilder) {
        for (DataSchemaResolver resolver : this._resolvers) {
            NamedDataSchema result = resolver.findDataSchema(name, errorMessageBuilder);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void bindNameToSchema(Name name, NamedDataSchema schema, DataSchemaLocation location) {
        for (DataSchemaResolver resolver : this._resolvers) {
            resolver.bindNameToSchema(name, schema, location);
        }
    }

    @Override
    public NamedDataSchema existingDataSchema(String name) {
        for (DataSchemaResolver resolver : this._resolvers) {
            NamedDataSchema result = resolver.existingDataSchema(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public DataSchemaLocation existingSchemaLocation(String name) {
        for (DataSchemaResolver resolver : this._resolvers) {
            DataSchemaLocation result = resolver.existingSchemaLocation(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean locationResolved(DataSchemaLocation location) {
        for (DataSchemaResolver resolver : this._resolvers) {
            if (!resolver.locationResolved(location)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addPendingSchema(String name) {
        for (DataSchemaResolver resolver : this._resolvers) {
            resolver.addPendingSchema(name);
        }
    }

    @Override
    public void updatePendingSchema(String name, Boolean isParsingInclude) {
        for (DataSchemaResolver resolver : this._resolvers) {
            resolver.updatePendingSchema(name, isParsingInclude);
        }
    }

    @Override
    public void removePendingSchema(String name) {
        for (DataSchemaResolver resolver : this._resolvers) {
            resolver.removePendingSchema(name);
        }
    }

    @Override
    public LinkedHashMap<String, Boolean> getPendingSchemas() {
        LinkedHashMap<String, Boolean> results = new LinkedHashMap<String, Boolean>();
        for (DataSchemaResolver resolver : this._resolvers) {
            results.putAll(resolver.getPendingSchemas());
        }
        return results;
    }

    @Override
    public List<SchemaDirectory> getSchemaDirectories() {
        return this._schemaDirectories;
    }

    public void setSchemaDirectories(List<SchemaDirectory> schemaDirectories) {
        this._schemaDirectories = schemaDirectories;
    }

    static {
        BUILTIN_FORMAT_PARSER_FACTORIES.add(PdlSchemaParserFactory.instance());
        BUILTIN_FORMAT_PARSER_FACTORIES.add(SchemaParserFactory.instance());
    }
}

