/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class AnnotationEntry {
    private Object _annotationValue;
    private final List<String> _pathToAnnotatedTarget;
    private final Object _annotatedTarget;
    private ArrayDeque<String> _matchedPaths = new ArrayDeque();
    private ArrayDeque<String> _remainingPaths = new ArrayDeque();
    private final String _overridePathSpecStr;
    private final AnnotationType _annotationType;
    private String _startSchemaName = "";
    private OverridePathValidStatus _overridePathValidStatus = OverridePathValidStatus.UNCHECKED;

    OverridePathValidStatus getOverridePathValidStatus() {
        return this._overridePathValidStatus;
    }

    void setOverridePathValidStatus(OverridePathValidStatus overridePathValidStatus) {
        this._overridePathValidStatus = overridePathValidStatus;
    }

    AnnotationEntry(String pathSpecStr, Object annotationValue, AnnotationType annotationType, List<String> pathToAnnotatedTarget, Object annotatedTarget) {
        this._remainingPaths = new ArrayDeque<String>(Arrays.asList(pathSpecStr.split(Character.toString('/'))));
        this._remainingPaths.remove("");
        this._annotationValue = annotationValue;
        this._overridePathSpecStr = pathSpecStr;
        this._annotationType = annotationType;
        this._pathToAnnotatedTarget = new ArrayList<String>(pathToAnnotatedTarget);
        this._annotatedTarget = annotatedTarget;
    }

    boolean isOverride() {
        return new HashSet<AnnotationType>(Arrays.asList(AnnotationType.OVERRIDE_RECORD_FIELD, AnnotationType.OVERRIDE_RECORD_INCLUDE, AnnotationType.OVERRIDE_TYPE_REF_OVERRIDE)).contains((Object)this._annotationType);
    }

    ArrayDeque<String> getMatchedPaths() {
        return this._matchedPaths;
    }

    ArrayDeque<String> getRemainingPaths() {
        return this._remainingPaths;
    }

    Object getAnnotationValue() {
        return this._annotationValue;
    }

    void setMatchedPaths(ArrayDeque<String> matchedPaths) {
        this._matchedPaths = matchedPaths;
    }

    void setRemainingPaths(ArrayDeque<String> remainingPaths) {
        this._remainingPaths = remainingPaths;
    }

    void setAnnotationValue(Object annotationValue) {
        this._annotationValue = annotationValue;
    }

    String getStartSchemaName() {
        return this._startSchemaName;
    }

    void setStartSchemaName(String startSchemaName) {
        this._startSchemaName = startSchemaName;
    }

    String getOverridePathSpecStr() {
        return this._overridePathSpecStr;
    }

    public AnnotationType getAnnotationType() {
        return this._annotationType;
    }

    List<String> getPathToAnnotatedTarget() {
        return this._pathToAnnotatedTarget;
    }

    public Object getAnnotatedTarget() {
        return this._annotatedTarget;
    }

    static enum AnnotationType {
        OVERRIDE_RECORD_FIELD,
        OVERRIDE_RECORD_INCLUDE,
        OVERRIDE_TYPE_REF_OVERRIDE,
        NON_OVERRIDE_TYPE_REF,
        NON_OVERRIDE_ENUM,
        NON_OVERRIDE_FIXED,
        NON_OVERRIDE_RECORD_FIELD;

    }

    static enum OverridePathValidStatus {
        UNCHECKED,
        VALID,
        INVALID;

    }
}

