/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataComplexTable;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.Instrumentable;
import com.linkedin.data.InstrumentationUtil;
import com.linkedin.data.Null;
import com.linkedin.util.ArgumentUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Data {
    private static final Object TRAVERSAL_INDICATOR = new Object();
    private static final CycleChecker NO_OP_CYCLE_CHECKER = new CycleChecker(){};
    private static Supplier<CycleChecker> CYCLE_CHECKER_SUPPLIER = () -> {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled ? DefaultCycleChecker.SHARED_INSTANCE : NO_OP_CYCLE_CHECKER;
    };
    public static final Null NULL = Null.getInstance();
    public static final Charset UTF_8_CHARSET = StandardCharsets.UTF_8;
    public static final Map<Class<?>, Byte> TYPE_MAP = new HashMap();

    public static void setCycleCheckerSupplier(Supplier<CycleChecker> supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("Cycle checker supplier cannot be null");
        }
        CYCLE_CHECKER_SUPPLIER = supplier;
    }

    public static void traverse(Object obj, TraverseCallback callback) throws IOException {
        CycleChecker cycleChecker = CYCLE_CHECKER_SUPPLIER.get();
        if (cycleChecker == null) {
            throw new IllegalArgumentException("Supplier returned a null cycle checker");
        }
        Data.traverse(obj, callback, cycleChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void traverse(Object obj, TraverseCallback callback, CycleChecker cycleChecker) throws IOException {
        if (obj == null || obj == NULL) {
            callback.nullValue();
            return;
        }
        switch (obj.getClass().getName()) {
            case "java.lang.String": {
                callback.stringValue((String)obj);
                return;
            }
            case "java.lang.Integer": {
                callback.integerValue((Integer)obj);
                return;
            }
            case "com.linkedin.data.DataMap": {
                DataMap map = (DataMap)obj;
                if (map.isEmpty()) {
                    callback.emptyMap();
                    return;
                }
                try {
                    cycleChecker.startMap(map);
                    callback.startMap(map);
                    Iterable<Map.Entry<String, Object>> orderedEntrySet = callback.orderMap(map);
                    if (orderedEntrySet == null) {
                        try {
                            map.forEach((key, value) -> {
                                try {
                                    callback.key((String)key);
                                    Data.traverse(value, callback, cycleChecker);
                                    callback.endKey((String)key);
                                }
                                catch (IOException e) {
                                    throw new IllegalStateException(e);
                                }
                            });
                        }
                        catch (IllegalStateException e) {
                            if (!(e.getCause() instanceof IOException)) throw new IOException(e);
                            throw (IOException)e.getCause();
                        }
                    } else {
                        for (Map.Entry<String, Object> entry : orderedEntrySet) {
                            callback.key(entry.getKey());
                            Data.traverse(entry.getValue(), callback, cycleChecker);
                            callback.endKey(entry.getKey());
                        }
                    }
                    callback.endMap();
                    return;
                }
                finally {
                    cycleChecker.endMap(map);
                }
            }
            case "com.linkedin.data.DataList": {
                DataList list = (DataList)obj;
                if (list.isEmpty()) {
                    callback.emptyList();
                    return;
                }
                try {
                    cycleChecker.startList(list);
                    callback.startList(list);
                    int[] index = new int[]{0};
                    try {
                        list.forEach(element -> {
                            try {
                                callback.index(index[0]);
                                Data.traverse(element, callback, cycleChecker);
                                index[0] = index[0] + 1;
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        });
                    }
                    catch (IllegalStateException e) {
                        if (!(e.getCause() instanceof IOException)) throw new IOException(e);
                        throw (IOException)e.getCause();
                    }
                    callback.endList();
                    return;
                }
                finally {
                    cycleChecker.endList(list);
                }
            }
            case "java.lang.Boolean": {
                callback.booleanValue((Boolean)obj);
                return;
            }
            case "java.lang.Long": {
                callback.longValue((Long)obj);
                return;
            }
            case "java.lang.Float": {
                callback.floatValue(((Float)obj).floatValue());
                return;
            }
            case "java.lang.Double": {
                callback.doubleValue((Double)obj);
                return;
            }
            case "com.linkedin.data.ByteString": {
                callback.byteStringValue((ByteString)obj);
                return;
            }
        }
        callback.illegalValue(obj);
    }

    public static void dump(String name, Object obj, String prefix, StringBuilder builder) {
        try {
            Data.traverse(obj, new DumpTraverseCallback(name, prefix, builder));
        }
        catch (IOException e) {
            builder.append("( Exception: ").append(e).append(" )");
        }
    }

    public static String dump(String name, Object obj, String prefix) {
        StringBuilder builder = new StringBuilder();
        Data.dump(name, obj, prefix, builder);
        return builder.toString();
    }

    public static List<Map.Entry<String, Object>> orderMapEntries(DataMap map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
    }

    static void checkAllowed(DataComplex parent, Object value) throws IllegalArgumentException {
        ArgumentUtil.notNull(value, "value");
        Class<?> clas = value.getClass();
        if (!Data.isPrimitiveClass(clas)) {
            if (Data.isComplex(value)) {
                if (parent == value || Data.reachable((DataComplex)value, parent)) {
                    throw new IllegalArgumentException("Adding value to Data object will result in a loop");
                }
            } else {
                throw new IllegalArgumentException("Type is not allowed: " + clas);
            }
        }
    }

    private static boolean reachable(DataComplex source, Object destination) {
        Collection<Object> values = source.values();
        for (Object value : values) {
            if (value != destination && (!(value instanceof DataComplex) || !Data.reachable((DataComplex)value, destination))) continue;
            return true;
        }
        return false;
    }

    static boolean isAllowed(Object o) {
        return o != null && (Data.isPrimitive(o) || Data.isComplex(o));
    }

    static boolean isAllowedClass(Class<?> clas) {
        return Data.isPrimitiveClass(clas) || Data.isComplexClass(clas);
    }

    static boolean isPrimitive(Object o) {
        return Data.isPrimitiveClass(o.getClass());
    }

    static boolean isPrimitiveClass(Class<?> clas) {
        return clas == String.class || clas == Integer.class || clas == Double.class || clas == Boolean.class || clas == Long.class || clas == Float.class || clas == ByteString.class || clas == Null.class;
    }

    static boolean isComplex(Object o) {
        return Data.isComplexClass(o.getClass());
    }

    static boolean isComplexClass(Class<?> clas) {
        return clas == DataMap.class || clas == DataList.class;
    }

    static <T> T copy(T object, DataComplexTable alreadyCopied) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        if (Data.isComplex(object)) {
            DataComplex src = (DataComplex)object;
            DataComplex found = alreadyCopied.get(src);
            if (found != null) {
                return (T)found;
            }
            DataComplex clone = src.clone();
            alreadyCopied.put(src, clone);
            if (clone instanceof DataMap) {
                ((DataMap)clone).copyReferencedObjects(alreadyCopied);
            } else if (clone instanceof DataList) {
                ((DataList)clone).copyReferencedObjects(alreadyCopied);
            }
            DataComplex converted = clone;
            return (T)converted;
        }
        if (Data.isPrimitive(object)) {
            return object;
        }
        throw new CloneNotSupportedException("Illegal value encountered: " + object);
    }

    static void makeReadOnly(Object o) {
        if (Data.isComplex(o)) {
            ((DataComplex)o).makeReadOnly();
        }
    }

    public static String bytesToString(byte[] input, int offset, int length) {
        return new String(Data.bytesToCharArray(input, offset, length));
    }

    public static char[] bytesToCharArray(byte[] input, int offset, int length) {
        char[] charArray = new char[length];
        Data.bytesToCharArray(input, offset, length, charArray, 0);
        return charArray;
    }

    public static void bytesToCharArray(byte[] input, int offset, int length, char[] dest, int destOffset) {
        ArgumentUtil.checkBounds(input.length, offset, length);
        ArgumentUtil.checkBounds(dest.length, destOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[destOffset++] = (char)((char)input[i + offset] & 0xFF);
        }
    }

    public static String bytesToString(byte[] input) {
        return Data.bytesToString(input, 0, input.length);
    }

    public static byte[] stringToBytes(String input, boolean validate) {
        int orChar = 0;
        int length = input.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            orChar = (char)(orChar | c);
            bytes[i] = (byte)(c & 0xFF);
        }
        if (validate && (orChar & 0xFF00) != 0) {
            return null;
        }
        return bytes;
    }

    public static boolean validStringAsBytes(String input) {
        int orChar = 0;
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            orChar = (char)(orChar | c);
        }
        return (orChar & 0xFF00) == 0;
    }

    static boolean objectIsAcyclic(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> klass = object.getClass();
        if (Data.isPrimitiveClass(klass)) {
            return true;
        }
        if (Data.isComplexClass(klass)) {
            DataComplex complex = (DataComplex)object;
            try {
                Data.traverse(complex, new TraverseCallback(){});
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        throw new IllegalStateException("Object of unknown type: " + object);
    }

    public static void appendNames(StringBuilder builder, Collection<Object> names) {
        boolean first = true;
        for (Object name : names) {
            if (name instanceof Integer) {
                builder.append('[').append(name).append(']');
            } else {
                if (!first) {
                    builder.append('.');
                }
                builder.append(name);
            }
            first = false;
        }
    }

    static void startInstrumentingAccess(Collection<Object> c) {
        for (Object o : c) {
            if (!(o instanceof Instrumentable)) continue;
            ((Instrumentable)o).startInstrumentingAccess();
        }
    }

    static void stopInstrumentingAccess(Collection<Object> c) {
        for (Object o : c) {
            if (!(o instanceof Instrumentable)) continue;
            ((Instrumentable)o).stopInstrumentingAccess();
        }
    }

    static void collectInstrumentedData(StringBuilder key, Object object, Integer timesAccessed, Map<String, Map<String, Object>> instrumentedData, boolean collectAllData) {
        if (Data.isComplex(object)) {
            ((DataComplex)object).collectInstrumentedData(key, instrumentedData, collectAllData);
        } else if (collectAllData || timesAccessed > 0) {
            InstrumentationUtil.emitInstrumentationData(key, object, timesAccessed, instrumentedData);
        }
    }

    static {
        TYPE_MAP.put(String.class, (byte)1);
        TYPE_MAP.put(Integer.class, (byte)2);
        TYPE_MAP.put(DataMap.class, (byte)3);
        TYPE_MAP.put(DataList.class, (byte)4);
        TYPE_MAP.put(Boolean.class, (byte)5);
        TYPE_MAP.put(Long.class, (byte)6);
        TYPE_MAP.put(Float.class, (byte)7);
        TYPE_MAP.put(Double.class, (byte)8);
        TYPE_MAP.put(ByteString.class, (byte)9);
    }

    public static class DumpTraverseCallback
    implements TraverseCallback {
        protected final StringBuilder _builder;
        protected String _prefix;
        protected String _indent = "  ";
        protected String _nameValueSeparator = " : ";
        protected String _listStart = "[";
        protected String _listEnd = "]";
        protected String _mapStart = "{";
        protected String _mapEnd = "}";
        protected String _break = "\n";
        protected String _null = "NULL";

        DumpTraverseCallback(String name, String prefix, StringBuilder builder) {
            this._prefix = prefix;
            this._builder = builder;
            this._builder.append(this._prefix);
            if (name != null && !name.isEmpty()) {
                this._builder.append(name).append(this._nameValueSeparator);
            }
        }

        @Override
        public Iterable<Map.Entry<String, Object>> orderMap(DataMap map) {
            return Data.orderMapEntries(map);
        }

        @Override
        public void nullValue() {
            this._builder.append(this._null).append(this._break);
        }

        @Override
        public void booleanValue(boolean value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void integerValue(int value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void longValue(long value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void floatValue(float value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void doubleValue(double value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void stringValue(String value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void byteStringValue(ByteString value) {
            this._builder.append(value.asAvroString()).append(this._break);
        }

        @Override
        public void illegalValue(Object value) {
            this._builder.append("ILLEGAL VALUE \"").append(value).append("\"");
        }

        @Override
        public void emptyMap() {
            this._builder.append(this._mapStart).append(this._mapEnd).append(this._break);
        }

        @Override
        public void startMap(DataMap map) {
            this._builder.append(this._mapStart).append(this._break);
            this.indent();
        }

        @Override
        public void key(String key) {
            this._builder.append(this._prefix).append(key).append(this._nameValueSeparator);
        }

        @Override
        public void endMap() {
            this.outdent();
            this._builder.append(this._prefix).append(this._mapEnd).append(this._break);
        }

        @Override
        public void emptyList() {
            this._builder.append(this._listStart).append(this._listEnd).append(this._break);
        }

        @Override
        public void startList(DataList list) {
            this._builder.append(this._listStart).append(this._break);
            this.indent();
        }

        @Override
        public void index(int index) {
            this._builder.append(this._prefix);
        }

        @Override
        public void endList() {
            this.outdent();
            this._builder.append(this._prefix).append(this._listEnd).append(this._break);
        }

        protected void indent() {
            if (!this._indent.isEmpty()) {
                this._prefix = this._prefix + this._indent;
            }
        }

        protected void outdent() {
            if (!this._indent.isEmpty()) {
                this._prefix = this._prefix.substring(0, this._prefix.length() - this._indent.length());
            }
        }

        StringBuilder getStringBuilder() {
            return this._builder;
        }
    }

    public static interface TraverseCallback
    extends Closeable {
        default public Iterable<Map.Entry<String, Object>> orderMap(DataMap map) {
            return null;
        }

        default public void nullValue() throws IOException {
        }

        default public void booleanValue(boolean value) throws IOException {
        }

        default public void integerValue(int value) throws IOException {
        }

        default public void longValue(long value) throws IOException {
        }

        default public void floatValue(float value) throws IOException {
        }

        default public void doubleValue(double value) throws IOException {
        }

        default public void stringValue(String value) throws IOException {
        }

        default public void byteStringValue(ByteString value) throws IOException {
        }

        default public void illegalValue(Object value) throws IOException {
        }

        default public void emptyMap() throws IOException {
        }

        default public void startMap(DataMap map) throws IOException {
        }

        default public void key(String key) throws IOException {
        }

        default public void endKey(String key) throws IOException {
        }

        default public void endMap() throws IOException {
        }

        default public void emptyList() throws IOException {
        }

        default public void startList(DataList list) throws IOException {
        }

        default public void index(int index) throws IOException {
        }

        default public void endList() throws IOException {
        }

        @Override
        default public void close() throws IOException {
        }
    }

    private static class DefaultCycleChecker
    implements CycleChecker {
        private static final CycleChecker SHARED_INSTANCE = new DefaultCycleChecker();

        private DefaultCycleChecker() {
        }

        @Override
        public void startMap(DataMap map) throws IOException {
            if (map.isTraversing().get() == TRAVERSAL_INDICATOR) {
                throw new IOException("Cycle detected!");
            }
            map.isTraversing().set(TRAVERSAL_INDICATOR);
        }

        @Override
        public void endMap(DataMap map) throws IOException {
            map.isTraversing().set(null);
        }

        @Override
        public void startList(DataList list) throws IOException {
            if (list.isTraversing().get() == TRAVERSAL_INDICATOR) {
                throw new IOException("Cycle detected!");
            }
            list.isTraversing().set(TRAVERSAL_INDICATOR);
        }

        @Override
        public void endList(DataList list) throws IOException {
            list.isTraversing().set(null);
        }
    }

    public static interface CycleChecker {
        default public void startMap(DataMap map) throws IOException {
        }

        default public void endMap(DataMap map) throws IOException {
        }

        default public void startList(DataList list) throws IOException {
        }

        default public void endList(DataList list) throws IOException {
        }
    }
}

