/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.container;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Container
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.container/**Link from an asset to its parent container*/@Aspect.name=\"container\"record Container{/**The parent container of an asset*/@Relationship={\"entityTypes\":[\"container\"],\"name\":\"IsPartOf\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"container\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Container\",\"hasValuesFieldName\":\"hasContainer\"}container:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}", SchemaFormatType.PDL);
    private Urn _containerField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Container = SCHEMA.getField("container");

    public Container() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public Container(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasContainer() {
        if (this._containerField != null) {
            return true;
        }
        return this._map.containsKey("container");
    }

    public void removeContainer() {
        this._map.remove("container");
    }

    @Nullable
    public Urn getContainer(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getContainer();
            }
            case DEFAULT: 
            case NULL: {
                if (this._containerField != null) {
                    return this._containerField;
                }
                Object __rawValue = this._map.get("container");
                this._containerField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._containerField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getContainer() {
        if (this._containerField != null) {
            return this._containerField;
        }
        Object __rawValue = this._map.get("container");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("container");
        }
        this._containerField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._containerField;
    }

    public Container setContainer(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContainer(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field container of com.linkedin.container.Container");
                }
                CheckedUtil.putWithoutChecking(this._map, "container", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._containerField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContainer();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "container", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._containerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "container", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._containerField = value;
            }
        }
        return this;
    }

    public Container setContainer(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field container of com.linkedin.container.Container to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "container", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._containerField = value;
        return this;
    }

    @Override
    public Container clone() throws CloneNotSupportedException {
        Container __clone = (Container)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Container copy() throws CloneNotSupportedException {
        Container __copy = (Container)super.copy();
        __copy._containerField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Container __objectRef;

        private ChangeListener(Container reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "container": {
                    this.__objectRef._containerField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec container() {
            return new PathSpec(this.getPathComponents(), "container");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withContainer() {
            this.getDataMap().put("container", 1);
            return this;
        }
    }
}

