/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncidentSummaryDetails
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Summary statistics about incidents on an entity.*/record IncidentSummaryDetails{/**The urn of the incident*/urn:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The type of an incident*/type:string/**The time at which the incident was raised in milliseconds since epoch.*/createdAt:long/**The time at which the incident was marked as resolved in milliseconds since epoch. Null if the incident is still active.*/resolvedAt:optional long/**The priority of the incident*/priority:optional int}", SchemaFormatType.PDL);
    private Urn _urnField = null;
    private String _typeField = null;
    private Long _createdAtField = null;
    private Long _resolvedAtField = null;
    private Integer _priorityField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_CreatedAt = SCHEMA.getField("createdAt");
    private static final RecordDataSchema.Field FIELD_ResolvedAt = SCHEMA.getField("resolvedAt");
    private static final RecordDataSchema.Field FIELD_Priority = SCHEMA.getField("priority");

    public IncidentSummaryDetails() {
        super(new DataMap(7, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public IncidentSummaryDetails(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public Urn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._urnField;
    }

    public IncidentSummaryDetails setUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.common.IncidentSummaryDetails");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public IncidentSummaryDetails setUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.common.IncidentSummaryDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public IncidentSummaryDetails setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.common.IncidentSummaryDetails");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public IncidentSummaryDetails setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.common.IncidentSummaryDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasCreatedAt() {
        if (this._createdAtField != null) {
            return true;
        }
        return this._map.containsKey("createdAt");
    }

    public void removeCreatedAt() {
        this._map.remove("createdAt");
    }

    @Nullable
    public Long getCreatedAt(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreatedAt();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdAtField != null) {
                    return this._createdAtField;
                }
                Object __rawValue = this._map.get("createdAt");
                this._createdAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._createdAtField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getCreatedAt() {
        if (this._createdAtField != null) {
            return this._createdAtField;
        }
        Object __rawValue = this._map.get("createdAt");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("createdAt");
        }
        this._createdAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._createdAtField;
    }

    public IncidentSummaryDetails setCreatedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreatedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field createdAt of com.linkedin.common.IncidentSummaryDetails");
                }
                CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
                this._createdAtField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreatedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
                this._createdAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
                this._createdAtField = value;
            }
        }
        return this;
    }

    public IncidentSummaryDetails setCreatedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createdAt of com.linkedin.common.IncidentSummaryDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
        this._createdAtField = value;
        return this;
    }

    public IncidentSummaryDetails setCreatedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
        this._createdAtField = value;
        return this;
    }

    public boolean hasResolvedAt() {
        if (this._resolvedAtField != null) {
            return true;
        }
        return this._map.containsKey("resolvedAt");
    }

    public void removeResolvedAt() {
        this._map.remove("resolvedAt");
    }

    @Nullable
    public Long getResolvedAt(GetMode mode) {
        return this.getResolvedAt();
    }

    @Nullable
    public Long getResolvedAt() {
        if (this._resolvedAtField != null) {
            return this._resolvedAtField;
        }
        Object __rawValue = this._map.get("resolvedAt");
        this._resolvedAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._resolvedAtField;
    }

    public IncidentSummaryDetails setResolvedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResolvedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResolvedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resolvedAt", DataTemplateUtil.coerceLongInput(value));
                this._resolvedAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resolvedAt", DataTemplateUtil.coerceLongInput(value));
                this._resolvedAtField = value;
            }
        }
        return this;
    }

    public IncidentSummaryDetails setResolvedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resolvedAt of com.linkedin.common.IncidentSummaryDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resolvedAt", DataTemplateUtil.coerceLongInput(value));
        this._resolvedAtField = value;
        return this;
    }

    public IncidentSummaryDetails setResolvedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "resolvedAt", DataTemplateUtil.coerceLongInput(value));
        this._resolvedAtField = value;
        return this;
    }

    public boolean hasPriority() {
        if (this._priorityField != null) {
            return true;
        }
        return this._map.containsKey("priority");
    }

    public void removePriority() {
        this._map.remove("priority");
    }

    @Nullable
    public Integer getPriority(GetMode mode) {
        return this.getPriority();
    }

    @Nullable
    public Integer getPriority() {
        if (this._priorityField != null) {
            return this._priorityField;
        }
        Object __rawValue = this._map.get("priority");
        this._priorityField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._priorityField;
    }

    public IncidentSummaryDetails setPriority(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPriority(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePriority();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
                this._priorityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
                this._priorityField = value;
            }
        }
        return this;
    }

    public IncidentSummaryDetails setPriority(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field priority of com.linkedin.common.IncidentSummaryDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
        this._priorityField = value;
        return this;
    }

    public IncidentSummaryDetails setPriority(int value) {
        CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
        this._priorityField = value;
        return this;
    }

    @Override
    public IncidentSummaryDetails clone() throws CloneNotSupportedException {
        IncidentSummaryDetails __clone = (IncidentSummaryDetails)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncidentSummaryDetails copy() throws CloneNotSupportedException {
        IncidentSummaryDetails __copy = (IncidentSummaryDetails)super.copy();
        __copy._urnField = null;
        __copy._createdAtField = null;
        __copy._resolvedAtField = null;
        __copy._typeField = null;
        __copy._priorityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncidentSummaryDetails __objectRef;

        private ChangeListener(IncidentSummaryDetails reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "createdAt": {
                    this.__objectRef._createdAtField = null;
                    break;
                }
                case "resolvedAt": {
                    this.__objectRef._resolvedAtField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "priority": {
                    this.__objectRef._priorityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec createdAt() {
            return new PathSpec(this.getPathComponents(), "createdAt");
        }

        public PathSpec resolvedAt() {
            return new PathSpec(this.getPathComponents(), "resolvedAt");
        }

        public PathSpec priority() {
            return new PathSpec(this.getPathComponents(), "priority");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withCreatedAt() {
            this.getDataMap().put("createdAt", 1);
            return this;
        }

        public ProjectionMask withResolvedAt() {
            this.getDataMap().put("resolvedAt", 1);
            return this;
        }

        public ProjectionMask withPriority() {
            this.getDataMap().put("priority", 1);
            return this;
        }
    }
}

