/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.FieldTransformType;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTransform
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Definition of a transform applied to the values of a column / field.\nNote that the applicability of a field transform ultimately depends on the native type\nof the field / column.\n\nModel has single field to permit extension.*/record FieldTransform{/**The type of the field transform, e.g. the transformation\nfunction / operator to apply.*/type:enum FieldTransformType{/**Obtain the length of a string field / column (applicable to string types)*/LENGTH}}", SchemaFormatType.PDL);
    private FieldTransformType _typeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");

    public FieldTransform() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public FieldTransform(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public FieldTransformType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FieldTransformType.class, FieldTransformType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FieldTransformType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FieldTransformType.class, FieldTransformType.$UNKNOWN);
        return this._typeField;
    }

    public FieldTransform setType(@Nullable FieldTransformType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.FieldTransform");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public FieldTransform setType(@Nonnull FieldTransformType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.FieldTransform to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    @Override
    public FieldTransform clone() throws CloneNotSupportedException {
        FieldTransform __clone = (FieldTransform)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FieldTransform copy() throws CloneNotSupportedException {
        FieldTransform __copy = (FieldTransform)super.copy();
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FieldTransform __objectRef;

        private ChangeListener(FieldTransform reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }
    }
}

