/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionSourceType;
import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssertionSource
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**The source of an assertion*/record AssertionSource{/**The type of the Assertion Source*/@Searchable.fieldName=\"sourceType\"type:enum AssertionSourceType{/**The assertion was defined natively on DataHub by a user.\nDataHub Cloud only*/NATIVE/**The assertion was defined and managed externally of DataHub.*/EXTERNAL/**The assertion was inferred, e.g. from offline AI / ML models.\nDataHub Cloud only*/INFERRED}/**The time at which the assertion was initially created and the author who created it.\nThis field is only present for Native assertions created after this field was introduced.*/created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private AssertionSourceType _typeField = null;
    private AuditStamp _createdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");

    public AssertionSource() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public AssertionSource(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public AssertionSourceType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionSourceType.class, AssertionSourceType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionSourceType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionSourceType.class, AssertionSourceType.$UNKNOWN);
        return this._typeField;
    }

    public AssertionSource setType(@Nullable AssertionSourceType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.AssertionSource");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public AssertionSource setType(@Nonnull AssertionSourceType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.AssertionSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public AssertionSource setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public AssertionSource setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.assertion.AssertionSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    @Override
    public AssertionSource clone() throws CloneNotSupportedException {
        AssertionSource __clone = (AssertionSource)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AssertionSource copy() throws CloneNotSupportedException {
        AssertionSource __copy = (AssertionSource)super.copy();
        __copy._createdField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AssertionSource __objectRef;

        private ChangeListener(AssertionSource reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }
    }
}

