/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util.validator;

import com.datahub.util.validator.ValidationUtils;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public final class DeltaValidator {
    private static final Set<Class<? extends RecordTemplate>> VALIDATED = ConcurrentHashMap.newKeySet();

    private DeltaValidator() {
    }

    public static void validateDeltaSchema(@Nonnull RecordDataSchema schema) {
        String className = schema.getBindingName();
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, ValidationUtils::isValidUrnField)) {
            ValidationUtils.invalidSchema("Delta '%s' must contain an non-optional 'urn' field of URN type", className);
        }
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, DeltaValidator::isValidDeltaField)) {
            ValidationUtils.invalidSchema("Delta '%s' must contain an non-optional 'delta' field of UNION type", className);
        }
    }

    public static void validateDeltaSchema(@Nonnull Class<? extends RecordTemplate> clazz) {
        if (VALIDATED.contains(clazz)) {
            return;
        }
        DeltaValidator.validateDeltaSchema(ValidationUtils.getRecordSchema(clazz));
        VALIDATED.add(clazz);
    }

    private static boolean isValidDeltaField(@Nonnull RecordDataSchema.Field field) {
        return field.getName().equals("delta") && !field.getOptional() && field.getType().getType() == DataSchema.Type.UNION;
    }
}

