/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.notebook;

import com.linkedin.common.ChangeAuditStamps;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommonCellAttributes
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.notebook/**Common attributes for a cell in a Notebook*/record CommonCellAttributes{/**Title of the cell*/cellTitle:optional string/**Unique id for the cell. This id should be globally unique for a Notebook tool even when there are multiple deployments of it. As an example, Notebook URL could be used here for QueryBook such as 'querybook.com/notebook/773/?cellId=1234'*/cellId:string/**Captures information about who created/last modified/deleted this Notebook cell and when*/changeAuditStamps:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}}", SchemaFormatType.PDL);
    private String _cellTitleField = null;
    private String _cellIdField = null;
    private ChangeAuditStamps _changeAuditStampsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CellTitle = SCHEMA.getField("cellTitle");
    private static final RecordDataSchema.Field FIELD_CellId = SCHEMA.getField("cellId");
    private static final RecordDataSchema.Field FIELD_ChangeAuditStamps = SCHEMA.getField("changeAuditStamps");

    public CommonCellAttributes() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public CommonCellAttributes(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCellTitle() {
        if (this._cellTitleField != null) {
            return true;
        }
        return this._map.containsKey("cellTitle");
    }

    public void removeCellTitle() {
        this._map.remove("cellTitle");
    }

    @Nullable
    public String getCellTitle(GetMode mode) {
        return this.getCellTitle();
    }

    @Nullable
    public String getCellTitle() {
        if (this._cellTitleField != null) {
            return this._cellTitleField;
        }
        Object __rawValue = this._map.get("cellTitle");
        this._cellTitleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._cellTitleField;
    }

    public CommonCellAttributes setCellTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCellTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCellTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cellTitle", value);
                this._cellTitleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cellTitle", value);
                this._cellTitleField = value;
            }
        }
        return this;
    }

    public CommonCellAttributes setCellTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cellTitle of com.linkedin.notebook.CommonCellAttributes to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cellTitle", value);
        this._cellTitleField = value;
        return this;
    }

    public boolean hasCellId() {
        if (this._cellIdField != null) {
            return true;
        }
        return this._map.containsKey("cellId");
    }

    public void removeCellId() {
        this._map.remove("cellId");
    }

    @Nullable
    public String getCellId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCellId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._cellIdField != null) {
                    return this._cellIdField;
                }
                Object __rawValue = this._map.get("cellId");
                this._cellIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._cellIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getCellId() {
        if (this._cellIdField != null) {
            return this._cellIdField;
        }
        Object __rawValue = this._map.get("cellId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("cellId");
        }
        this._cellIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._cellIdField;
    }

    public CommonCellAttributes setCellId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCellId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field cellId of com.linkedin.notebook.CommonCellAttributes");
                }
                CheckedUtil.putWithoutChecking(this._map, "cellId", value);
                this._cellIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCellId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cellId", value);
                this._cellIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cellId", value);
                this._cellIdField = value;
            }
        }
        return this;
    }

    public CommonCellAttributes setCellId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cellId of com.linkedin.notebook.CommonCellAttributes to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cellId", value);
        this._cellIdField = value;
        return this;
    }

    public boolean hasChangeAuditStamps() {
        if (this._changeAuditStampsField != null) {
            return true;
        }
        return this._map.containsKey("changeAuditStamps");
    }

    public void removeChangeAuditStamps() {
        this._map.remove("changeAuditStamps");
    }

    @Nullable
    public ChangeAuditStamps getChangeAuditStamps(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getChangeAuditStamps();
            }
            case DEFAULT: 
            case NULL: {
                if (this._changeAuditStampsField != null) {
                    return this._changeAuditStampsField;
                }
                Object __rawValue = this._map.get("changeAuditStamps");
                this._changeAuditStampsField = __rawValue == null ? null : new ChangeAuditStamps(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._changeAuditStampsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ChangeAuditStamps getChangeAuditStamps() {
        if (this._changeAuditStampsField != null) {
            return this._changeAuditStampsField;
        }
        Object __rawValue = this._map.get("changeAuditStamps");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("changeAuditStamps");
        }
        this._changeAuditStampsField = __rawValue == null ? null : new ChangeAuditStamps(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._changeAuditStampsField;
    }

    public CommonCellAttributes setChangeAuditStamps(@Nullable ChangeAuditStamps value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChangeAuditStamps(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field changeAuditStamps of com.linkedin.notebook.CommonCellAttributes");
                }
                CheckedUtil.putWithoutChecking(this._map, "changeAuditStamps", value.data());
                this._changeAuditStampsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChangeAuditStamps();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "changeAuditStamps", value.data());
                this._changeAuditStampsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "changeAuditStamps", value.data());
                this._changeAuditStampsField = value;
            }
        }
        return this;
    }

    public CommonCellAttributes setChangeAuditStamps(@Nonnull ChangeAuditStamps value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field changeAuditStamps of com.linkedin.notebook.CommonCellAttributes to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "changeAuditStamps", value.data());
        this._changeAuditStampsField = value;
        return this;
    }

    @Override
    public CommonCellAttributes clone() throws CloneNotSupportedException {
        CommonCellAttributes __clone = (CommonCellAttributes)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CommonCellAttributes copy() throws CloneNotSupportedException {
        CommonCellAttributes __copy = (CommonCellAttributes)super.copy();
        __copy._changeAuditStampsField = null;
        __copy._cellIdField = null;
        __copy._cellTitleField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CommonCellAttributes __objectRef;

        private ChangeListener(CommonCellAttributes reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "changeAuditStamps": {
                    this.__objectRef._changeAuditStampsField = null;
                    break;
                }
                case "cellId": {
                    this.__objectRef._cellIdField = null;
                    break;
                }
                case "cellTitle": {
                    this.__objectRef._cellTitleField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec cellTitle() {
            return new PathSpec(this.getPathComponents(), "cellTitle");
        }

        public PathSpec cellId() {
            return new PathSpec(this.getPathComponents(), "cellId");
        }

        public ChangeAuditStamps.Fields changeAuditStamps() {
            return new ChangeAuditStamps.Fields(this.getPathComponents(), "changeAuditStamps");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ChangeAuditStamps.ProjectionMask _changeAuditStampsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withCellTitle() {
            this.getDataMap().put("cellTitle", 1);
            return this;
        }

        public ProjectionMask withCellId() {
            this.getDataMap().put("cellId", 1);
            return this;
        }

        public ProjectionMask withChangeAuditStamps(Function<ChangeAuditStamps.ProjectionMask, ChangeAuditStamps.ProjectionMask> nestedMask) {
            this._changeAuditStampsMask = nestedMask.apply(this._changeAuditStampsMask == null ? ChangeAuditStamps.createMask() : this._changeAuditStampsMask);
            this.getDataMap().put("changeAuditStamps", this._changeAuditStampsMask.getDataMap());
            return this;
        }

        public ProjectionMask withChangeAuditStamps(MaskMap nestedMask) {
            this.getDataMap().put("changeAuditStamps", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withChangeAuditStamps() {
            this._changeAuditStampsMask = null;
            this.getDataMap().put("changeAuditStamps", 1);
            return this;
        }
    }
}

