/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.incident;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.incident.IncidentSourceType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncidentSource
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.incident/**Information about the source of an incident raised on an asset.*/@Aspect.name=\"incidentSource\"record IncidentSource{/**Message associated with the incident*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Source\"}type:enum IncidentSourceType{/**Manually created incident, via UI or API.*/MANUAL/**An assertion has failed, triggering the incident.*/ASSERTION_FAILURE}/**Reference to an URN related to the source of an incident.*/@Searchable.fieldType=\"URN\"sourceUrn:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}", SchemaFormatType.PDL);
    private IncidentSourceType _typeField = null;
    private Urn _sourceUrnField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_SourceUrn = SCHEMA.getField("sourceUrn");

    public IncidentSource() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public IncidentSource(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public IncidentSourceType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, IncidentSourceType.class, IncidentSourceType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IncidentSourceType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, IncidentSourceType.class, IncidentSourceType.$UNKNOWN);
        return this._typeField;
    }

    public IncidentSource setType(@Nullable IncidentSourceType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.incident.IncidentSource");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public IncidentSource setType(@Nonnull IncidentSourceType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.incident.IncidentSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasSourceUrn() {
        if (this._sourceUrnField != null) {
            return true;
        }
        return this._map.containsKey("sourceUrn");
    }

    public void removeSourceUrn() {
        this._map.remove("sourceUrn");
    }

    @Nullable
    public Urn getSourceUrn(GetMode mode) {
        return this.getSourceUrn();
    }

    @Nullable
    public Urn getSourceUrn() {
        if (this._sourceUrnField != null) {
            return this._sourceUrnField;
        }
        Object __rawValue = this._map.get("sourceUrn");
        this._sourceUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._sourceUrnField;
    }

    public IncidentSource setSourceUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceUrnField = value;
            }
        }
        return this;
    }

    public IncidentSource setSourceUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceUrn of com.linkedin.incident.IncidentSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._sourceUrnField = value;
        return this;
    }

    @Override
    public IncidentSource clone() throws CloneNotSupportedException {
        IncidentSource __clone = (IncidentSource)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncidentSource copy() throws CloneNotSupportedException {
        IncidentSource __copy = (IncidentSource)super.copy();
        __copy._sourceUrnField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncidentSource __objectRef;

        private ChangeListener(IncidentSource reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "sourceUrn": {
                    this.__objectRef._sourceUrnField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec sourceUrn() {
            return new PathSpec(this.getPathComponents(), "sourceUrn");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withSourceUrn() {
            this.getDataMap().put("sourceUrn", 1);
            return this;
        }
    }
}

