/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.entitystream;

import com.linkedin.entitystream.EntityStream;
import com.linkedin.entitystream.EntityStreamImpl;
import com.linkedin.entitystream.WriteHandle;
import com.linkedin.entitystream.Writer;

public final class EntityStreams {
    private EntityStreams() {
    }

    public static <T> EntityStream<T> emptyStream() {
        return EntityStreams.newEntityStream(new Writer<T>(){
            private WriteHandle<? super T> _wh;

            @Override
            public void onInit(WriteHandle<? super T> wh) {
                this._wh = wh;
            }

            @Override
            public void onWritePossible() {
                this._wh.done();
            }

            @Override
            public void onAbort(Throwable e) {
            }
        });
    }

    public static <T> EntityStream<T> newEntityStream(Writer<? extends T> writer) {
        return new EntityStreamImpl<T>(writer);
    }
}

