/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.FineGrainedLineageArray;
import com.linkedin.dataset.UpstreamArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpstreamLineage
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Upstream lineage of a dataset*/@Aspect.name=\"upstreamLineage\"record UpstreamLineage{/**List of upstream dataset lineage information*/upstreams:array[/**Upstream lineage information about a dataset including the source reporting the lineage*/record Upstream{/**Audit stamp containing who reported the lineage and when.*/auditStamp:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**Audit stamp containing who created the lineage and when.*/created:optional com.linkedin.common.AuditStamp/**The upstream dataset the lineage points to*/@Relationship={\"createdActor\":\"upstreams/*/created/actor\",\"createdOn\":\"upstreams/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"DownstreamOf\",\"properties\":\"upstreams/*/properties\",\"updatedActor\":\"upstreams/*/auditStamp/actor\",\"updatedOn\":\"upstreams/*/auditStamp/time\",\"via\":\"upstreams/*/query\"}@Searchable={\"fieldName\":\"upstreams\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasUpstreams\",\"queryByDefault\":false}dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**The type of the lineage*/type:/**The various types of supported dataset lineage*/enum DatasetLineageType{/**Direct copy without modification*/COPY/**Transformed data with modification (format or content change)*/TRANSFORMED/**Represents a view defined on the sources e.g. Hive view defined on underlying hive tables or a Hive table pointing to a HDFS dataset or DALI view defined on multiple sources*/VIEW}/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]/**If the lineage is generated by a query, a reference to the query*/query:optional com.linkedin.common.Urn}]/** List of fine-grained lineage information, including field-level lineage*/@Relationship.`/*/upstreams/*`={\"entityTypes\":[\"dataset\",\"schemaField\"],\"name\":\"DownstreamOf\"}fineGrainedLineages:optional array[/**A fine-grained lineage from upstream fields/datasets to downstream field(s)*/record FineGrainedLineage{/**The type of upstream entity*/upstreamType:/**The type of upstream entity in a fine-grained lineage*/enum FineGrainedLineageUpstreamType{/** Indicates that this lineage is originating from upstream field(s)*/FIELD_SET/** Indicates that this lineage is originating from upstream dataset(s)*/DATASET/** Indicates that there is no upstream lineage i.e. the downstream field is not a derived field*/NONE}/**Upstream entities in the lineage*/@Searchable.`/*`={\"fieldName\":\"fineGrainedUpstreams\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasFineGrainedUpstreams\",\"queryByDefault\":false}upstreams:optional array[com.linkedin.common.Urn]/**The type of downstream field(s)*/downstreamType:/**The type of downstream field(s) in a fine-grained lineage*/enum FineGrainedLineageDownstreamType{/** Indicates that the lineage is for a single, specific, downstream field*/FIELD/** Indicates that the lineage is for a set of downstream fields*/FIELD_SET}/**Downstream fields in the lineage*/downstreams:optional array[com.linkedin.common.Urn]/**The transform operation applied to the upstream entities to produce the downstream field(s)*/transformOperation:optional string/**The confidence in this lineage between 0 (low confidence) and 1 (high confidence)*/confidenceScore:float=1.0/**The query that was used to generate this lineage. \nPresent only if the lineage was generated from a detected query.*/query:optional com.linkedin.common.Urn}]}", SchemaFormatType.PDL);
    private UpstreamArray _upstreamsField = null;
    private FineGrainedLineageArray _fineGrainedLineagesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Upstreams = SCHEMA.getField("upstreams");
    private static final RecordDataSchema.Field FIELD_FineGrainedLineages = SCHEMA.getField("fineGrainedLineages");

    public UpstreamLineage() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public UpstreamLineage(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUpstreams() {
        if (this._upstreamsField != null) {
            return true;
        }
        return this._map.containsKey("upstreams");
    }

    public void removeUpstreams() {
        this._map.remove("upstreams");
    }

    @Nullable
    public UpstreamArray getUpstreams(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUpstreams();
            }
            case DEFAULT: 
            case NULL: {
                if (this._upstreamsField != null) {
                    return this._upstreamsField;
                }
                Object __rawValue = this._map.get("upstreams");
                this._upstreamsField = __rawValue == null ? null : new UpstreamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._upstreamsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UpstreamArray getUpstreams() {
        if (this._upstreamsField != null) {
            return this._upstreamsField;
        }
        Object __rawValue = this._map.get("upstreams");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("upstreams");
        }
        this._upstreamsField = __rawValue == null ? null : new UpstreamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._upstreamsField;
    }

    public UpstreamLineage setUpstreams(@Nullable UpstreamArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUpstreams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field upstreams of com.linkedin.dataset.UpstreamLineage");
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreams", value.data());
                this._upstreamsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUpstreams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreams", value.data());
                this._upstreamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "upstreams", value.data());
                this._upstreamsField = value;
            }
        }
        return this;
    }

    public UpstreamLineage setUpstreams(@Nonnull UpstreamArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field upstreams of com.linkedin.dataset.UpstreamLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "upstreams", value.data());
        this._upstreamsField = value;
        return this;
    }

    public boolean hasFineGrainedLineages() {
        if (this._fineGrainedLineagesField != null) {
            return true;
        }
        return this._map.containsKey("fineGrainedLineages");
    }

    public void removeFineGrainedLineages() {
        this._map.remove("fineGrainedLineages");
    }

    @Nullable
    public FineGrainedLineageArray getFineGrainedLineages(GetMode mode) {
        return this.getFineGrainedLineages();
    }

    @Nullable
    public FineGrainedLineageArray getFineGrainedLineages() {
        if (this._fineGrainedLineagesField != null) {
            return this._fineGrainedLineagesField;
        }
        Object __rawValue = this._map.get("fineGrainedLineages");
        this._fineGrainedLineagesField = __rawValue == null ? null : new FineGrainedLineageArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fineGrainedLineagesField;
    }

    public UpstreamLineage setFineGrainedLineages(@Nullable FineGrainedLineageArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFineGrainedLineages(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFineGrainedLineages();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fineGrainedLineages", value.data());
                this._fineGrainedLineagesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fineGrainedLineages", value.data());
                this._fineGrainedLineagesField = value;
            }
        }
        return this;
    }

    public UpstreamLineage setFineGrainedLineages(@Nonnull FineGrainedLineageArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fineGrainedLineages of com.linkedin.dataset.UpstreamLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fineGrainedLineages", value.data());
        this._fineGrainedLineagesField = value;
        return this;
    }

    @Override
    public UpstreamLineage clone() throws CloneNotSupportedException {
        UpstreamLineage __clone = (UpstreamLineage)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public UpstreamLineage copy() throws CloneNotSupportedException {
        UpstreamLineage __copy = (UpstreamLineage)super.copy();
        __copy._upstreamsField = null;
        __copy._fineGrainedLineagesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final UpstreamLineage __objectRef;

        private ChangeListener(UpstreamLineage reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "upstreams": {
                    this.__objectRef._upstreamsField = null;
                    break;
                }
                case "fineGrainedLineages": {
                    this.__objectRef._fineGrainedLineagesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public UpstreamArray.Fields upstreams() {
            return new UpstreamArray.Fields(this.getPathComponents(), "upstreams");
        }

        public PathSpec upstreams(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "upstreams");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FineGrainedLineageArray.Fields fineGrainedLineages() {
            return new FineGrainedLineageArray.Fields(this.getPathComponents(), "fineGrainedLineages");
        }

        public PathSpec fineGrainedLineages(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fineGrainedLineages");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private UpstreamArray.ProjectionMask _upstreamsMask;
        private FineGrainedLineageArray.ProjectionMask _fineGrainedLineagesMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUpstreams(Function<UpstreamArray.ProjectionMask, UpstreamArray.ProjectionMask> nestedMask) {
            this._upstreamsMask = nestedMask.apply(this._upstreamsMask == null ? UpstreamArray.createMask() : this._upstreamsMask);
            this.getDataMap().put("upstreams", this._upstreamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withUpstreams() {
            this._upstreamsMask = null;
            this.getDataMap().put("upstreams", 1);
            return this;
        }

        public ProjectionMask withUpstreams(Function<UpstreamArray.ProjectionMask, UpstreamArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._upstreamsMask = nestedMask.apply(this._upstreamsMask == null ? UpstreamArray.createMask() : this._upstreamsMask);
            this.getDataMap().put("upstreams", this._upstreamsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("upstreams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("upstreams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUpstreams(Integer start, Integer count) {
            this._upstreamsMask = null;
            this.getDataMap().put("upstreams", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("upstreams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("upstreams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFineGrainedLineages(Function<FineGrainedLineageArray.ProjectionMask, FineGrainedLineageArray.ProjectionMask> nestedMask) {
            this._fineGrainedLineagesMask = nestedMask.apply(this._fineGrainedLineagesMask == null ? FineGrainedLineageArray.createMask() : this._fineGrainedLineagesMask);
            this.getDataMap().put("fineGrainedLineages", this._fineGrainedLineagesMask.getDataMap());
            return this;
        }

        public ProjectionMask withFineGrainedLineages() {
            this._fineGrainedLineagesMask = null;
            this.getDataMap().put("fineGrainedLineages", 1);
            return this;
        }

        public ProjectionMask withFineGrainedLineages(Function<FineGrainedLineageArray.ProjectionMask, FineGrainedLineageArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._fineGrainedLineagesMask = nestedMask.apply(this._fineGrainedLineagesMask == null ? FineGrainedLineageArray.createMask() : this._fineGrainedLineagesMask);
            this.getDataMap().put("fineGrainedLineages", this._fineGrainedLineagesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFineGrainedLineages(Integer start, Integer count) {
            this._fineGrainedLineagesMask = null;
            this.getDataMap().put("fineGrainedLineages", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fineGrainedLineages").put("$count", count);
            }
            return this;
        }
    }
}

