/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.DatasetFieldProfileArray;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetProfile
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Stats corresponding to datasets*/@Aspect={\"name\":\"datasetProfile\",\"type\":\"timeseries\"}record DatasetProfile includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{/**The total number of rows*/@Searchable={\"fieldType\":\"COUNT\",\"hasValuesFieldName\":\"hasRowCount\"}rowCount:optional long/**The total number of columns (or schema fields)*/@Searchable={\"fieldType\":\"COUNT\",\"hasValuesFieldName\":\"hasColumnCount\"}columnCount:optional long/**Profiles for each column (or schema field)*/fieldProfiles:optional array[/**Stats corresponding to fields in a dataset*/record DatasetFieldProfile{fieldPath:string,uniqueCount:optional long,uniqueProportion:optional float,nullCount:optional long,nullProportion:optional float,min:optional string,max:optional string,mean:optional string,median:optional string,stdev:optional string,quantiles:optional array[record Quantile{quantile:string,value:string}]distinctValueFrequencies:optional array[record ValueFrequency{value:string,frequency:long}]histogram:optional record Histogram{boundaries:array[string]heights:array[float]}sampleValues:optional array[string]}]/**Storage size in bytes*/@Searchable={\"fieldType\":\"COUNT\",\"hasValuesFieldName\":\"hasSizeInBytes\"}sizeInBytes:optional long}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private Long _rowCountField = null;
    private Long _columnCountField = null;
    private DatasetFieldProfileArray _fieldProfilesField = null;
    private Long _sizeInBytesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_RowCount;
    private static final RecordDataSchema.Field FIELD_ColumnCount;
    private static final RecordDataSchema.Field FIELD_FieldProfiles;
    private static final RecordDataSchema.Field FIELD_SizeInBytes;

    public DatasetProfile() {
        super(new DataMap(11, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetProfile(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public DatasetProfile setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.dataset.DatasetProfile");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public DatasetProfile setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public DatasetProfile setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public DatasetProfile setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public DatasetProfile setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public DatasetProfile setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public DatasetProfile setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public DatasetProfile setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public DatasetProfile setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasRowCount() {
        if (this._rowCountField != null) {
            return true;
        }
        return this._map.containsKey("rowCount");
    }

    public void removeRowCount() {
        this._map.remove("rowCount");
    }

    @Nullable
    public Long getRowCount(GetMode mode) {
        return this.getRowCount();
    }

    @Nullable
    public Long getRowCount() {
        if (this._rowCountField != null) {
            return this._rowCountField;
        }
        Object __rawValue = this._map.get("rowCount");
        this._rowCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._rowCountField;
    }

    public DatasetProfile setRowCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRowCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRowCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
                this._rowCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
                this._rowCountField = value;
            }
        }
        return this;
    }

    public DatasetProfile setRowCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rowCount of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
        this._rowCountField = value;
        return this;
    }

    public DatasetProfile setRowCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
        this._rowCountField = value;
        return this;
    }

    public boolean hasColumnCount() {
        if (this._columnCountField != null) {
            return true;
        }
        return this._map.containsKey("columnCount");
    }

    public void removeColumnCount() {
        this._map.remove("columnCount");
    }

    @Nullable
    public Long getColumnCount(GetMode mode) {
        return this.getColumnCount();
    }

    @Nullable
    public Long getColumnCount() {
        if (this._columnCountField != null) {
            return this._columnCountField;
        }
        Object __rawValue = this._map.get("columnCount");
        this._columnCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._columnCountField;
    }

    public DatasetProfile setColumnCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setColumnCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeColumnCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "columnCount", DataTemplateUtil.coerceLongInput(value));
                this._columnCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "columnCount", DataTemplateUtil.coerceLongInput(value));
                this._columnCountField = value;
            }
        }
        return this;
    }

    public DatasetProfile setColumnCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field columnCount of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "columnCount", DataTemplateUtil.coerceLongInput(value));
        this._columnCountField = value;
        return this;
    }

    public DatasetProfile setColumnCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "columnCount", DataTemplateUtil.coerceLongInput(value));
        this._columnCountField = value;
        return this;
    }

    public boolean hasFieldProfiles() {
        if (this._fieldProfilesField != null) {
            return true;
        }
        return this._map.containsKey("fieldProfiles");
    }

    public void removeFieldProfiles() {
        this._map.remove("fieldProfiles");
    }

    @Nullable
    public DatasetFieldProfileArray getFieldProfiles(GetMode mode) {
        return this.getFieldProfiles();
    }

    @Nullable
    public DatasetFieldProfileArray getFieldProfiles() {
        if (this._fieldProfilesField != null) {
            return this._fieldProfilesField;
        }
        Object __rawValue = this._map.get("fieldProfiles");
        this._fieldProfilesField = __rawValue == null ? null : new DatasetFieldProfileArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fieldProfilesField;
    }

    public DatasetProfile setFieldProfiles(@Nullable DatasetFieldProfileArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldProfiles(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldProfiles();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldProfiles", value.data());
                this._fieldProfilesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldProfiles", value.data());
                this._fieldProfilesField = value;
            }
        }
        return this;
    }

    public DatasetProfile setFieldProfiles(@Nonnull DatasetFieldProfileArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldProfiles of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldProfiles", value.data());
        this._fieldProfilesField = value;
        return this;
    }

    public boolean hasSizeInBytes() {
        if (this._sizeInBytesField != null) {
            return true;
        }
        return this._map.containsKey("sizeInBytes");
    }

    public void removeSizeInBytes() {
        this._map.remove("sizeInBytes");
    }

    @Nullable
    public Long getSizeInBytes(GetMode mode) {
        return this.getSizeInBytes();
    }

    @Nullable
    public Long getSizeInBytes() {
        if (this._sizeInBytesField != null) {
            return this._sizeInBytesField;
        }
        Object __rawValue = this._map.get("sizeInBytes");
        this._sizeInBytesField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._sizeInBytesField;
    }

    public DatasetProfile setSizeInBytes(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSizeInBytes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSizeInBytes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
                this._sizeInBytesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
                this._sizeInBytesField = value;
            }
        }
        return this;
    }

    public DatasetProfile setSizeInBytes(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sizeInBytes of com.linkedin.dataset.DatasetProfile to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
        this._sizeInBytesField = value;
        return this;
    }

    public DatasetProfile setSizeInBytes(long value) {
        CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
        this._sizeInBytesField = value;
        return this;
    }

    @Override
    public DatasetProfile clone() throws CloneNotSupportedException {
        DatasetProfile __clone = (DatasetProfile)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetProfile copy() throws CloneNotSupportedException {
        DatasetProfile __copy = (DatasetProfile)super.copy();
        __copy._timestampMillisField = null;
        __copy._sizeInBytesField = null;
        __copy._fieldProfilesField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._rowCountField = null;
        __copy._columnCountField = null;
        __copy._partitionSpecField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_RowCount = SCHEMA.getField("rowCount");
        FIELD_ColumnCount = SCHEMA.getField("columnCount");
        FIELD_FieldProfiles = SCHEMA.getField("fieldProfiles");
        FIELD_SizeInBytes = SCHEMA.getField("sizeInBytes");
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetProfile __objectRef;

        private ChangeListener(DatasetProfile reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "sizeInBytes": {
                    this.__objectRef._sizeInBytesField = null;
                    break;
                }
                case "fieldProfiles": {
                    this.__objectRef._fieldProfilesField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "rowCount": {
                    this.__objectRef._rowCountField = null;
                    break;
                }
                case "columnCount": {
                    this.__objectRef._columnCountField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec rowCount() {
            return new PathSpec(this.getPathComponents(), "rowCount");
        }

        public PathSpec columnCount() {
            return new PathSpec(this.getPathComponents(), "columnCount");
        }

        public DatasetFieldProfileArray.Fields fieldProfiles() {
            return new DatasetFieldProfileArray.Fields(this.getPathComponents(), "fieldProfiles");
        }

        public PathSpec fieldProfiles(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fieldProfiles");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec sizeInBytes() {
            return new PathSpec(this.getPathComponents(), "sizeInBytes");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;
        private DatasetFieldProfileArray.ProjectionMask _fieldProfilesMask;

        ProjectionMask() {
            super(11);
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withRowCount() {
            this.getDataMap().put("rowCount", 1);
            return this;
        }

        public ProjectionMask withColumnCount() {
            this.getDataMap().put("columnCount", 1);
            return this;
        }

        public ProjectionMask withFieldProfiles(Function<DatasetFieldProfileArray.ProjectionMask, DatasetFieldProfileArray.ProjectionMask> nestedMask) {
            this._fieldProfilesMask = nestedMask.apply(this._fieldProfilesMask == null ? DatasetFieldProfileArray.createMask() : this._fieldProfilesMask);
            this.getDataMap().put("fieldProfiles", this._fieldProfilesMask.getDataMap());
            return this;
        }

        public ProjectionMask withFieldProfiles() {
            this._fieldProfilesMask = null;
            this.getDataMap().put("fieldProfiles", 1);
            return this;
        }

        public ProjectionMask withFieldProfiles(Function<DatasetFieldProfileArray.ProjectionMask, DatasetFieldProfileArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._fieldProfilesMask = nestedMask.apply(this._fieldProfilesMask == null ? DatasetFieldProfileArray.createMask() : this._fieldProfilesMask);
            this.getDataMap().put("fieldProfiles", this._fieldProfilesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("fieldProfiles").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fieldProfiles").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFieldProfiles(Integer start, Integer count) {
            this._fieldProfilesMask = null;
            this.getDataMap().put("fieldProfiles", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fieldProfiles").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fieldProfiles").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSizeInBytes() {
            this.getDataMap().put("sizeInBytes", 1);
            return this;
        }
    }
}

