/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.dataset.DatasetFieldProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class DatasetFieldProfileArray
extends WrappingArrayTemplate<DatasetFieldProfile> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.dataset/**Stats corresponding to fields in a dataset*/record DatasetFieldProfile{fieldPath:string,uniqueCount:optional long,uniqueProportion:optional float,nullCount:optional long,nullProportion:optional float,min:optional string,max:optional string,mean:optional string,median:optional string,stdev:optional string,quantiles:optional array[record Quantile{quantile:string,value:string}]distinctValueFrequencies:optional array[record ValueFrequency{value:string,frequency:long}]histogram:optional record Histogram{boundaries:array[string]heights:array[float]}sampleValues:optional array[string]}}]", SchemaFormatType.PDL);

    public DatasetFieldProfileArray() {
        this(new DataList());
    }

    public DatasetFieldProfileArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public DatasetFieldProfileArray(Collection<DatasetFieldProfile> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public DatasetFieldProfileArray(DataList data) {
        super(data, SCHEMA, DatasetFieldProfile.class);
    }

    public DatasetFieldProfileArray(DatasetFieldProfile first, DatasetFieldProfile ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DatasetFieldProfileArray clone() throws CloneNotSupportedException {
        DatasetFieldProfileArray __clone = (DatasetFieldProfileArray)super.clone();
        return __clone;
    }

    @Override
    public DatasetFieldProfileArray copy() throws CloneNotSupportedException {
        DatasetFieldProfileArray __copy = (DatasetFieldProfileArray)super.copy();
        return __copy;
    }

    @Override
    protected DatasetFieldProfile coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new DatasetFieldProfile(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private DatasetFieldProfile.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<DatasetFieldProfile.ProjectionMask, DatasetFieldProfile.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? DatasetFieldProfile.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DatasetFieldProfile.Fields items() {
            return new DatasetFieldProfile.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

