/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataplatform.slack;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SlackChannel
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataplatform.slack/**Information about a Slack channel.\nNamespace for the urn of this entity should be 'slack-channel'. See GenericEntityKey.pdl for details.*/record SlackChannel{/**The unique ID of the Slack entity. I.e., memberID, or channelID.*/id:string/**The display name of the Slack entity. I.e., if this is a member, it would be the member's name.*/displayName:string/**The topic of this Slack channel, if set.*/topic:optional string}", SchemaFormatType.PDL);
    private String _idField = null;
    private String _displayNameField = null;
    private String _topicField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Id = SCHEMA.getField("id");
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_Topic = SCHEMA.getField("topic");

    public SlackChannel() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public SlackChannel(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasId() {
        if (this._idField != null) {
            return true;
        }
        return this._map.containsKey("id");
    }

    public void removeId() {
        this._map.remove("id");
    }

    @Nullable
    public String getId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._idField != null) {
                    return this._idField;
                }
                Object __rawValue = this._map.get("id");
                this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._idField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getId() {
        if (this._idField != null) {
            return this._idField;
        }
        Object __rawValue = this._map.get("id");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("id");
        }
        this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._idField;
    }

    public SlackChannel setId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field id of com.linkedin.dataplatform.slack.SlackChannel");
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
            }
        }
        return this;
    }

    public SlackChannel setId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field id of com.linkedin.dataplatform.slack.SlackChannel to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "id", value);
        this._idField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDisplayName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._displayNameField != null) {
                    return this._displayNameField;
                }
                Object __rawValue = this._map.get("displayName");
                this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._displayNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("displayName");
        }
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public SlackChannel setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field displayName of com.linkedin.dataplatform.slack.SlackChannel");
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public SlackChannel setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.dataplatform.slack.SlackChannel to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasTopic() {
        if (this._topicField != null) {
            return true;
        }
        return this._map.containsKey("topic");
    }

    public void removeTopic() {
        this._map.remove("topic");
    }

    @Nullable
    public String getTopic(GetMode mode) {
        return this.getTopic();
    }

    @Nullable
    public String getTopic() {
        if (this._topicField != null) {
            return this._topicField;
        }
        Object __rawValue = this._map.get("topic");
        this._topicField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._topicField;
    }

    public SlackChannel setTopic(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTopic(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTopic();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "topic", value);
                this._topicField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "topic", value);
                this._topicField = value;
            }
        }
        return this;
    }

    public SlackChannel setTopic(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field topic of com.linkedin.dataplatform.slack.SlackChannel to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "topic", value);
        this._topicField = value;
        return this;
    }

    @Override
    public SlackChannel clone() throws CloneNotSupportedException {
        SlackChannel __clone = (SlackChannel)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SlackChannel copy() throws CloneNotSupportedException {
        SlackChannel __copy = (SlackChannel)super.copy();
        __copy._displayNameField = null;
        __copy._topicField = null;
        __copy._idField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SlackChannel __objectRef;

        private ChangeListener(SlackChannel reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "topic": {
                    this.__objectRef._topicField = null;
                    break;
                }
                case "id": {
                    this.__objectRef._idField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec id() {
            return new PathSpec(this.getPathComponents(), "id");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec topic() {
            return new PathSpec(this.getPathComponents(), "topic");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withId() {
            this.getDataMap().put("id", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withTopic() {
            this.getDataMap().put("topic", 1);
            return this;
        }
    }
}

