/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectMapTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Map;

public final class StringMap
extends DirectMapTemplate<String> {
    private static final MapDataSchema SCHEMA = (MapDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"map\", \"values\" : \"string\" }");

    public StringMap() {
        this(new DataMap());
    }

    public StringMap(int initialCapacity) {
        this(new DataMap(initialCapacity));
    }

    public StringMap(int initialCapacity, float loadFactor) {
        this(new DataMap(initialCapacity, loadFactor));
    }

    public StringMap(Map<String, String> m4) {
        this(StringMap.newDataMapOfSize(m4.size()));
        this.putAll(m4);
    }

    public StringMap(DataMap map) {
        super(map, SCHEMA, String.class, String.class);
    }

    @Override
    public StringMap clone() throws CloneNotSupportedException {
        return (StringMap)super.clone();
    }

    @Override
    public StringMap copy() throws CloneNotSupportedException {
        return (StringMap)super.copy();
    }

    @Override
    protected Object coerceInput(String object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return object;
    }

    @Override
    protected String coerceOutput(Object object) throws TemplateOutputCastException {
        return DataTemplateUtil.coerceStringOutput(object);
    }
}

