/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PdlBuilder;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

class CompactPdlBuilder
extends PdlBuilder {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[A-Za-z0-9_\\-`]");
    private static final JacksonDataCodec JSON_CODEC = new JacksonDataCodec();
    private static final JacksonDataTemplateCodec JSON_DATA_TEMPLATE_CODEC = new JacksonDataTemplateCodec();
    private boolean _needsWhitespacePadding;
    private String _whitespaceBuffer;

    private CompactPdlBuilder(Writer writer) {
        super(writer);
    }

    @Override
    PdlBuilder write(String text) throws IOException {
        if (text != null && !text.isEmpty()) {
            boolean writeWhitespaceBuffer = this.isIdentifierCharacter(text.charAt(0));
            this.processWhitespaceBuffer(writeWhitespaceBuffer);
            super.write(text);
            this._needsWhitespacePadding = this.isIdentifierCharacter(text.charAt(text.length() - 1));
        }
        return this;
    }

    private void processWhitespaceBuffer(boolean writeBuffer) throws IOException {
        if (this._whitespaceBuffer != null && writeBuffer) {
            super.write(this._whitespaceBuffer);
        }
        this._whitespaceBuffer = null;
    }

    private boolean isIdentifierCharacter(char c) {
        return IDENTIFIER_PATTERN.matcher(Character.toString(c)).matches();
    }

    @Override
    PdlBuilder writeComma() {
        this.writeWhitespace(",");
        return this;
    }

    @Override
    PdlBuilder writeSpace() {
        this.writeWhitespace(" ");
        return this;
    }

    private void writeWhitespace(String whitespace) {
        if (this._needsWhitespacePadding) {
            this._whitespaceBuffer = whitespace;
            this._needsWhitespacePadding = false;
        }
    }

    @Override
    PdlBuilder newline() {
        this.writeComma();
        return this;
    }

    @Override
    PdlBuilder indent() {
        return this;
    }

    @Override
    PdlBuilder increaseIndent() {
        return this;
    }

    @Override
    PdlBuilder decreaseIndent() {
        return this;
    }

    @Override
    boolean writeDoc(String doc) throws IOException {
        if (StringUtils.isNotBlank(doc)) {
            this.write("/**").write(doc).write("*/");
            return true;
        }
        return false;
    }

    @Override
    PdlBuilder writeJson(Object value, DataSchema schema) throws IOException {
        if (schema != null) {
            this.write(this.toJson(value, JSON_DATA_TEMPLATE_CODEC, schema));
        } else {
            this.write(this.toJson(value, JSON_CODEC));
        }
        return this;
    }

    static {
        JSON_CODEC.setSortKeys(true);
    }

    static class Provider
    implements PdlBuilder.Provider {
        Provider() {
        }

        @Override
        public PdlBuilder newInstance(Writer writer) {
            return new CompactPdlBuilder(writer);
        }
    }
}

