/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.collections;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;

class RefCounted<T extends Cloneable>
implements Cloneable {
    protected AtomicInteger _refCount = new AtomicInteger();
    protected T _object = null;

    protected RefCounted(T object) {
        this._object = object;
        assert (object != null);
        assert (this.isSharable());
    }

    int getRefCount() {
        return this._refCount.get();
    }

    T getObject() {
        return this._object;
    }

    RefCounted<T> getMutable() throws UnsupportedOperationException {
        RefCounted o;
        if (this.isShared()) {
            try {
                o = (RefCounted)this.clone();
                this.release();
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException("Failed to clone", e);
            }
        } else {
            o = this;
        }
        return o;
    }

    protected Object clone() throws CloneNotSupportedException {
        RefCounted o = (RefCounted)super.clone();
        o._refCount = new AtomicInteger();
        assert (o.isSharable());
        Throwable exc = null;
        try {
            Method method = this._object.getClass().getMethod("clone", new Class[0]);
            Cloneable converted = (Cloneable)method.invoke(this._object, new Object[0]);
            o._object = converted;
        }
        catch (InvocationTargetException e) {
            exc = e.getCause();
        }
        catch (Exception e) {
            exc = e;
        }
        if (exc != null) {
            if (exc instanceof CloneNotSupportedException) {
                throw (CloneNotSupportedException)exc;
            }
            CloneNotSupportedException cnse = new CloneNotSupportedException();
            cnse.initCause(exc.getCause());
            throw cnse;
        }
        return o;
    }

    protected final void setSharableIfLeaked() {
        if (this.isLeaked()) {
            this.setSharable();
        }
    }

    protected final boolean isLeaked() {
        return this._refCount.get() < 0;
    }

    protected final boolean isShared() {
        return this._refCount.get() > 0;
    }

    protected final boolean isSharable() {
        return this._refCount.get() == 0;
    }

    protected final void setLeaked() {
        this._refCount.set(-1);
    }

    protected final void setSharable() {
        this._refCount.set(0);
    }

    RefCounted<T> acquire() throws UnsupportedOperationException {
        RefCounted o;
        if (this.isLeaked()) {
            try {
                o = (RefCounted)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException("Failed to clone object", e);
            }
            assert (this.isSharable());
        } else {
            this._refCount.incrementAndGet();
            o = this;
        }
        return o;
    }

    void release() {
        this._refCount.decrementAndGet();
    }
}

