/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.Data;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.ProtobufCodecOptions;
import com.linkedin.data.codec.ProtobufDataCodec;
import com.linkedin.data.codec.entitystream.AbstractDataEncoder;
import com.linkedin.data.protobuf.ProtoWriter;
import java.io.IOException;
import java.io.OutputStream;

public class ProtobufDataEncoder
extends AbstractDataEncoder {
    private final ProtobufCodecOptions _options;

    public ProtobufDataEncoder(DataMap dataMap, int bufferSize) {
        this(dataMap, bufferSize, new ProtobufCodecOptions.Builder().setProtoWriterBufferSize(bufferSize).build());
    }

    public ProtobufDataEncoder(DataList dataList, int bufferSize) {
        this(dataList, bufferSize, new ProtobufCodecOptions.Builder().setProtoWriterBufferSize(bufferSize).build());
    }

    public ProtobufDataEncoder(DataMap dataMap, int bufferSize, ProtobufCodecOptions options) {
        super(dataMap, bufferSize);
        this._options = options;
    }

    public ProtobufDataEncoder(DataList dataList, int bufferSize, ProtobufCodecOptions options) {
        super(dataList, bufferSize);
        this._options = options;
    }

    @Override
    protected Data.TraverseCallback createTraverseCallback(OutputStream out) throws IOException {
        return new ProtobufDataCodec.ProtobufTraverseCallback(new ProtoWriter(out), this._options);
    }
}

