/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.InstitutionalMemoryMetadataArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InstitutionalMemory
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity.*/@Aspect.name=\"institutionalMemory\"record InstitutionalMemory{/**List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record.*/elements:array[/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp associated with updation of this record*/updateStamp:optional AuditStamp}]}", SchemaFormatType.PDL);
    private InstitutionalMemoryMetadataArray _elementsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Elements = SCHEMA.getField("elements");

    public InstitutionalMemory() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public InstitutionalMemory(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasElements() {
        if (this._elementsField != null) {
            return true;
        }
        return this._map.containsKey("elements");
    }

    public void removeElements() {
        this._map.remove("elements");
    }

    @Nullable
    public InstitutionalMemoryMetadataArray getElements(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getElements();
            }
            case DEFAULT: 
            case NULL: {
                if (this._elementsField != null) {
                    return this._elementsField;
                }
                Object __rawValue = this._map.get("elements");
                this._elementsField = __rawValue == null ? null : new InstitutionalMemoryMetadataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._elementsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public InstitutionalMemoryMetadataArray getElements() {
        if (this._elementsField != null) {
            return this._elementsField;
        }
        Object __rawValue = this._map.get("elements");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("elements");
        }
        this._elementsField = __rawValue == null ? null : new InstitutionalMemoryMetadataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._elementsField;
    }

    public InstitutionalMemory setElements(@Nullable InstitutionalMemoryMetadataArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setElements(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field elements of com.linkedin.common.InstitutionalMemory");
                }
                CheckedUtil.putWithoutChecking(this._map, "elements", value.data());
                this._elementsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeElements();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "elements", value.data());
                this._elementsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "elements", value.data());
                this._elementsField = value;
            }
        }
        return this;
    }

    public InstitutionalMemory setElements(@Nonnull InstitutionalMemoryMetadataArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field elements of com.linkedin.common.InstitutionalMemory to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "elements", value.data());
        this._elementsField = value;
        return this;
    }

    @Override
    public InstitutionalMemory clone() throws CloneNotSupportedException {
        InstitutionalMemory __clone = (InstitutionalMemory)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public InstitutionalMemory copy() throws CloneNotSupportedException {
        InstitutionalMemory __copy = (InstitutionalMemory)super.copy();
        __copy._elementsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final InstitutionalMemory __objectRef;

        private ChangeListener(InstitutionalMemory reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "elements": {
                    this.__objectRef._elementsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public InstitutionalMemoryMetadataArray.Fields elements() {
            return new InstitutionalMemoryMetadataArray.Fields(this.getPathComponents(), "elements");
        }

        public PathSpec elements(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "elements");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private InstitutionalMemoryMetadataArray.ProjectionMask _elementsMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withElements(Function<InstitutionalMemoryMetadataArray.ProjectionMask, InstitutionalMemoryMetadataArray.ProjectionMask> nestedMask) {
            this._elementsMask = nestedMask.apply(this._elementsMask == null ? InstitutionalMemoryMetadataArray.createMask() : this._elementsMask);
            this.getDataMap().put("elements", this._elementsMask.getDataMap());
            return this;
        }

        public ProjectionMask withElements() {
            this._elementsMask = null;
            this.getDataMap().put("elements", 1);
            return this;
        }

        public ProjectionMask withElements(Function<InstitutionalMemoryMetadataArray.ProjectionMask, InstitutionalMemoryMetadataArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._elementsMask = nestedMask.apply(this._elementsMask == null ? InstitutionalMemoryMetadataArray.createMask() : this._elementsMask);
            this.getDataMap().put("elements", this._elementsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("elements").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("elements").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withElements(Integer start, Integer count) {
            this._elementsMask = null;
            this.getDataMap().put("elements", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("elements").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("elements").put("$count", count);
            }
            return this;
        }
    }
}

