/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionStdOperator;
import com.linkedin.assertion.AssertionStdParameters;
import com.linkedin.assertion.IncrementingSegmentSpec;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncrementingSegmentRowCountTotal
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining an INCREMENTING_SEGMENT_ROW_COUNT_TOTAL volume assertion.*/record IncrementingSegmentRowCountTotal{/**A specification of how the 'segment' can be derived using a column and an optional transformer function.*/segment:/**Core attributes required to identify an incrementing segment in a table. This type is mainly useful\nfor tables that constantly increase with new rows being added on a particular cadence (e.g. fact or event tables)\n\nAn incrementing segment represents a logical chunk of data which is INSERTED\ninto a dataset on a regular interval, along with the presence of a constantly-incrementing column\nvalue such as an event time, date partition, or last modified column.\n\nAn incrementing segment is principally identified by 2 key attributes combined:\n\n 1. A field or column that represents the incrementing value. New rows that are inserted will be identified using this column.\n    Note that the value of this column may not by itself represent the \"bucket\" or the \"segment\" in which the row falls.\n\n 2. [Optional] An transformer function that may be applied to the selected column value in order\n    to obtain the final \"segment identifier\" or \"bucket identifier\". Rows that have the same value after applying the transformation\n    will be grouped into the same segment, using which the final value (e.g. row count) will be determined.*/record IncrementingSegmentSpec{/**The field to use to generate segments. It must be constantly incrementing as new rows are inserted.*/field:{namespace com.linkedin.schema/**Lightweight spec used for referencing a particular schema field.\n*/record SchemaFieldSpec{/**The field path*/path:string/**The DataHub standard schema field type.*/type:string/**The native field type*/nativeType:string}}/**Optional transformer function to apply to the field in order to obtain the final segment or bucket identifier.\nIf not provided, then no operator will be applied to the field. (identity function)*/transformer:optional/**The definition of the transformer function  that should be applied to a given field / column value in a dataset\nin order to determine the segment or bucket that it belongs to, which in turn is used to evaluate\nvolume assertions.*/record IncrementingSegmentFieldTransformer{/**A 'standard' transformer type. Note that not all source systems will support all operators.*/type:enum IncrementingSegmentFieldTransformerType{/**Rounds a timestamp (in seconds) down to the start of the month.*/TIMESTAMP_MS_TO_MINUTE/**Rounds a timestamp (in milliseconds) down to the nearest hour.*/TIMESTAMP_MS_TO_HOUR/**Rounds a timestamp (in milliseconds) down to the start of the day.*/TIMESTAMP_MS_TO_DATE/**Rounds a timestamp (in milliseconds) down to the start of the month*/TIMESTAMP_MS_TO_MONTH/**Rounds a timestamp (in milliseconds) down to the start of the year*/TIMESTAMP_MS_TO_YEAR/**Rounds a numeric value down to the nearest integer.*/FLOOR/**Rounds a numeric value up to the nearest integer.*/CEILING/**A backdoor to provide a native operator type specific to a given source system like\nSnowflake, Redshift, BQ, etc.*/NATIVE}/**The 'native' transformer type, useful as a back door if a custom operator is required.\nThis field is required if the type is NATIVE.*/nativeType:optional string}}/**The operator you'd like to apply.\n\nNote that only numeric operators are valid inputs:\nGREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,\nBETWEEN.*/operator:/**A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied.*/enum AssertionStdOperator{/**Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters.*/BETWEEN/**Value being asserted is less than a max value. Requires 'value' parameter.*/LESS_THAN/**Value being asserted is less than or equal to some value. Requires 'value' parameter.*/LESS_THAN_OR_EQUAL_TO/**Value being asserted is greater than some value. Requires 'value' parameter.*/GREATER_THAN/**Value being asserted is greater than or equal to some value. Requires 'value' parameter.*/GREATER_THAN_OR_EQUAL_TO/**Value being asserted is equal to value. Requires 'value' parameter.*/EQUAL_TO/**Value being asserted is not equal to value. Requires 'value' parameter.*/NOT_EQUAL_TO/**Value being asserted is null. Requires no parameters.*/NULL/**Value being asserted is not null. Requires no parameters.*/NOT_NULL/**Value being asserted contains value. Requires 'value' parameter.*/CONTAIN/**Value being asserted ends with value. Requires 'value' parameter.*/END_WITH/**Value being asserted starts with value. Requires 'value' parameter.*/START_WITH/**Value being asserted matches the regex value. Requires 'value' parameter.*/REGEX_MATCH/**Value being asserted is one of the array values. Requires 'value' parameter.*/IN/**Value being asserted is not in one of the array values. Requires 'value' parameter.*/NOT_IN/**Value being asserted is true. Requires no parameters.*/IS_TRUE/**Value being asserted is false. Requires no parameters.*/IS_FALSE/**Other*/_NATIVE_}/**The parameters you'd like to provide as input to the operator.\n\nNote that only numeric parameter types are valid inputs: NUMBER.*/parameters:/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}}", SchemaFormatType.PDL);
    private IncrementingSegmentSpec _segmentField = null;
    private AssertionStdOperator _operatorField = null;
    private AssertionStdParameters _parametersField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Segment = SCHEMA.getField("segment");
    private static final RecordDataSchema.Field FIELD_Operator = SCHEMA.getField("operator");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");

    public IncrementingSegmentRowCountTotal() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public IncrementingSegmentRowCountTotal(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSegment() {
        if (this._segmentField != null) {
            return true;
        }
        return this._map.containsKey("segment");
    }

    public void removeSegment() {
        this._map.remove("segment");
    }

    @Nullable
    public IncrementingSegmentSpec getSegment(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSegment();
            }
            case DEFAULT: 
            case NULL: {
                if (this._segmentField != null) {
                    return this._segmentField;
                }
                Object __rawValue = this._map.get("segment");
                this._segmentField = __rawValue == null ? null : new IncrementingSegmentSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._segmentField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IncrementingSegmentSpec getSegment() {
        if (this._segmentField != null) {
            return this._segmentField;
        }
        Object __rawValue = this._map.get("segment");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("segment");
        }
        this._segmentField = __rawValue == null ? null : new IncrementingSegmentSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._segmentField;
    }

    public IncrementingSegmentRowCountTotal setSegment(@Nullable IncrementingSegmentSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSegment(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field segment of com.linkedin.assertion.IncrementingSegmentRowCountTotal");
                }
                CheckedUtil.putWithoutChecking(this._map, "segment", value.data());
                this._segmentField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSegment();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "segment", value.data());
                this._segmentField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "segment", value.data());
                this._segmentField = value;
            }
        }
        return this;
    }

    public IncrementingSegmentRowCountTotal setSegment(@Nonnull IncrementingSegmentSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field segment of com.linkedin.assertion.IncrementingSegmentRowCountTotal to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "segment", value.data());
        this._segmentField = value;
        return this;
    }

    public boolean hasOperator() {
        if (this._operatorField != null) {
            return true;
        }
        return this._map.containsKey("operator");
    }

    public void removeOperator() {
        this._map.remove("operator");
    }

    @Nullable
    public AssertionStdOperator getOperator(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperator();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operatorField != null) {
                    return this._operatorField;
                }
                Object __rawValue = this._map.get("operator");
                this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
                return this._operatorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionStdOperator getOperator() {
        if (this._operatorField != null) {
            return this._operatorField;
        }
        Object __rawValue = this._map.get("operator");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operator");
        }
        this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
        return this._operatorField;
    }

    public IncrementingSegmentRowCountTotal setOperator(@Nullable AssertionStdOperator value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperator(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operator of com.linkedin.assertion.IncrementingSegmentRowCountTotal");
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperator();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
            }
        }
        return this;
    }

    public IncrementingSegmentRowCountTotal setOperator(@Nonnull AssertionStdOperator value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operator of com.linkedin.assertion.IncrementingSegmentRowCountTotal to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
        this._operatorField = value;
        return this;
    }

    public boolean hasParameters() {
        if (this._parametersField != null) {
            return true;
        }
        return this._map.containsKey("parameters");
    }

    public void removeParameters() {
        this._map.remove("parameters");
    }

    @Nullable
    public AssertionStdParameters getParameters(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getParameters();
            }
            case DEFAULT: 
            case NULL: {
                if (this._parametersField != null) {
                    return this._parametersField;
                }
                Object __rawValue = this._map.get("parameters");
                this._parametersField = __rawValue == null ? null : new AssertionStdParameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._parametersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionStdParameters getParameters() {
        if (this._parametersField != null) {
            return this._parametersField;
        }
        Object __rawValue = this._map.get("parameters");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("parameters");
        }
        this._parametersField = __rawValue == null ? null : new AssertionStdParameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._parametersField;
    }

    public IncrementingSegmentRowCountTotal setParameters(@Nullable AssertionStdParameters value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field parameters of com.linkedin.assertion.IncrementingSegmentRowCountTotal");
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
            }
        }
        return this;
    }

    public IncrementingSegmentRowCountTotal setParameters(@Nonnull AssertionStdParameters value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parameters of com.linkedin.assertion.IncrementingSegmentRowCountTotal to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
        this._parametersField = value;
        return this;
    }

    @Override
    public IncrementingSegmentRowCountTotal clone() throws CloneNotSupportedException {
        IncrementingSegmentRowCountTotal __clone = (IncrementingSegmentRowCountTotal)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncrementingSegmentRowCountTotal copy() throws CloneNotSupportedException {
        IncrementingSegmentRowCountTotal __copy = (IncrementingSegmentRowCountTotal)super.copy();
        __copy._segmentField = null;
        __copy._parametersField = null;
        __copy._operatorField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncrementingSegmentRowCountTotal __objectRef;

        private ChangeListener(IncrementingSegmentRowCountTotal reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "segment": {
                    this.__objectRef._segmentField = null;
                    break;
                }
                case "parameters": {
                    this.__objectRef._parametersField = null;
                    break;
                }
                case "operator": {
                    this.__objectRef._operatorField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public IncrementingSegmentSpec.Fields segment() {
            return new IncrementingSegmentSpec.Fields(this.getPathComponents(), "segment");
        }

        public PathSpec operator() {
            return new PathSpec(this.getPathComponents(), "operator");
        }

        public AssertionStdParameters.Fields parameters() {
            return new AssertionStdParameters.Fields(this.getPathComponents(), "parameters");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private IncrementingSegmentSpec.ProjectionMask _segmentMask;
        private AssertionStdParameters.ProjectionMask _parametersMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withSegment(Function<IncrementingSegmentSpec.ProjectionMask, IncrementingSegmentSpec.ProjectionMask> nestedMask) {
            this._segmentMask = nestedMask.apply(this._segmentMask == null ? IncrementingSegmentSpec.createMask() : this._segmentMask);
            this.getDataMap().put("segment", this._segmentMask.getDataMap());
            return this;
        }

        public ProjectionMask withSegment() {
            this._segmentMask = null;
            this.getDataMap().put("segment", 1);
            return this;
        }

        public ProjectionMask withOperator() {
            this.getDataMap().put("operator", 1);
            return this;
        }

        public ProjectionMask withParameters(Function<AssertionStdParameters.ProjectionMask, AssertionStdParameters.ProjectionMask> nestedMask) {
            this._parametersMask = nestedMask.apply(this._parametersMask == null ? AssertionStdParameters.createMask() : this._parametersMask);
            this.getDataMap().put("parameters", this._parametersMask.getDataMap());
            return this;
        }

        public ProjectionMask withParameters() {
            this._parametersMask = null;
            this.getDataMap().put("parameters", 1);
            return this;
        }
    }
}

