/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.dataformat.smile;

import datahub.shaded.jackson.core.JsonGenerationException;
import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonProcessingException;
import datahub.shaded.jackson.core.JsonStreamContext;
import datahub.shaded.jackson.core.json.DupDetector;

public final class SmileWriteContext
extends JsonStreamContext {
    protected final SmileWriteContext _parent;
    protected DupDetector _dups;
    protected SmileWriteContext _childToRecycle;
    protected String _currentName;
    protected Object _currentValue;
    protected boolean _gotFieldId;

    protected SmileWriteContext(int type, SmileWriteContext parent, DupDetector dups, Object currentValue) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = parent == null ? 0 : parent._nestingDepth + 1;
        this._dups = dups;
        this._index = -1;
        this._currentValue = currentValue;
    }

    private SmileWriteContext reset(int type, Object currentValue) {
        this._type = type;
        this._index = -1;
        this._gotFieldId = false;
        this._currentValue = currentValue;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public SmileWriteContext withDupDetector(DupDetector dups) {
        this._dups = dups;
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static SmileWriteContext createRootContext(DupDetector dd) {
        return new SmileWriteContext(0, null, dd, null);
    }

    public SmileWriteContext createChildArrayContext(Object currentValue) {
        SmileWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SmileWriteContext(1, this, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(1, currentValue);
    }

    public SmileWriteContext createChildObjectContext(Object currentValue) {
        SmileWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SmileWriteContext(2, this, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(2, currentValue);
    }

    @Override
    public final SmileWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        if (this._gotFieldId) {
            return this._currentName;
        }
        return null;
    }

    @Override
    public boolean hasCurrentName() {
        return this._gotFieldId;
    }

    public SmileWriteContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean writeFieldName(String name) throws JsonProcessingException {
        if (this._type != 2 || this._gotFieldId) {
            return false;
        }
        this._gotFieldId = true;
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
        return true;
    }

    private final void _checkDup(DupDetector dd, String name) throws JsonProcessingException {
        if (dd.isDup(name)) {
            Object src = dd.getSource();
            throw new JsonGenerationException("Duplicate field '" + name + "'", src instanceof JsonGenerator ? (JsonGenerator)src : null);
        }
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotFieldId) {
                return false;
            }
            this._gotFieldId = false;
        }
        ++this._index;
        return true;
    }
}

