/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.ext;

import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.core.type.WritableTypeId;
import datahub.shaded.jackson.databind.BeanDescription;
import datahub.shaded.jackson.databind.BeanProperty;
import datahub.shaded.jackson.databind.JavaType;
import datahub.shaded.jackson.databind.JsonMappingException;
import datahub.shaded.jackson.databind.JsonSerializer;
import datahub.shaded.jackson.databind.SerializationConfig;
import datahub.shaded.jackson.databind.SerializerProvider;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import datahub.shaded.jackson.databind.jsontype.TypeSerializer;
import datahub.shaded.jackson.databind.ser.ContextualSerializer;
import datahub.shaded.jackson.databind.ser.Serializers;
import datahub.shaded.jackson.databind.ser.std.CalendarSerializer;
import datahub.shaded.jackson.databind.ser.std.StdSerializer;
import datahub.shaded.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.util.Calendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (Duration.class.isAssignableFrom(raw) || QName.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(raw)) {
            return XMLGregorianCalendarSerializer.instance;
        }
        return null;
    }

    public static class XMLGregorianCalendarSerializer
    extends StdSerializer<XMLGregorianCalendar>
    implements ContextualSerializer {
        static final XMLGregorianCalendarSerializer instance = new XMLGregorianCalendarSerializer();
        final JsonSerializer<Object> _delegate;

        public XMLGregorianCalendarSerializer() {
            this(CalendarSerializer.instance);
        }

        protected XMLGregorianCalendarSerializer(JsonSerializer<?> del) {
            super(XMLGregorianCalendar.class);
            this._delegate = del;
        }

        @Override
        public JsonSerializer<?> getDelegatee() {
            return this._delegate;
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, XMLGregorianCalendar value) {
            return this._delegate.isEmpty(provider, this._convert(value));
        }

        @Override
        public void serialize(XMLGregorianCalendar value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            this._delegate.serialize(this._convert(value), gen, provider);
        }

        @Override
        public void serializeWithType(XMLGregorianCalendar value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId((Object)value, XMLGregorianCalendar.class, JsonToken.VALUE_STRING));
            this.serialize(value, g2, provider);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this._delegate.acceptJsonFormatVisitor(visitor, null);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            JsonSerializer<?> ser = prov.handlePrimaryContextualization(this._delegate, property);
            if (ser != this._delegate) {
                return new XMLGregorianCalendarSerializer(ser);
            }
            return this;
        }

        protected Calendar _convert(XMLGregorianCalendar input) {
            return input == null ? null : input.toGregorianCalendar();
        }
    }
}

