/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

import com.linkedin.util.clock.Clock;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class RateLimitedLogger
implements Logger {
    private static final long INIT_TIME = -1L;
    private final Logger _loggerImpl;
    private final long _logRate;
    private final Clock _clock;
    private final AtomicLong _lastLog = new AtomicLong(-1L);

    public RateLimitedLogger(Logger loggerImpl, long logRate, Clock clock) {
        this._loggerImpl = loggerImpl;
        this._logRate = logRate;
        this._clock = clock;
    }

    @Override
    public String getName() {
        return this._loggerImpl.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this._loggerImpl.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(msg);
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(format, arguments);
        }
    }

    @Override
    public void trace(String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(msg, t2);
        }
    }

    @Override
    public void trace(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(format, obj);
        }
    }

    @Override
    public void trace(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(format, obj1, obj2);
        }
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this._loggerImpl.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, msg);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, format, arg);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, format, arg1, arg2);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, format, arguments);
        }
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, msg, t2);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._loggerImpl.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(msg);
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(format, arguments);
        }
    }

    @Override
    public void debug(String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(msg, t2);
        }
    }

    @Override
    public void debug(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(format, obj);
        }
    }

    @Override
    public void debug(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(format, obj1, obj2);
        }
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this._loggerImpl.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, msg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, format, arg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, format, arg1, arg2);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, format, arguments);
        }
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, msg, t2);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this._loggerImpl.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.info(msg);
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.info(format, arguments);
        }
    }

    @Override
    public void info(String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.info(msg, t2);
        }
    }

    @Override
    public void info(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.info(format, obj);
        }
    }

    @Override
    public void info(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.info(format, obj1, obj2);
        }
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this._loggerImpl.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, msg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, format, arg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, format, arg1, arg2);
        }
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, format, arguments);
        }
    }

    @Override
    public void info(Marker marker, String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, msg, t2);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this._loggerImpl.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(msg);
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(format, arguments);
        }
    }

    @Override
    public void warn(String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(msg, t2);
        }
    }

    @Override
    public void warn(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(format, obj);
        }
    }

    @Override
    public void warn(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(format, obj1, obj2);
        }
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this._loggerImpl.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, msg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, format, arg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, format, arg1, arg2);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, format, arguments);
        }
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, msg, t2);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this._loggerImpl.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.error(msg);
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.error(format, arguments);
        }
    }

    @Override
    public void error(String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.error(msg, t2);
        }
    }

    @Override
    public void error(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.error(format, obj);
        }
    }

    @Override
    public void error(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.error(format, obj1, obj2);
        }
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this._loggerImpl.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, msg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, format, arg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, format, arg1, arg2);
        }
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, format, arguments);
        }
    }

    @Override
    public void error(Marker marker, String msg, Throwable t2) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, msg, t2);
        }
    }

    public boolean logAllowed() {
        long now = this._clock.currentTimeMillis();
        long lastLog = this._lastLog.get();
        return (lastLog == -1L || now - lastLog >= this._logRate) && this._lastLog.compareAndSet(lastLog, now);
    }
}

