/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

import com.linkedin.data.ByteString;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class FastByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final LinkedList<byte[]> _bufferList = new LinkedList();
    private int _nextBufferSize = 0;
    private int _alreadyBufferedSize = 0;
    private int _index = 0;
    private static final int MAX_STREAM_SIZE = 0x7FFFFFF7;

    public FastByteArrayOutputStream() {
        this(256);
    }

    public FastByteArrayOutputStream(int initialBufferSize) {
        this._nextBufferSize = initialBufferSize;
    }

    @Override
    public void write(int datum) {
        if (this._bufferList.peekLast() == null || this._bufferList.getLast().length == this._index) {
            this.addBuffer(1);
        }
        this._bufferList.getLast()[this._index++] = (byte)datum;
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0 || length > 0x7FFFFFF7 - this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this._bufferList.peekLast() == null || this._bufferList.getLast().length == this._index) {
            this.addBuffer(length);
        }
        if (this._index + length > this._bufferList.getLast().length) {
            int copyLength;
            int pos = offset;
            do {
                if (this._index == this._bufferList.getLast().length) {
                    this.addBuffer(length);
                }
                if (length < (copyLength = this._bufferList.getLast().length - this._index)) {
                    copyLength = length;
                }
                System.arraycopy(data, pos, this._bufferList.getLast(), this._index, copyLength);
                pos += copyLength;
                this._index += copyLength;
            } while ((length -= copyLength) > 0);
        } else {
            System.arraycopy(data, offset, this._bufferList.getLast(), this._index, length);
            this._index += length;
        }
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public int size() {
        return this._alreadyBufferedSize + this._index;
    }

    public byte[] toByteArray() {
        if (this._bufferList.peekFirst() == null) {
            return new byte[0];
        }
        int totalSize = this.size();
        byte[] targetBuffer = new byte[totalSize];
        int pos = 0;
        Iterator iter = this._bufferList.iterator();
        while (iter.hasNext()) {
            byte[] buffer = (byte[])iter.next();
            if (iter.hasNext()) {
                System.arraycopy(buffer, 0, targetBuffer, pos, buffer.length);
                pos += buffer.length;
                continue;
            }
            System.arraycopy(buffer, 0, targetBuffer, pos, this._index);
        }
        return targetBuffer;
    }

    public ByteString toUnsafeByteString() {
        if (this._bufferList.peekFirst() == null) {
            return ByteString.empty();
        }
        return new ByteString(this._bufferList, this._index);
    }

    private void addBuffer(int minCapacity) {
        if (this._bufferList.peekLast() != null) {
            this._alreadyBufferedSize += this._index;
            this._index = 0;
        }
        if (this._nextBufferSize < minCapacity) {
            this._nextBufferSize = FastByteArrayOutputStream.nextPowerOf2(minCapacity);
        }
        if (this._nextBufferSize > 0x7FFFFFF7 - this.size()) {
            this._nextBufferSize = 0x7FFFFFF7 - this.size();
        }
        this._bufferList.add(new byte[this._nextBufferSize]);
        this._nextBufferSize *= 2;
    }

    private static int nextPowerOf2(int val) {
        --val;
        val = val >> 1 | val;
        val = val >> 2 | val;
        val = val >> 4 | val;
        val = val >> 8 | val;
        val = val >> 16 | val;
        return ++val;
    }
}

