/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

public class ArgumentUtil {
    public static void notNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name + " is null");
        }
    }

    public static void notEmpty(String str, String name) {
        ArgumentUtil.notNull(str, name);
        if (str.isEmpty()) {
            throw new IllegalArgumentException(name + " is an empty string");
        }
    }

    public static <T> T ensureNotNull(T obj, String name) {
        ArgumentUtil.notNull(obj, name);
        return obj;
    }

    public static void checkBounds(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset cannot be negative: " + offset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length cannot be negative: " + length);
        }
        if (offset + length > arrayLength) {
            throw new IndexOutOfBoundsException("index out of bound: " + (offset + length));
        }
    }

    public static void checkArgument(boolean expression, String name) {
        if (!expression) {
            throw new IllegalArgumentException("Argument " + name + " value is invalid");
        }
    }
}

