/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.retention;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.retention.TimeBasedRetention;
import com.linkedin.retention.VersionBasedRetention;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Retention
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.retention/**Base class that encapsulates different retention policies.\nOnly one of the fields should be set*/record Retention{version:optional/**Keep max N latest records*/record VersionBasedRetention{maxVersions:int}time:optional/**Keep records that are less than X seconds old*/record TimeBasedRetention{maxAgeInSeconds:int}}", SchemaFormatType.PDL);
    private VersionBasedRetention _versionField = null;
    private TimeBasedRetention _timeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");
    private static final RecordDataSchema.Field FIELD_Time = SCHEMA.getField("time");

    public Retention() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public Retention(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public VersionBasedRetention getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public VersionBasedRetention getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = __rawValue == null ? null : new VersionBasedRetention(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._versionField;
    }

    public Retention setVersion(@Nullable VersionBasedRetention value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
            }
        }
        return this;
    }

    public Retention setVersion(@Nonnull VersionBasedRetention value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.retention.Retention to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value.data());
        this._versionField = value;
        return this;
    }

    public boolean hasTime() {
        if (this._timeField != null) {
            return true;
        }
        return this._map.containsKey("time");
    }

    public void removeTime() {
        this._map.remove("time");
    }

    @Nullable
    public TimeBasedRetention getTime(GetMode mode) {
        return this.getTime();
    }

    @Nullable
    public TimeBasedRetention getTime() {
        if (this._timeField != null) {
            return this._timeField;
        }
        Object __rawValue = this._map.get("time");
        this._timeField = __rawValue == null ? null : new TimeBasedRetention(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._timeField;
    }

    public Retention setTime(@Nullable TimeBasedRetention value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTime(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTime();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "time", value.data());
                this._timeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "time", value.data());
                this._timeField = value;
            }
        }
        return this;
    }

    public Retention setTime(@Nonnull TimeBasedRetention value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field time of com.linkedin.retention.Retention to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "time", value.data());
        this._timeField = value;
        return this;
    }

    @Override
    public Retention clone() throws CloneNotSupportedException {
        Retention __clone = (Retention)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Retention copy() throws CloneNotSupportedException {
        Retention __copy = (Retention)super.copy();
        __copy._timeField = null;
        __copy._versionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Retention __objectRef;

        private ChangeListener(Retention reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "time": {
                    this.__objectRef._timeField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public VersionBasedRetention.Fields version() {
            return new VersionBasedRetention.Fields(this.getPathComponents(), "version");
        }

        public TimeBasedRetention.Fields time() {
            return new TimeBasedRetention.Fields(this.getPathComponents(), "time");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private VersionBasedRetention.ProjectionMask _versionMask;
        private TimeBasedRetention.ProjectionMask _timeMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withVersion(Function<VersionBasedRetention.ProjectionMask, VersionBasedRetention.ProjectionMask> nestedMask) {
            this._versionMask = nestedMask.apply(this._versionMask == null ? VersionBasedRetention.createMask() : this._versionMask);
            this.getDataMap().put("version", this._versionMask.getDataMap());
            return this;
        }

        public ProjectionMask withVersion() {
            this._versionMask = null;
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withTime(Function<TimeBasedRetention.ProjectionMask, TimeBasedRetention.ProjectionMask> nestedMask) {
            this._timeMask = nestedMask.apply(this._timeMask == null ? TimeBasedRetention.createMask() : this._timeMask);
            this.getDataMap().put("time", this._timeMask.getDataMap());
            return this;
        }

        public ProjectionMask withTime() {
            this._timeMask = null;
            this.getDataMap().put("time", 1);
            return this;
        }
    }
}

