/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.platformresource;

import com.linkedin.common.SerializedValue;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlatformResourceInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.platformresource/**Platform Resource Info.\nThese entities are for miscelaneous data that is used in non-core parts of the system.\nFor instance, if we want to persist & retrieve data from auxiliary integrations such as Slack or Microsoft Teams.*/@Aspect.name=\"platformResourceInfo\"record PlatformResourceInfo{/**The type of the resource. \nIntended as a loose specifier of the generic type of the resource.\nProducer is not forced to conform to a specific set of symbols for\nresource types.\nThe @PlatformResourceType enumeration offers a paved path for agreed upon\ncommon terms, but is not required to be followed.\nExample values could be: conversation, user, grant, etc.\nResource types are indexed for ease of access. \ne.g. Get me all platform resources of type user for the platform looker*/@Searchable.fieldType=\"KEYWORD\"resourceType:string/**The primary key for this platform resource.\ne.g. for a slack member this would be the memberID.\nprimary keys specified here don't need to include any additional specificity for the\n     dataPlatform\nThe @PlatformResourceKey is supposed to represent that*/@Searchable.fieldType=\"KEYWORD\"primaryKey:string/**The secondary keys this platform resource can be located by.\nI.e., for a slack member this would be email or phone.*/@Searchable.`/*`.fieldType=\"KEYWORD\"secondaryKeys:optional array[string]/**The serialized value of this platform resource item.*/value:optional{namespace com.linkedin.common/**Captures the serialized value of a (usually) schema-d blob.*/record SerializedValue{/**The serialized blob value.*/blob:bytes/**The content-type of the serialized blob value.*/contentType:enum SerializedValueContentType{JSON,BINARY}=\"JSON\"/**The schema type for the schema that models the object that was serialized\n       into the blob.\nAbsence of this field indicates that the schema is not known.\nIf the schema is known, the value should be set to the appropriate schema\ntype.\nUse the NONE value if the existing schema categories do not apply.*/schemaType:optional enum SerializedValueSchemaType{AVRO,PROTOBUF,PEGASUS,THRIFT,JSON,NONE}/**An optional reference to the schema that models the object.\ne.g., 'com.linkedin.platformresource.slack.SlackConversation'*/schemaRef:optional string}}}", SchemaFormatType.PDL);
    private String _resourceTypeField = null;
    private String _primaryKeyField = null;
    private StringArray _secondaryKeysField = null;
    private SerializedValue _valueField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ResourceType = SCHEMA.getField("resourceType");
    private static final RecordDataSchema.Field FIELD_PrimaryKey = SCHEMA.getField("primaryKey");
    private static final RecordDataSchema.Field FIELD_SecondaryKeys = SCHEMA.getField("secondaryKeys");
    private static final RecordDataSchema.Field FIELD_Value = SCHEMA.getField("value");

    public PlatformResourceInfo() {
        super(new DataMap(6, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public PlatformResourceInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasResourceType() {
        if (this._resourceTypeField != null) {
            return true;
        }
        return this._map.containsKey("resourceType");
    }

    public void removeResourceType() {
        this._map.remove("resourceType");
    }

    @Nullable
    public String getResourceType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getResourceType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._resourceTypeField != null) {
                    return this._resourceTypeField;
                }
                Object __rawValue = this._map.get("resourceType");
                this._resourceTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._resourceTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getResourceType() {
        if (this._resourceTypeField != null) {
            return this._resourceTypeField;
        }
        Object __rawValue = this._map.get("resourceType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("resourceType");
        }
        this._resourceTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._resourceTypeField;
    }

    public PlatformResourceInfo setResourceType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResourceType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field resourceType of com.linkedin.platformresource.PlatformResourceInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "resourceType", value);
                this._resourceTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResourceType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resourceType", value);
                this._resourceTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resourceType", value);
                this._resourceTypeField = value;
            }
        }
        return this;
    }

    public PlatformResourceInfo setResourceType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resourceType of com.linkedin.platformresource.PlatformResourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resourceType", value);
        this._resourceTypeField = value;
        return this;
    }

    public boolean hasPrimaryKey() {
        if (this._primaryKeyField != null) {
            return true;
        }
        return this._map.containsKey("primaryKey");
    }

    public void removePrimaryKey() {
        this._map.remove("primaryKey");
    }

    @Nullable
    public String getPrimaryKey(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPrimaryKey();
            }
            case DEFAULT: 
            case NULL: {
                if (this._primaryKeyField != null) {
                    return this._primaryKeyField;
                }
                Object __rawValue = this._map.get("primaryKey");
                this._primaryKeyField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._primaryKeyField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getPrimaryKey() {
        if (this._primaryKeyField != null) {
            return this._primaryKeyField;
        }
        Object __rawValue = this._map.get("primaryKey");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("primaryKey");
        }
        this._primaryKeyField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._primaryKeyField;
    }

    public PlatformResourceInfo setPrimaryKey(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrimaryKey(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field primaryKey of com.linkedin.platformresource.PlatformResourceInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "primaryKey", value);
                this._primaryKeyField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrimaryKey();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "primaryKey", value);
                this._primaryKeyField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "primaryKey", value);
                this._primaryKeyField = value;
            }
        }
        return this;
    }

    public PlatformResourceInfo setPrimaryKey(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field primaryKey of com.linkedin.platformresource.PlatformResourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "primaryKey", value);
        this._primaryKeyField = value;
        return this;
    }

    public boolean hasSecondaryKeys() {
        if (this._secondaryKeysField != null) {
            return true;
        }
        return this._map.containsKey("secondaryKeys");
    }

    public void removeSecondaryKeys() {
        this._map.remove("secondaryKeys");
    }

    @Nullable
    public StringArray getSecondaryKeys(GetMode mode) {
        return this.getSecondaryKeys();
    }

    @Nullable
    public StringArray getSecondaryKeys() {
        if (this._secondaryKeysField != null) {
            return this._secondaryKeysField;
        }
        Object __rawValue = this._map.get("secondaryKeys");
        this._secondaryKeysField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._secondaryKeysField;
    }

    public PlatformResourceInfo setSecondaryKeys(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSecondaryKeys(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSecondaryKeys();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "secondaryKeys", value.data());
                this._secondaryKeysField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "secondaryKeys", value.data());
                this._secondaryKeysField = value;
            }
        }
        return this;
    }

    public PlatformResourceInfo setSecondaryKeys(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field secondaryKeys of com.linkedin.platformresource.PlatformResourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "secondaryKeys", value.data());
        this._secondaryKeysField = value;
        return this;
    }

    public boolean hasValue() {
        if (this._valueField != null) {
            return true;
        }
        return this._map.containsKey("value");
    }

    public void removeValue() {
        this._map.remove("value");
    }

    @Nullable
    public SerializedValue getValue(GetMode mode) {
        return this.getValue();
    }

    @Nullable
    public SerializedValue getValue() {
        if (this._valueField != null) {
            return this._valueField;
        }
        Object __rawValue = this._map.get("value");
        this._valueField = __rawValue == null ? null : new SerializedValue(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._valueField;
    }

    public PlatformResourceInfo setValue(@Nullable SerializedValue value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
            }
        }
        return this;
    }

    public PlatformResourceInfo setValue(@Nonnull SerializedValue value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field value of com.linkedin.platformresource.PlatformResourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "value", value.data());
        this._valueField = value;
        return this;
    }

    @Override
    public PlatformResourceInfo clone() throws CloneNotSupportedException {
        PlatformResourceInfo __clone = (PlatformResourceInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PlatformResourceInfo copy() throws CloneNotSupportedException {
        PlatformResourceInfo __copy = (PlatformResourceInfo)super.copy();
        __copy._secondaryKeysField = null;
        __copy._valueField = null;
        __copy._resourceTypeField = null;
        __copy._primaryKeyField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PlatformResourceInfo __objectRef;

        private ChangeListener(PlatformResourceInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "secondaryKeys": {
                    this.__objectRef._secondaryKeysField = null;
                    break;
                }
                case "value": {
                    this.__objectRef._valueField = null;
                    break;
                }
                case "resourceType": {
                    this.__objectRef._resourceTypeField = null;
                    break;
                }
                case "primaryKey": {
                    this.__objectRef._primaryKeyField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec resourceType() {
            return new PathSpec(this.getPathComponents(), "resourceType");
        }

        public PathSpec primaryKey() {
            return new PathSpec(this.getPathComponents(), "primaryKey");
        }

        public PathSpec secondaryKeys() {
            return new PathSpec(this.getPathComponents(), "secondaryKeys");
        }

        public PathSpec secondaryKeys(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "secondaryKeys");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public SerializedValue.Fields value() {
            return new SerializedValue.Fields(this.getPathComponents(), "value");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SerializedValue.ProjectionMask _valueMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withResourceType() {
            this.getDataMap().put("resourceType", 1);
            return this;
        }

        public ProjectionMask withPrimaryKey() {
            this.getDataMap().put("primaryKey", 1);
            return this;
        }

        public ProjectionMask withSecondaryKeys() {
            this.getDataMap().put("secondaryKeys", 1);
            return this;
        }

        public ProjectionMask withSecondaryKeys(Integer start, Integer count) {
            this.getDataMap().put("secondaryKeys", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("secondaryKeys").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("secondaryKeys").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withValue(Function<SerializedValue.ProjectionMask, SerializedValue.ProjectionMask> nestedMask) {
            this._valueMask = nestedMask.apply(this._valueMask == null ? SerializedValue.createMask() : this._valueMask);
            this.getDataMap().put("value", this._valueMask.getDataMap());
            return this;
        }

        public ProjectionMask withValue() {
            this._valueMask = null;
            this.getDataMap().put("value", 1);
            return this;
        }
    }
}

