/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.mxe;

import com.linkedin.avro2pegasus.events.KafkaAuditHeader;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.snapshot.Snapshot;
import com.linkedin.mxe.MetadataAuditOperation;
import com.linkedin.mxe.SystemMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetadataAuditEvent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.mxe/**Kafka event for capturing update made to an entity's metadata.*/record MetadataAuditEvent{/**Kafka audit header. See go/kafkaauditheader for more info.*/auditHeader:optional{namespace com.linkedin.avro2pegasus.events/**This header records information about the context of an event as it is emitted into kafka and is intended to be used by the kafka audit application.  For more information see go/kafkaauditheader*/record KafkaAuditHeader{/**The time at which the event was emitted into kafka.*/@compliance=[{\"policy\":\"EVENT_TIME\"}]time:long/**The fully qualified name of the host from which the event is being emitted.*/@compliance=\"NONE\"server:string/**The instance on the server from which the event is being emitted. e.g. i001*/@compliance=\"NONE\"instance:optional string/**The name of the application from which the event is being emitted. see go/appname*/@compliance=\"NONE\"appName:string/**A unique identifier for the message*/@compliance=\"NONE\"messageId:fixed UUID 16/**The version that is being used for auditing. In version 0, the audit trail buckets events into 10 minute audit windows based on the EventHeader timestamp. In version 1, the audit trail buckets events as follows: if the schema has an outer KafkaAuditHeader, use the outer audit header timestamp for bucketing; else if the EventHeader has an inner KafkaAuditHeader use that inner audit header's timestamp for bucketing*/@compliance=\"NONE\"auditVersion:optional int/**The fabricUrn of the host from which the event is being emitted. Fabric Urn in the format of urn:li:fabric:{fabric_name}. See go/fabric.*/@compliance=\"NONE\"fabricUrn:optional string/**This is a String that the client uses to establish some kind of connection with the Kafka cluster. The exact format of it depends on specific versions of clients and brokers. This information could potentially identify the fabric and cluster with which the client is producing to or consuming from.*/@compliance=\"NONE\"clusterConnectionString:optional string}}/**Snapshot of the metadata before the update. Set to null for newly created metadata. Only the metadata aspects affected by the update are included in the snapshot.*/oldSnapshot:optional{namespace com.linkedin.metadata.snapshot/**A union of all supported metadata snapshot types.*/typeref Snapshot=union[/**A metadata snapshot for a specific Chart entity.*/@Entity={\"keyAspect\":\"chartKey\",\"name\":\"chart\"}record ChartSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Standardized chart identifier*/@java.class=\"com.linkedin.common.urn.ChartUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized chart identifier\",\"entityType\":\"chart\",\"fields\":[{\"doc\":\"The name of the dashboard tool such as looker, redash etc.\",\"maxLength\":20,\"name\":\"dashboardTool\",\"type\":\"string\"},{\"doc\":\"Unique id for the chart. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, chart URL could be used here for Looker such as 'looker.linkedin.com/looks/1234'\",\"maxLength\":200,\"name\":\"chartId\",\"type\":\"string\"}],\"maxLength\":236,\"name\":\"Chart\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref ChartUrn=string}/**The list of metadata aspects associated with the chart. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Chart*/typeref ChartAspect=union[{namespace com.linkedin.metadata.key/**Key for a Chart*/@Aspect.name=\"chartKey\"record ChartKey{/**The name of the dashboard tool such as looker, redash etc.*/@Searchable={\"boostScore\":4.0,\"fieldName\":\"tool\",\"fieldType\":\"TEXT_PARTIAL\"}dashboardTool:string/**Unique id for the chart. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, chart URL could be used here for Looker such as 'looker.linkedin.com/looks/1234'*/chartId:string}}{namespace com.linkedin.chart/**Information about a chart*/@Aspect.name=\"chartInfo\"record ChartInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Title of the chart*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}title:string/**Detailed description about the chart*/@Searchable={}description:string/**Captures information about who created/last modified/deleted this chart and when*/lastModified:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}/**URL for the chart. This could be used as an external link on DataHub to allow users access/view the chart*/@Searchable.fieldType=\"KEYWORD\"chartUrl:optional com.linkedin.common.Url/**Data sources for the chart\nDeprecated! Use inputEdges instead.*/@Relationship.`/*/string`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@deprecated,inputs:optional array[/**Input source type for a chart such as dataset or metric*/typeref ChartDataSourceType=union[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]]/**Data sources for the chart*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputEdges/*/created/actor\",\"createdOn\":\"inputEdges/*/created/time\",\"entityTypes\":[\"dataset\",\"chart\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"inputEdges/*/properties\",\"updatedActor\":\"inputEdges/*/lastModified/actor\",\"updatedOn\":\"inputEdges/*/lastModified/time\"}inputEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional Urn/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional AuditStamp/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]/**Type of the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Chart Type\"}type:optional/**The various types of charts*/enum ChartType{/**Chart showing a Bar chart*/BAR/**Chart showing a Pie chart*/PIE/**Chart showing a Scatter plot*/SCATTER/**Chart showing a table*/TABLE/**Chart showing Markdown formatted text*/TEXT,LINE,AREA,HISTOGRAM,BOX_PLOT,WORD_CLOUD,COHORT}/**Access level for the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Access Level\"}access:optional{namespace com.linkedin.common/**The various access levels*/enum AccessLevel{/**Publicly available access level*/PUBLIC/**Private availability to certain set of users*/PRIVATE}}/**The time when this chart last refreshed*/lastRefreshed:optional com.linkedin.common.Time}}{namespace com.linkedin.chart/**Information for chart query which is used for getting data of the chart*/@Aspect.name=\"chartQuery\"record ChartQuery{/**Raw query to build a chart from input datasets*/rawQuery:string/**Chart query type*/@Searchable={\"addToFilters\":true,\"fieldName\":\"queryType\",\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Query Type\"}type:enum ChartQueryType{/**LookML queries*/LOOKML/**SQL type queries*/SQL}}}{namespace com.linkedin.chart/**Stores editable changes made to properties. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines*/@Aspect.name=\"editableChartProperties\"record EditableChartProperties includes com.linkedin.common.ChangeAuditStamps{/**Edited documentation of the chart */@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:Urn/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"ownerAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"ownerAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"ownerAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]}}{namespace com.linkedin.common/**Shared aspect containing Browse Paths to be indexed for an entity.*/@Aspect.name=\"browsePaths\"record BrowsePaths{/**A list of valid browse paths for the entity.\n\nBrowse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'*/@Searchable.`/*`={\"fieldName\":\"browsePaths\",\"fieldType\":\"BROWSE_PATH\"}paths:array[string]}}{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:AuditStamp}}{namespace com.linkedin.common/**Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity.*/@Aspect.name=\"institutionalMemory\"record InstitutionalMemory{/**List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record.*/elements:array[/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:Url/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:AuditStamp/**Audit stamp associated with updation of this record*/updateStamp:optional AuditStamp/**Settings for this record*/settings:optional/**Settings related to a record of InstitutionalMemoryMetadata*/record InstitutionalMemoryMetadataSettings{/**Show record in asset preview like on entity header and search previews*/showInAssetPreview:boolean=false}}]}}{namespace com.linkedin.common/**The specific instance of the data platform that this entity belongs to*/@Aspect.name=\"dataPlatformInstance\"record DataPlatformInstance{/**Data Platform*/@Searchable={\"addToFilters\":true,\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform\"}platform:Urn/**Instance of the data platform (e.g. db instance)*/@Searchable={\"addToFilters\":true,\"fieldName\":\"platformInstance\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform Instance\"}instance:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing a Browse Path to be indexed for an entity.*/@Aspect.name=\"browsePathsV2\"record BrowsePathsV2{/**A valid browse path for the entity. This field is provided by DataHub by default.\nThis aspect is a newer version of browsePaths where we can encode more information in the path.\nThis path is also based on containers for a given entity if it has containers.\n\nThis is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.\nThese paths should not include high level info captured elsewhere ie. Platform and Environment.*/@Searchable.`/*/id`={\"fieldName\":\"browsePathV2\",\"fieldType\":\"BROWSE_PATH_V2\"}path:array[/**Represents a single level in an entity's browsePathV2*/record BrowsePathEntry{/**The ID of the browse path entry. This is what gets stored in the index.\nIf there's an urn associated with this entry, id and urn will be the same*/id:string/**Optional urn pointing to some entity in DataHub*/urn:optional Urn}]}}]}]}/**A metadata snapshot for a specific CorpGroup entity.*/@Entity={\"keyAspect\":\"corpGroupKey\",\"name\":\"corpGroup\"}record CorpGroupSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Corporate group's AD/LDAP login*/@java.class=\"com.linkedin.common.urn.CorpGroupUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Corporate group's AD/LDAP login\",\"entityType\":\"corpGroup\",\"fields\":[{\"doc\":\"The name of the AD/LDAP group.\",\"maxLength\":128,\"name\":\"groupName\",\"type\":\"string\"}],\"maxLength\":145,\"name\":\"CorpGroup\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:security\"}typeref CorpGroupUrn=string}/**The list of metadata aspects associated with the LdapUser. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a CorpGroup*/typeref CorpGroupAspect=union[{namespace com.linkedin.metadata.key/**Key for a CorpGroup*/@Aspect.name=\"corpGroupKey\"record CorpGroupKey{/**The URL-encoded name of the AD/LDAP group. Serves as a globally unique identifier within DataHub.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}name:string}}{namespace com.linkedin.identity/**Information about a Corp Group ingested from a third party source*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpGroupUrn\"],\"name\":\"corpGroupInfo\"}record CorpGroupInfo{/**The name of the group.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"TEXT_PARTIAL\",\"queryByDefault\":true}displayName:optional string/**email of this group*/email:optional{namespace com.linkedin.common,typeref EmailAddress=string}/**owners of this group\nDeprecated! Replaced by Ownership aspect.*/@Relationship.`/*`={\"entityTypes\":[\"corpuser\"],\"name\":\"OwnedBy\"}@deprecated,admins:array[{namespace com.linkedin.common/**Corporate user's AD/LDAP login*/@java.class=\"com.linkedin.common.urn.CorpuserUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Corporate user's AD/LDAP login\",\"entityType\":\"corpuser\",\"fields\":[{\"doc\":\"The name of the AD/LDAP user.\",\"maxLength\":20,\"name\":\"username\",\"type\":\"string\"}],\"maxLength\":36,\"name\":\"Corpuser\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:security\"}typeref CorpuserUrn=string}]/**List of ldap urn in this group.\nDeprecated! Replaced by GroupMembership aspect.*/@Relationship.`/*`={\"entityTypes\":[\"corpuser\"],\"name\":\"IsPartOf\"}@deprecated,members:array[com.linkedin.common.CorpuserUrn]/**List of groups in this group.\nDeprecated! This field is unused.*/@Relationship.`/*`={\"entityTypes\":[\"corpGroup\"],\"name\":\"IsPartOf\"}@deprecated,groups:array[com.linkedin.common.CorpGroupUrn]/**A description of the group.*/@Searchable.fieldType=\"TEXT_PARTIAL\"description:optional string/**Slack channel for the group*/slack:optional string/**Created Audit stamp*/@Searchable.`/time`={\"fieldName\":\"createdTime\",\"fieldType\":\"DATETIME\"}created:optional com.linkedin.common.AuditStamp}}com.linkedin.common.GlobalTags,com.linkedin.common.Status]}]}/**A metadata snapshot for a specific CorpUser entity.*/@Entity={\"keyAspect\":\"corpUserKey\",\"name\":\"corpuser\"}record CorpUserSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.CorpuserUrn/**The list of metadata aspects associated with the CorpUser. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a CorpUser*/typeref CorpUserAspect=union[{namespace com.linkedin.metadata.key/**Key for a CorpUser*/@Aspect.name=\"corpUserKey\"record CorpUserKey{/**The name of the AD/LDAP user.*/@Searchable={\"boostScore\":2.0,\"enableAutocomplete\":true,\"fieldName\":\"ldap\",\"fieldType\":\"WORD_GRAM\"}username:string}}{namespace com.linkedin.identity/**Linkedin corp user information*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserInfo\"}record CorpUserInfo includes com.linkedin.common.CustomProperties{/**Deprecated! Use CorpUserStatus instead. Whether the corpUser is active, ref: https://iwww.corp.linkedin.com/wiki/cf/display/GTSD/Accessing+Active+Directory+via+LDAP+tools*/@Searchable={\"fieldType\":\"BOOLEAN\",\"weightsPerFieldValue\":{\"true\":2.0}}active:boolean/**displayName of this user ,  e.g.  Hang Zhang(DataHQ)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}displayName:optional string/**email address of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true}email:optional com.linkedin.common.EmailAddress/**title of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true}title:optional string/**direct manager of this user*/@Relationship={\"entityTypes\":[\"corpuser\"],\"name\":\"ReportsTo\"}@Searchable={\"fieldName\":\"managerLdap\",\"fieldType\":\"URN\",\"queryByDefault\":false}managerUrn:optional com.linkedin.common.CorpuserUrn/**department id this user belong to*/departmentId:optional long/**department name this user belong to*/departmentName:optional string/**first name of this user*/firstName:optional string/**last name of this user*/lastName:optional string/**Common name of this user, format is firstName + lastName (split by a whitespace)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}fullName:optional string/**two uppercase letters country code. e.g.  US*/countryCode:optional string/**Whether the corpUser is a system user.*/@Searchable={\"fieldType\":\"BOOLEAN\",\"queryByDefault\":false}system:optional boolean=false}}{namespace com.linkedin.identity/**Linkedin corp user information that can be edited from UI*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserEditableInfo\"}record CorpUserEditableInfo{/**About me section of the user*/aboutMe:optional string/**Teams that the user belongs to e.g. Metadata*/@Searchable.`/*`.fieldType=\"TEXT\"teams:array[string]=[]/**Skills that the user possesses e.g. Machine Learning*/@Searchable.`/*`.fieldType=\"TEXT\"skills:array[string]=[]/**A URL which points to a picture which user wants to set as a profile photo*/pictureLink:com.linkedin.common.Url=\"https://raw.githubusercontent.com/datahub-project/datahub/master/datahub-web-react/src/images/default_avatar.png\"/**DataHub-native display name*/@Searchable={\"boostScore\":10.0,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}displayName:optional string/**DataHub-native Title, e.g. 'Software Engineer'*/title:optional string/**The platforms that the user commonly works with*/@Relationship.`/*`={\"entityTypes\":[\"dataPlatform\"],\"name\":\"IsUserOf\"}platforms:optional array[com.linkedin.common.Urn]/**The user's persona type, based on their role*/@Relationship={\"entityTypes\":[\"dataHubPersona\"],\"name\":\"IsPersona\"}persona:optional com.linkedin.common.Urn/**Slack handle for the user*/slack:optional string/**Phone number to contact the user*/phone:optional string/**Email address to contact the user*/email:optional string/**Information sources that have been used to populate this CorpUserEditableInfo.\nThese include platform resources, such as Slack members or Looker users.\nThey can also refer to other semantic urns in the future.*/informationSources:optional array[com.linkedin.common.Urn]}}{namespace com.linkedin.identity/**The status of the user, e.g. provisioned, active, suspended, etc.*/@Aspect.name=\"corpUserStatus\"record CorpUserStatus{/**Status of the user, e.g. PROVISIONED / ACTIVE / SUSPENDED*/@Searchable.fieldType=\"KEYWORD\"status:string/**Audit stamp containing who last modified the status and when.*/@Searchable.`/time`={\"fieldName\":\"statusLastModifiedAt\",\"fieldType\":\"COUNT\"}lastModified:com.linkedin.common.AuditStamp}}{namespace com.linkedin.identity/**Carries information about the CorpGroups a user is in.*/@Aspect.name=\"groupMembership\"record GroupMembership{@Relationship.`/*`={\"entityTypes\":[\"corpGroup\"],\"name\":\"IsMemberOfGroup\"}groups:array[com.linkedin.common.Urn]}}com.linkedin.common.GlobalTags,com.linkedin.common.Status]}]}/**A metadata snapshot for a specific Dashboard entity.*/@Entity={\"keyAspect\":\"dashboardKey\",\"name\":\"dashboard\"}record DashboardSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Standardized dashboard identifier*/@java.class=\"com.linkedin.common.urn.DashboardUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dashboard identifier\",\"entityType\":\"dashboard\",\"fields\":[{\"doc\":\"The name of the dashboard tool such as looker, redash etc.\",\"maxLength\":20,\"name\":\"dashboardTool\",\"type\":\"string\"},{\"doc\":\"Unique id for the dashboard. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, dashboard URL could be used here for Looker such as 'looker.linkedin.com/dashboards/1234'\",\"maxLength\":200,\"name\":\"dashboardId\",\"type\":\"string\"}],\"maxLength\":240,\"name\":\"Dashboard\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DashboardUrn=string}/**The list of metadat" + "a aspects associated with the dashboard. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Dashboard*/typeref DashboardAspect=union[{namespace com.linkedin.metadata.key/**Key for a Dashboard*/@Aspect.name=\"dashboardKey\"record DashboardKey{/**The name of the dashboard tool such as looker, redash etc.*/@Searchable={\"boostScore\":4.0,\"fieldName\":\"tool\",\"fieldType\":\"TEXT_PARTIAL\"}dashboardTool:string/**Unique id for the dashboard. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, dashboard URL could be used here for Looker such as 'looker.linkedin.com/dashboards/1234'*/dashboardId:string}}{namespace com.linkedin.dashboard/**Information about a dashboard*/@Aspect.name=\"dashboardInfo\"record DashboardInfo includes com.linkedin.common.CustomProperties,com.linkedin.common.ExternalReference{/**Title of the dashboard*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}title:string/**Detailed description about the dashboard*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:string/**Charts in a dashboard\nDeprecated! Use chartEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"chart\"],\"isLineage\":true,\"name\":\"Contains\"}@deprecated,charts:array[com.linkedin.common.ChartUrn]=[]/**Charts in a dashboard*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"chartEdges/*/created/actor\",\"createdOn\":\"chartEdges/*/created/time\",\"entityTypes\":[\"chart\"],\"isLineage\":true,\"name\":\"Contains\",\"properties\":\"chartEdges/*/properties\",\"updatedActor\":\"chartEdges/*/lastModified/actor\",\"updatedOn\":\"chartEdges/*/lastModified/time\"}chartEdges:optional array[com.linkedin.common.Edge]/**Datasets consumed by a dashboard\nDeprecated! Use datasetEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@deprecated,datasets:array[com.linkedin.common.Urn]=[]/**Datasets consumed by a dashboard*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"datasetEdges/*/created/actor\",\"createdOn\":\"datasetEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"datasetEdges/*/properties\",\"updatedActor\":\"datasetEdges/*/lastModified/actor\",\"updatedOn\":\"datasetEdges/*/lastModified/time\"}datasetEdges:optional array[com.linkedin.common.Edge]/**Dashboards included by this dashboard.\nSome dashboard entities (e.g. PowerBI Apps) can contain other dashboards.\n\nThe Edge's sourceUrn should never be set, as it will always be the base dashboard.*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"dashboards/*/created/actor\",\"createdOn\":\"dashboards/*/created/time\",\"entityTypes\":[\"dashboard\"],\"isLineage\":true,\"name\":\"DashboardContainsDashboard\",\"properties\":\"dashboards/*/properties\",\"updatedActor\":\"dashboards/*/lastModified/actor\",\"updatedOn\":\"dashboards/*/lastModified/time\"}dashboards:array[com.linkedin.common.Edge]=[]/**Captures information about who created/last modified/deleted this dashboard and when*/lastModified:com.linkedin.common.ChangeAuditStamps/**URL for the dashboard. This could be used as an external link on DataHub to allow users access/view the dashboard*/@Searchable.fieldType=\"KEYWORD\"dashboardUrl:optional com.linkedin.common.Url/**Access level for the dashboard*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Access Level\"}access:optional com.linkedin.common.AccessLevel/**The time when this dashboard last refreshed*/lastRefreshed:optional com.linkedin.common.Time}}{namespace com.linkedin.dashboard/**Stores editable changes made to properties. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines*/@Aspect.name=\"editableDashboardProperties\"record EditableDashboardProperties includes com.linkedin.common.ChangeAuditStamps{/**Edited documentation of the dashboard*/@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string}}com.linkedin.common.Ownership,com.linkedin.common.Status,com.linkedin.common.GlobalTags,com.linkedin.common.BrowsePaths,com.linkedin.common.GlossaryTerms,com.linkedin.common.InstitutionalMemory,com.linkedin.common.DataPlatformInstance,com.linkedin.common.BrowsePathsV2]}]}/**A metadata snapshot for a specific DataFlow entity.*/@Entity={\"keyAspect\":\"dataFlowKey\",\"name\":\"dataFlow\"}record DataFlowSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Standardized data processing flow identifier.*/@java.class=\"com.linkedin.common.urn.DataFlowUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data processing flow identifier.\",\"entityType\":\"dataFlow\",\"fields\":[{\"doc\":\"Workflow manager like azkaban, airflow which orchestrates the flow\",\"maxLength\":50,\"name\":\"orchestrator\",\"type\":\"string\"},{\"doc\":\"Unique Identifier of the data flow\",\"maxLength\":200,\"name\":\"flowId\",\"type\":\"string\"},{\"doc\":\"Cluster where the flow is executed\",\"maxLength\":100,\"name\":\"cluster\",\"type\":\"string\"}],\"maxLength\":373,\"name\":\"DataFlow\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DataFlowUrn=string}/**The list of metadata aspects associated with the data flow. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Data flow*/typeref DataFlowAspect=union[{namespace com.linkedin.metadata.key/**Key for a Data Flow*/@Aspect.name=\"dataFlowKey\"record DataFlowKey{/**Workflow manager like azkaban, airflow which orchestrates the flow*/@Searchable.fieldType=\"TEXT_PARTIAL\"orchestrator:string/**Unique Identifier of the data flow*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}flowId:string/**Cluster where the flow is executed*/@Searchable.fieldType=\"TEXT_PARTIAL\"cluster:string}}{namespace com.linkedin.datajob/**Information about a Data processing flow*/@Aspect.name=\"dataFlowInfo\"record DataFlowInfo includes com.linkedin.common.CustomProperties,com.linkedin.common.ExternalReference{/**Flow name*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Flow description*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Optional project/namespace associated with the flow*/@Searchable={\"fieldType\":\"TEXT_PARTIAL\",\"queryByDefault\":false}project:optional string/**A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}created:optional{namespace com.linkedin.common/**A standard event timestamp*/record TimeStamp{/**When did the event occur*/time:Time/**Optional: The actor urn involved in the event.*/actor:optional Urn}}/**A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:optional com.linkedin.common.TimeStamp/**Environment for this flow*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}env:optional{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}}{namespace com.linkedin.datajob/**Stores editable changes made to properties. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines*/@Aspect.name=\"editableDataFlowProperties\"record EditableDataFlowProperties includes com.linkedin.common.ChangeAuditStamps{/**Edited documentation of the data flow*/@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string}}com.linkedin.common.Ownership,com.linkedin.common.Status,com.linkedin.common.GlobalTags,com.linkedin.common.BrowsePaths,com.linkedin.common.GlossaryTerms,com.linkedin.common.InstitutionalMemory,com.linkedin.common.DataPlatformInstance,com.linkedin.common.BrowsePathsV2]}]}/**A metadata snapshot for a specific DataJob entity.*/@Entity={\"keyAspect\":\"dataJobKey\",\"name\":\"dataJob\"}record DataJobSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Standardized data processing job identifier.*/@java.class=\"com.linkedin.common.urn.DataJobUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data processing job identifier.\",\"entityType\":\"dataJob\",\"fields\":[{\"doc\":\"Standardized data processing flow urn representing the flow for the job\",\"name\":\"flow\",\"type\":\"com.linkedin.common.urn.DataFlowUrn\"},{\"doc\":\"Unique identifier of the data job\",\"maxLength\":200,\"name\":\"jobID\",\"type\":\"string\"}],\"maxLength\":594,\"name\":\"DataJob\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DataJobUrn=string}/**The list of metadata aspects associated with the data job. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Data job*/typeref DataJobAspect=union[{namespace com.linkedin.metadata.key/**Key for a Data Job*/@Aspect.name=\"dataJobKey\"record DataJobKey{/**Standardized data processing flow urn representing the flow for the job*/@Relationship={\"entityTypes\":[\"dataFlow\"],\"name\":\"IsPartOf\"}@Searchable={\"fieldName\":\"dataFlow\",\"fieldType\":\"URN_PARTIAL\",\"queryByDefault\":false}flow:com.linkedin.common.Urn/**Unique Identifier of the data job*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}jobId:string}}{namespace com.linkedin.datajob/**Information about a Data processing job*/@Aspect.name=\"dataJobInfo\"record DataJobInfo includes com.linkedin.common.CustomProperties,com.linkedin.common.ExternalReference{/**Job name*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Job description*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Datajob type\n**NOTE**: AzkabanJobType is deprecated. Please use strings instead.*/type:union[{namespace com.linkedin.datajob.azkaban/**The various types of support azkaban jobs*/enum AzkabanJobType{/**The command job type is one of the basic built-in types. It runs multiple UNIX commands using java processbuilder.\nUpon execution, Azkaban spawns off a process to run the command.*/COMMAND/**Runs a java program with ability to access Hadoop cluster.\nhttps://azkaban.readthedocs.io/en/latest/jobTypes.html#java-job-type*/HADOOP_JAVA/**In large part, this is the same Command type. The difference is its ability to talk to a Hadoop cluster\nsecurely, via Hadoop tokens.*/HADOOP_SHELL/**Hive type is for running Hive jobs.*/HIVE/**Pig type is for running Pig jobs.*/PIG/**SQL is for running Presto, mysql queries etc*/SQL/**Glue type is for running AWS Glue job transforms.*/GLUE}}string]/**DataFlow urn that this job is part of*/flowUrn:optional com.linkedin.common.DataFlowUrn/**A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}created:optional com.linkedin.common.TimeStamp/**A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:optional com.linkedin.common.TimeStamp/**Status of the job - Deprecated for Data Process Instance model.*/@deprecated=\"Use Data Process Instance model, instead\"status:optional/**Job statuses*/enum JobStatus{/**Jobs being initialized.*/STARTING/**Jobs currently running.*/IN_PROGRESS/**Jobs being stopped.*/STOPPING/**Jobs that have stopped.*/STOPPED/**Jobs with successful completion.*/COMPLETED/**Jobs that have failed.*/FAILED/**Jobs with unknown status (either unmappable or unavailable)*/UNKNOWN/**Jobs that have been skipped.*/SKIPPED}/**Environment for this job*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}env:optional com.linkedin.common.FabricType}}{namespace com.linkedin.datajob/**Information about the inputs and outputs of a Data processing job*/@Aspect.name=\"dataJobInputOutput\"record DataJobInputOutput{/**Input datasets consumed by the data job during processing\nDeprecated! Use inputDatasetEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}@deprecated,inputDatasets:array[com.linkedin.common.DatasetUrn]/**Input datasets consumed by the data job during processing*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputDatasetEdges/*/created/actor\",\"createdOn\":\"inputDatasetEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"inputDatasetEdges/*/properties\",\"updatedActor\":\"inputDatasetEdges/*/lastModified/actor\",\"updatedOn\":\"inputDatasetEdges/*/lastModified/time\"}@Searchable.`/*/destinationUrn`={\"fieldName\":\"inputDatasetEdges\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}inputDatasetEdges:optional array[com.linkedin.common.Edge]/**Output datasets produced by the data job during processing\nDeprecated! Use outputDatasetEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"Produces\"}@Searchable.`/*`={\"fieldName\":\"outputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}@deprecated,outputDatasets:array[com.linkedin.common.DatasetUrn]/**Output datasets produced by the data job during processing*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"outputDatasetEdges/*/created/actor\",\"createdOn\":\"outputDatasetEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"Produces\",\"properties\":\"outputDatasetEdges/*/properties\",\"updatedActor\":\"outputDatasetEdges/*/lastModified/actor\",\"updatedOn\":\"outputDatasetEdges/*/lastModified/time\"}@Searchable.`/*/destinationUrn`={\"fieldName\":\"outputDatasetEdges\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}outputDatasetEdges:optional array[com.linkedin.common.Edge]/**Input datajobs that this data job depends on\nDeprecated! Use inputDatajobEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\"],\"isLineage\":true,\"name\":\"DownstreamOf\"}@deprecated,inputDatajobs:optional array[com.linkedin.common.DataJobUrn]/**Input datajobs that this data job depends on*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputDatajobEdges/*/created/actor\",\"createdOn\":\"inputDatajobEdges/*/created/time\",\"entityTypes\":[\"dataJob\"],\"isLineage\":true,\"name\":\"DownstreamOf\",\"properties\":\"inputDatajobEdges/*/properties\",\"updatedActor\":\"inputDatajobEdges/*/lastModified/actor\",\"updatedOn\":\"inputDatajobEdges/*/lastModified/time\"}inputDatajobEdges:optional array[com.linkedin.common.Edge]/**Fields of the input datasets used by this job*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputFields\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputFields\",\"queryByDefault\":false}inputDatasetFields:optional array[com.linkedin.common.Urn]/**Fields of the output datasets this job writes to*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"Produces\"}@Searchable.`/*`={\"fieldName\":\"outputFields\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputFields\",\"queryByDefault\":false}outputDatasetFields:optional array[com.linkedin.common.Urn]/**Fine-grained column-level lineages\nNot currently supported in the UI\nUse UpstreamLineage aspect for datasets to express Column Level Lineage for the UI*/fineGrainedLineages:optional array[{namespace com.linkedin.dataset/**A fine-grained lineage from upstream fields/datasets to downstream field(s)*/record FineGrainedLineage{/**The type of upstream entity*/upstreamType:/**The type of upstream entity in a fine-grained lineage*/enum FineGrainedLineageUpstreamType{/** Indicates that this lineage is originating from upstream field(s)*/FIELD_SET/** Indicates that this lineage is originating from upstream dataset(s)*/DATASET/** Indicates that there is no upstream lineage i.e. the downstream field is not a derived field*/NONE}/**Upstream entities in the lineage*/@Searchable.`/*`={\"fieldName\":\"fineGrainedUpstreams\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasFineGrainedUpstreams\",\"queryByDefault\":false}upstreams:optional array[com.linkedin.common.Urn]/**The type of downstream field(s)*/downstreamType:/**The type of downstream field(s) in a fine-grained lineage*/enum FineGrainedLineageDownstreamType{/** Indicates that the lineage is for a single, specific, downstream field*/FIELD/** Indicates that the lineage is for a set of downstream fields*/FIELD_SET}/**Downstream fields in the lineage*/downstreams:optional array[com.linkedin.common.Urn]/**The transform operation applied to the upstream entities to produce the downstream field(s)*/transformOperation:optional string/**The confidence in this lineage between 0 (low confidence) and 1 (high confidence)*/confidenceScore:float=1.0/**The query that was used to generate this lineage. \nPresent only if the lineage was generated from a detected query.*/query:optional com.linkedin.common.Urn}}]}}{namespace com.linkedin.datajob/**Stores editable changes made to properties. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines*/@Aspect.name=\"editableDataJobProperties\"record EditableDataJobProperties includes com.linkedin.common.ChangeAuditStamps{/**Edited documentation of the data job */@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string}}com.linkedin.common.Ownership,com.linkedin.common.Status,com.linkedin.common.GlobalTags,com.linkedin.common.BrowsePaths,com.linkedin.common.GlossaryTerms,com.linkedin.common.InstitutionalMemory,com.linkedin.common.DataPlatformInstance,com.linkedin.common.BrowsePathsV2]}]}/**A metadata snapshot for a specific dataset entity.*/@Entity={\"keyAspect\":\"datasetKey\",\"name\":\"dataset\"}record DatasetSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.DatasetUrn/**The list of metadata aspects associated with the dataset. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Dataset*/typeref DatasetAspect=union[{namespace com.linkedin.metadata.key/**Key for a Dataset*/@Aspect.name=\"datasetKey\"record DatasetKey{/**Data platform urn associated with the dataset*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"URN\"}platform:com.linkedin.common.Urn/**Unique guid for dataset*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldName\":\"id\",\"fieldType\":\"WORD_GRAM\"}name:string/**Fabric type where dataset belongs to or where it was generated.*/@Searchable={\"addToFilters\":true,\"fieldType\":\"TEXT_PARTIAL\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}origin:com.linkedin.common.FabricType}}{namespace com.linkedin.dataset/**Properties associated with a Dataset*/@Aspect.name=\"datasetProperties\"record DatasetProperties includes com.linkedin.common.CustomProperties,com.linkedin.common.ExternalReference{/**Display name of the Dataset*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:optional string/**Fully-qualified name of the Dataset*/@Searchable={\"addToFilters\":false,\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}qualifiedName:optional string/**Documentation of the dataset*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**The abstracted URI such as hdfs:///data/tracking/PageViewEvent, file:///dir/file_name. Uri should not include any environment specific properties. Some datasets might not have a standardized uri, which makes this field optional (i.e. kafka topic).*/@deprecated=\"Use ExternalReference.externalUrl field instead.\"uri:optional{namespace com.linkedin.common@java.class=\"java.net.URI\"typeref Uri=string}/**A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}created:optional com.linkedin.common.TimeStamp/**A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:optional com.linkedin.common.TimeStamp/**[Legacy] Unstructured tags for the dataset. Structured tags can be applied via the `GlobalTags` aspect.\nThis is now deprecated.*/@deprecated=\"Use GlobalTags aspect instead.\"tags:array[string]=[]}}{namespace com.linkedin.dataset/**EditableDatasetProperties stores editable changes made to dataset properties. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines*/@Aspect.name=\"editableDatasetProperties\"record EditableDatasetProperties includes com.linkedin.common.ChangeAuditStamps{/**Documentation of the dataset*/@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string/**Editable display name of the Dataset*/@Searchable={\"fieldName\":\"editedName\",\"fieldType\":\"TEXT_PARTIAL\"}name:optional string}}{namespace com.linkedin.dataset/**Dataset deprecation status\nDeprecated! This aspect is deprecated in favor of the more-general-purpose 'Deprecation' aspect.*/@Aspect.name=\"datasetDeprecation\"@Deprecated,record DatasetDeprecation{/**Whether the dataset is deprecated by owner.*/@Searchable={\"fieldType\":\"BOOLEAN\",\"weightsPerFieldValue\":{\"true\":0.5}}deprecated:boolean/**The time user plan to decommission this dataset.*/decommissionTime:optional long/**Additional information about the dataset deprecation plan, such as the wiki, doc, RB.*/note:string/**The corpuser URN which will be credited for modifying this deprecation content.*/actor:optional com.linkedin.common.Urn}}{namespace com.linkedin.dataset/**Fine Grained upstream lineage for fields in a dataset*/@Aspect.name=\"datasetUpstreamLineage\"@deprecated=\"use UpstreamLineage.fineGrainedLineages instead\"record DatasetUpstreamLineage{/**Upstream to downstream field level lineage mappings*/fieldMappings:array[/**Representation of mapping between fields in source dataset to the field in destination dataset*/@deprecated=\"use FineGrainedLineage instead\"record DatasetFieldMapping includes{namespace com.linkedin.common/**Base model representing field mappings*/record BaseFieldMapping{/**Audit stamp containing who reported the field mapping and when*/created:AuditStamp/**Transfomration function between the fields involved*/transformation:union[{namespace com.linkedin.common.fieldtransformer/**Type of the transformation involved in generating destination fields from source fields.*/enum TransformationType{/**Field transformation expressed as unknown black box function.*/BLACKBOX/**Field transformation expressed as Identity function.*/IDENTITY}}{namespace com.linkedin.common.fieldtransformer/**Field transformation expressed in UDF*/record UDFTransformer{/**A UDF mentioning how the source fields got transformed to destination field. This is the FQCN(Fully Qualified Class Name) of the udf.*/udf:string}}]}}{/**Source fields from which the fine grained lineage is derived*/sourceFields:array[/**Upstreams of a dataset field.*/@deprecated=\"refer FineGrainedLineage for alternative representation\"typeref DatasetFieldUpstream=union[{namespace com.linkedin.common/**Standardized dataset field information identifier.*/@deprecated=\"use SchemaFieldPath and represent as generic Urn instead\"@java.class=\"com.linkedin.common.urn.DatasetFieldUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset field information identifier\",\"entityType\":\"datasetField\",\"fields\":[{\"doc\":\"Dataset that this dataset field belongs to.\",\"name\":\"dataset\",\"type\":\"com.linkedin.common.urn.DatasetUrn\"},{\"doc\":\"Dataset field path\",\"maxLength\":500,\"name\":\"fieldPath\",\"type\":\"string\"}],\"maxLength\":807,\"name\":\"DatasetField\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetFieldUrn=string}]]/**Destination field which is derived from source fields*/destinationField:com.linkedin.common.DatasetFieldUrn}]}}{namespace com.linkedin.dataset/**Upstream lineage of a dataset*/@Aspect.name=\"upstreamLineage\"record UpstreamLineage{/**List of upstream dataset lineage information*/upstreams:array[/**Upstream lineage information about a dataset including the source reporting the lineage*/record Upstream{/**Audit stamp containing who reported the lineage and when.*/auditStamp:com.linkedin.common.AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**Audit stamp containing who created the lineage and when.*/created:optional com.linkedin.common.AuditStamp/**The upstream dataset the lineage points to*/@Relationship={\"createdActor\":\"upstreams/*/created/actor\",\"createdOn\":\"upstreams/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"DownstreamOf\",\"properties\":\"upstreams/*/properties\",\"updatedActor\":\"upstreams/*/auditStamp/actor\",\"updatedOn\":\"upstreams/*/auditStamp/time\",\"via\":\"upstreams/*/query\"}@Searchable={\"fieldName\":\"upstreams\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasUpstreams\",\"queryByDefault\":false}dataset:com.linkedin.common.DatasetUrn/**The type of the lineage*/type:/**The various types of supported dataset lineage*/enum DatasetLineageType{/**Direct copy without modification*/COPY/**Transformed data with modification (format or content change)*/TRANSFORMED/**Represents a view defined on the sources e.g. Hive view defined on underlying hive tables or a Hive table pointing to a HDFS dataset or DALI view defined on multiple sources*/VIEW}/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]/**If the lineage is generated by a query, a reference to the query*/query:optional com.linkedin.common.Urn}]/** List of fine-grained lineage information, including field-level lineage*/@Relationship.`/*/upstreams/*`={\"entityTypes\":[\"dataset\",\"schemaField\"],\"name\":\"DownstreamOf\"}fineGrainedLineages:optional array[FineGrainedLineage]}}com.linkedin.common.InstitutionalMemory,com.linkedin.common.Ownership,com.linkedin.common.Status{namespace com.linkedin.schema/**SchemaMetadata to describe metadata related to store schema*/@Aspect.name=\"schemaMetadata\"record SchemaMetadata includes/**Key to retrieve schema metadata.*/record SchemaMetadataKey{/**Schema name e.g. PageViewEvent, identity.Profile, ams.account_management_tracking*/@validate.strlen={\"max\":500,\"min\":1}schemaName:string/**Standardized platform urn where schema is defined. The data platform Urn (urn:li:platform:{platform_name})*/platform:{namespace com.linkedin.common/**Standardized data platforms available*/@java.class=\"com.linkedin.common.urn.DataPlatformUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data platforms available\",\"entityType\":\"dataPlatform\",\"fields\":[{\"doc\":\"data platform name i.e. hdfs, oracle, espresso\",\"maxLength\":25,\"name\":\"platformName\",\"type\":\"string\"}],\"maxLength\":45,\"name\":\"DataPlatform\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:wherehows\"}typeref DataPlatformUrn=string}/**Every change to SchemaMetadata in the resource results in a new version. Version is server assigned. This version is differ from platform native schema version.*/version:long}com.linkedin.common.ChangeAuditStamps{/**Dataset this schema metadata is associated with.*/dataset:optional com.linkedin.common.DatasetUrn/**The cluster this schema metadata resides from*/cluster:optional string/**the SHA1 hash of the schema content*/hash:string/**The native schema in the dataset's platform.*/platformSchema:union[/**Schema text of an espresso table schema.*/record EspressoSchema{/**The native espresso document schema.*/documentSchema:string/**The espresso table schema definition.*/tableSchema:string}/**Schema holder for oracle data definition language that describes an oracle table.*/record OracleDDL{/**The native schema in the dataset's platform. This is a human readable (json blob) table schema.*/tableSchema:string}/**Schema holder for MySql data definition language that describes an MySql table.*/record MySqlDDL{/**The native schema in the dataset's platform. This is a human readable (json blob) table schema.*/tableSchema:string}/**Schema holder for presto data definition language that describes a presto view.*/record PrestoDDL{/**The raw schema in the dataset's platform. This includes the DDL and the columns extracted from DDL.*/rawSchema:string}/**Schema holder for kafka schema.*/record KafkaSchema{/**The native kafka document schema. This is a human readable avro document schema.*/documentSchema:string/**The native kafka document schema type. This can be AVRO/PROTOBUF/JSON.*/documentSchemaType:optional string/**The native kafka key schema as retrieved from Schema Registry*/keySchema:optional string/**The native kafka key schema type. This can be AVRO/PROTOBUF/JSON.*/keySchemaType:optional string}/**Schema text of binary JSON schema.*/record BinaryJsonSchema{/**The native schema text for binary JSON file format.*/schema:string}/**Schema text of an ORC schema.*/record OrcSchema{/**The native schema for ORC file format.*/schema:string}/**The dataset has no specific schema associated with it*/record Schemaless{}/**Schema text of a key-value store schema.*/record KeyValueSchema{/**The raw schema for the key in the key-value store.*/keySchema:string/**The raw schema for the value in the key-value store.*/valueSchema:string}/**Schema holder for undefined schema types.*/record OtherSchema{/**The native schema in the dataset's platform.*/rawSchema:string}]/**Client provided a list of fields from document schema.*/fields:array[/**SchemaField to describe metadata related to dataset schema.*/record SchemaField{/**Flattened name of the field. Field is computed from jsonPath field.*/@Searchable={\"boostScore\":1.0,\"fieldName\":\"fieldPaths\",\"fieldType\":\"TEXT\",\"queryByDefault\":\"true\"}fieldPath:{namespace com.linkedin.dataset/**Schema field path. TODO: Add formal documentation on normalization rules.*/typeref SchemaFieldPath=string}/**Flattened name of a field in JSON Path notation.*/@Deprecated,jsonPath:optional" + " string/**Indicates if this field is optional or nullable*/nullable:boolean=false/**Description*/@Searchable={\"boostScore\":0.1,\"fieldName\":\"fieldDescriptions\",\"fieldType\":\"TEXT\"}description:optional string/**Label of the field. Provides a more human-readable name for the field than field path. Some sources will\nprovide this metadata but not all sources have the concept of a label. If just one string is associated with\na field in a source, that is most likely a description.\n\nNote that this field is deprecated and is not surfaced in the UI.*/@Deprecated@Searchable={\"boostScore\":0.2,\"fieldName\":\"fieldLabels\",\"fieldType\":\"TEXT\"}label:optional string/**An AuditStamp corresponding to the creation of this schema field.*/created:optional com.linkedin.common.AuditStamp/**An AuditStamp corresponding to the last modification of this schema field.*/lastModified:optional com.linkedin.common.AuditStamp/**Platform independent field type of the field.*/type:/**Schema field data types*/record SchemaFieldDataType{/**Data platform specific types*/type:union[/**Boolean field type.*/record BooleanType{}/**Fixed field type.*/record FixedType{}/**String field type.*/record StringType{}/**Bytes field type.*/record BytesType{}/**Number data type: long, integer, short, etc..*/record NumberType{}/**Date field type.*/record DateType{}/**Time field type. This should also be used for datetimes.*/record TimeType{}/**Enum field type.*/record EnumType{}/**Null field type.*/record NullType{}/**Map field type.*/record MapType{/**Key type in a map*/keyType:optional string/**Type of the value in a map*/valueType:optional string}/**Array field type.*/record ArrayType{/**List of types this array holds.*/nestedType:optional array[string]}/**Union field type.*/record UnionType{/**List of types in union type.*/nestedTypes:optional array[string]}/**Record field type.*/record RecordType{}]}/**The native type of the field in the dataset's platform as declared by platform schema.*/nativeDataType:string/**There are use cases when a field in type B references type A. A field in A references field of type B. In such cases, we will mark the first field as recursive.*/recursive:boolean=false/**Tags associated with the field*/@Relationship.`/tags/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"SchemaFieldTaggedWith\"}@Searchable={\"/tags/*/attribution/actor\":{\"fieldName\":\"fieldTagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/source\":{\"fieldName\":\"fieldTagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/time\":{\"fieldName\":\"fieldTagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/tags/*/tag\":{\"boostScore\":0.5,\"fieldName\":\"fieldTags\",\"fieldType\":\"URN\"}}globalTags:optional com.linkedin.common.GlobalTags/**Glossary terms associated with the field*/@Relationship.`/terms/*/urn`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"SchemaFieldWithGlossaryTerm\"}@Searchable={\"/terms/*/attribution/actor\":{\"fieldName\":\"fieldTermAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/source\":{\"fieldName\":\"fieldTermAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/time\":{\"fieldName\":\"fieldTermAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/terms/*/urn\":{\"boostScore\":0.5,\"fieldName\":\"fieldGlossaryTerms\",\"fieldType\":\"URN\"}}glossaryTerms:optional com.linkedin.common.GlossaryTerms/**For schema fields that are part of complex keys, set this field to true\nWe do this to easily distinguish between value and key fields*/isPartOfKey:boolean=false/**For Datasets which are partitioned, this determines the partitioning key.\nNote that multiple columns can be part of a partitioning key, but currently we do not support\nrendering the ordered partitioning key.*/isPartitioningKey:optional boolean/**For schema fields that have other properties that are not modeled explicitly,\nuse this field to serialize those properties into a JSON string*/jsonProps:optional string}]/**Client provided list of fields that define primary keys to access record. Field order defines hierarchical espresso keys. Empty lists indicates absence of primary key access patter. Value is a SchemaField@fieldPath.*/primaryKeys:optional array[com.linkedin.dataset.SchemaFieldPath]/**Map captures all the references schema makes to external datasets. Map key is ForeignKeySpecName typeref.*/@deprecated=\"Use foreignKeys instead.\"foreignKeysSpecs:optional map[string/**Description of a foreign key in a schema.*/record ForeignKeySpec{/**Foreign key definition in metadata schema.*/foreignKey:union[/**For non-urn based foregin keys.*/record DatasetFieldForeignKey{/**dataset that stores the resource.*/parentDataset:com.linkedin.common.DatasetUrn/**List of fields in hosting(current) SchemaMetadata that conform a foreign key. List can contain a single entry or multiple entries if several entries in hosting schema conform a foreign key in a single parent dataset.*/currentFieldPaths:array[com.linkedin.dataset.SchemaFieldPath]/**SchemaField@fieldPath that uniquely identify field in parent dataset that this field references.*/parentField:com.linkedin.dataset.SchemaFieldPath}/**If SchemaMetadata fields make any external references and references are of type com.linkedin.common.Urn or any children, this models can be used to mark it.*/record UrnForeignKey{/**Field in hosting(current) SchemaMetadata.*/currentFieldPath:com.linkedin.dataset.SchemaFieldPath}]}]/**List of foreign key constraints for the schema*/foreignKeys:optional array[/**Description of a foreign key constraint in a schema.*/record ForeignKeyConstraint{/**Name of the constraint, likely provided from the source*/name:string/**Fields the constraint maps to on the foreign dataset*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"ForeignKeyTo\"}foreignFields:array[com.linkedin.common.Urn]/**Fields the constraint maps to on the source dataset*/sourceFields:array[com.linkedin.common.Urn]/**Reference to the foreign dataset for ease of lookup*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"ForeignKeyToDataset\"}foreignDataset:com.linkedin.common.Urn}]}}{namespace com.linkedin.schema/**EditableSchemaMetadata stores editable changes made to schema metadata. This separates changes made from\ningestion pipelines and edits in the UI to avoid accidental overwrites of user-provided data by ingestion pipelines.*/@Aspect.name=\"editableSchemaMetadata\"record EditableSchemaMetadata includes com.linkedin.common.ChangeAuditStamps{/**Client provided a list of fields from document schema.*/editableSchemaFieldInfo:array[/**SchemaField to describe metadata related to dataset schema.*/record EditableSchemaFieldInfo{/**FieldPath uniquely identifying the SchemaField this metadata is associated with*/fieldPath:string/**Description*/@Searchable={\"boostScore\":0.1,\"fieldName\":\"editedFieldDescriptions\",\"fieldType\":\"TEXT\"}description:optional string/**Tags associated with the field*/@Relationship.`/tags/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"EditableSchemaFieldTaggedWith\"}@Searchable={\"/tags/*/attribution/actor\":{\"fieldName\":\"editedFieldTagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/source\":{\"fieldName\":\"editedFieldTagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/time\":{\"fieldName\":\"editedFieldTagAttributionDates\",\"fieldType\":\"DATETIME\"},\"/tags/*/tag\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldTags\",\"fieldType\":\"URN\"}}globalTags:optional com.linkedin.common.GlobalTags/**Glossary terms associated with the field*/@Relationship.`/terms/*/urn`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"EditableSchemaFieldWithGlossaryTerm\"}@Searchable={\"/terms/*/attribution/actor\":{\"fieldName\":\"editedFieldTermAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/source\":{\"fieldName\":\"editedFieldTermAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/time\":{\"fieldName\":\"editedFieldTermAttributionDates\",\"fieldType\":\"DATETIME\"},\"/terms/*/urn\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldGlossaryTerms\",\"fieldType\":\"URN\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"schemaFieldTermsModifiedAt\"}}glossaryTerms:optional com.linkedin.common.GlossaryTerms}]}}com.linkedin.common.GlobalTags,com.linkedin.common.GlossaryTerms,com.linkedin.common.BrowsePaths,com.linkedin.common.DataPlatformInstance{namespace com.linkedin.dataset/**Details about a View. \ne.g. Gets activated when subTypes is view*/@Aspect.name=\"viewProperties\"record ViewProperties{/**Whether the view is materialized*/@Searchable={\"fieldType\":\"BOOLEAN\",\"weightsPerFieldValue\":{\"true\":0.5}}materialized:boolean/**The view logic*/viewLogic:string/**The formatted view logic. This is particularly used for SQL sources, where the SQL\nlogic is formatted for better readability, and with dbt, where this contains the\ncompiled SQL logic.*/formattedViewLogic:optional string/**The view logic language / dialect*/viewLanguage:string}}com.linkedin.common.BrowsePathsV2]}]}/**A metadata snapshot for a specific Data process entity.*/@Entity={\"keyAspect\":\"dataProcessKey\",\"name\":\"dataProcess\"}@deprecated=\"Use DataJob instead.\"record DataProcessSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Standardized process identifier.*/@java.class=\"com.linkedin.common.urn.DataProcessUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized process identifier.\",\"entityType\":\"dataProcess\",\"fields\":[{\"doc\":\"process name i.e. an ETL job name\",\"maxLength\":25,\"name\":\"name\",\"type\":\"string\"},{\"doc\":\"Standardized Orchestrator where data process is defined.\",\"maxLength\":100,\"name\":\"orchestrator\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"DataProcess\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:wherehows\"}typeref DataProcessUrn=string}/**The list of metadata aspects associated with the data process. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a data process*/@deprecated=\"Use DataJob instead.\"typeref DataProcessAspect=union[{namespace com.linkedin.metadata.key/**Key for a Data Process*/@Aspect.name=\"dataProcessKey\"record DataProcessKey{/**Process name i.e. an ETL job name*/@Searchable={\"boostScore\":4.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}name:string/**Standardized Orchestrator where data process is defined.\nTODO: Migrate towards something that can be validated like DataPlatform urn*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"TEXT_PARTIAL\"}orchestrator:string/**Fabric type where dataset belongs to or where it was generated.*/@Searchable={\"fieldType\":\"TEXT_PARTIAL\",\"queryByDefault\":false}origin:com.linkedin.common.FabricType}}com.linkedin.common.Ownership{namespace com.linkedin.dataprocess/**The inputs and outputs of this data process*/@Aspect.name=\"dataProcessInfo\"record DataProcessInfo{/**the inputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}inputs:optional array[com.linkedin.common.DatasetUrn]/**the outputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"outputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}outputs:optional array[com.linkedin.common.DatasetUrn]}}com.linkedin.common.Status]}]}/**A metadata snapshot for a specific dataplatform entity.*/@Entity={\"keyAspect\":\"dataPlatformKey\",\"name\":\"dataPlatform\"}record DataPlatformSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.DataPlatformUrn/**The list of metadata aspects associated with the data platform. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Data Platform*/typeref DataPlatformAspect=union[{namespace com.linkedin.metadata.key/**Key for a Data Platform*/@Aspect.name=\"dataPlatformKey\"record DataPlatformKey{/**Data platform name i.e. hdfs, oracle, espresso*/platformName:string}}{namespace com.linkedin.dataplatform/**Information about a data platform*/@Aspect.name=\"dataPlatformInfo\"record DataPlatformInfo{/**Name of the data platform*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":false,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}@validate.strlen.max=15,name:string/**The name that will be used for displaying a platform type.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}displayName:optional string/**Platform type this data platform describes*/type:/**Platform types available at LinkedIn*/enum PlatformType{/**Value for a file system, e.g. hdfs*/FILE_SYSTEM/**Value for a key value store, e.g. espresso, voldemort*/KEY_VALUE_STORE/**Value for a message broker, e.g. kafka*/MESSAGE_BROKER/**Value for an object store, e.g. ambry*/OBJECT_STORE/**Value for an OLAP datastore, e.g. pinot*/OLAP_DATASTORE/**Value for other platforms, e.g salesforce, dovetail*/OTHERS/**Value for a query engine, e.g. presto*/QUERY_ENGINE/**Value for a relational database, e.g. oracle, mysql*/RELATIONAL_DB/**Value for a search engine, e.g seas*/SEARCH_ENGINE}/**The delimiter in the dataset names on the data platform, e.g. '/' for HDFS and '.' for Oracle*/datasetNameDelimiter:string/**The URL for a logo associated with the platform*/logoUrl:optional com.linkedin.common.Url}}]}]}/**MLModel Snapshot entity details.*/@Entity={\"keyAspect\":\"mlModelKey\",\"name\":\"mlModel\"}record MLModelSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Standardized MLModel identifier.*/@java.class=\"com.linkedin.common.urn.MLModelUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized model identifier.\",\"entityType\":\"mlModel\",\"fields\":[{\"doc\":\"Standardized platform urn for the MLModel.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Name of the MLModel\",\"maxLength\":210,\"name\":\"mlModelName\",\"type\":\"string\"},{\"doc\":\"Fabric type where model belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"MlModel\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref MLModelUrn=string}/**The list of metadata aspects associated with the MLModel. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a ML Model*/typeref MLModelAspect=union[{namespace com.linkedin.metadata.key/**Key for an ML model*/@Aspect.name=\"mlModelKey\"record MLModelKey{/**Standardized platform urn for the model*/platform:com.linkedin.common.Urn/**Name of the MLModel*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Fabric type where model belongs to or where it was generated*/@Searchable={\"addToFilters\":true,\"fieldType\":\"TEXT_PARTIAL\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}origin:com.linkedin.common.FabricType}}com.linkedin.common.Ownership{namespace com.linkedin.ml.metadata/**Properties associated with a ML Model*/@Aspect.name=\"mlModelProperties\"record MLModelProperties includes com.linkedin.common.CustomProperties,com.linkedin.common.ExternalReference/**A set of re-usable fields used to capture lineage information for ML Models and ML Model Groups*/record MLModelLineageInfo{/**List of jobs or process instances (if any) used to train the model or group. Visible in Lineage. Note that ML Models can also be specified as the output of a specific Data Process Instances (runs) via the DataProcessInstanceOutputs aspect.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"name\":\"TrainedBy\"}trainingJobs:optional array[com.linkedin.common.Urn]/**List of jobs or process instances (if any) that use the model or group.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"UsedBy\"}downstreamJobs:optional array[com.linkedin.common.Urn]}{/**Display name of the MLModel*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}name:optional string/**Documentation of the MLModel*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Date when the MLModel was developed*/@deprecated,date:optional com.linkedin.common.Time/**Audit stamp containing who created this and when*/created:optional com.linkedin.common.TimeStamp/**Date when the MLModel was last modified*/lastModified:optional com.linkedin.common.TimeStamp/**Version of the MLModel*/version:optional{namespace com.linkedin.common/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional MetadataAttribution}}/**Type of Algorithm or MLModel such as whether it is a Naive Bayes classifier, Convolutional Neural Network, etc*/@Searchable.fieldType=\"TEXT_PARTIAL\"type:optional string/**Hyper Parameters of the MLModel\n\nNOTE: these are deprecated in favor of hyperParams*/hyperParameters:optional map[string/**A union of all supported metadata aspects for HyperParameter Value*/typeref HyperParameterValueType=union[string,int,float,double,boolean]]/**Hyperparameters of the MLModel*/hyperParams:optional array[/**Properties associated with an ML Hyper Param*/@Aspect.name=\"mlHyperParam\"record MLHyperParam{/**Name of the MLHyperParam*/name:string/**Documentation of the MLHyperParam*/description:optional string/**The value of the MLHyperParam*/value:optional string/**Date when the MLHyperParam was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in training*/trainingMetrics:optional array[/**Properties associated with an ML Metric*/@Aspect.name=\"mlMetric\"record MLMetric{/**Name of the mlMetric*/name:string/**Documentation of the mlMetric*/description:optional string/**The value of the mlMetric*/value:optional string/**Date when the mlMetric was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in production*/onlineMetrics:optional array[MLMetric]/**List of features used for MLModel training*/@Relationship.`/*`={\"entityTypes\":[\"mlFeature\"],\"isLineage\":true,\"name\":\"Consumes\"}mlFeatures:optional array[{namespace com.linkedin.common/**Standardized MLFeature identifier.*/@java.class=\"com.linkedin.common.urn.MLFeatureUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized MLFeature identifier.\",\"entityType\":\"mlFeature\",\"fields\":[{\"doc\":\"Namespace for the MLFeature\",\"name\":\"mlFeatureNamespace\",\"type\":\"string\"},{\"doc\":\"Name of the MLFeature\",\"maxLength\":210,\"name\":\"mlFeatureName\",\"type\":\"string\"}],\"maxLength\":284,\"name\":\"MLFeature\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref MLFeatureUrn=string}]/**Tags for the MLModel*/tags:array[string]=[]/**Deployments for the MLModel*/@Relationship.`/*`={\"entityTypes\":[\"mlModelDeployment\"],\"name\":\"DeployedTo\"}deployments:optional array[com.linkedin.common.Urn]/**Groups the model belongs to*/@Relationship.`/*`={\"entityTypes\":[\"mlModelGroup\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"MemberOf\"}groups:optional array[com.linkedin.common.Urn]}}{namespace com.linkedin.ml.metadata/**Intended Use for the ML Model*/@Aspect.name=\"intendedUse\"record IntendedUse{/**Primary Use cases for the MLModel.*/primaryUses:optional array[string]/**Primary Intended Users - For example, was the MLModel developed for entertainment purposes, for hobbyists, or enterprise solutions?*/primaryUsers:optional array[enum IntendedUserType{ENTERPRISE,HOBBY,ENTERTAINMENT}]/**Highlight technology that the MLModel might easily be confused with, or related contexts that users could try to apply the MLModel to.*/outOfScopeUses:optional array[string]}}{namespace com.linkedin.ml.metadata/**Prompts which affect the performance of the MLModel*/@Aspect.name=\"mlModelFactorPrompts\"record MLModelFactorPrompts{/**What are foreseeable salient factors for which MLModel performance may vary, and how were these determined?*/relevantFactors:optional array[/**Factors affecting the performance of the MLModel.*/record MLModelFactors{/**Groups refers to distinct categories with similar characteristics that are present in the evaluation data instances.\nFor human-centric machine learning MLModels, groups are people who share one or multiple characteristics.*/groups:optional array[string]/**The performance of a MLModel can vary depending on what instruments were used to capture the input to the MLModel.\nFor example, a face detection model may perform differently depending on the camera's hardware and software,\nincluding lens, image stabilization, high dynamic range techniques, and background blurring for portrait mode.*/instrumentation:optional array[string]/**A further factor affecting MLModel performance is the environment in which it is deployed.*/environment:optional array[string]}]/**Which factors are being reported, and why were these chosen?*/evaluationFactors:optional array[MLModelFactors]}}{namespace com.linkedin.ml.metadata/**Metrics to be featured for the MLModel.*/@Aspect.name=\"mlModelMetrics\"record Metrics{/**Measures of MLModel performance*/performanceMeasures:optional array[string]/**Decision Thresholds used (if any)?*/decisionThreshold:optional array[string]}}{namespace com.linkedin.ml.metadata/**All referenced datasets would ideally point to any set of documents that provide visibility into the source and composition of the dataset.*/@Aspect.name=\"mlModelEvaluationData\"record EvaluationData{/**Details on the dataset(s) used for the quantitative analyses in the MLModel*/evaluationData:array[/**BaseData record*/record BaseData{/**What dataset were used in the MLModel?*/dataset:com.linkedin.common.DatasetUrn/**Why was this dataset chosen?*/motivation:optional string/**How was the data preprocessed (e.g., tokenization of sentences, cropping of images, any filtering such as dropping images without faces)?*/preProcessing:optional array[string]}]}}{namespace com.linkedin.ml.metadata/**Ideally, the MLModel card would contain as much information about the training data as the evaluation data. However, there might be cases where it is not feasible to provide this level of detailed information about the training data. For example, the data may be proprietary, or require a non-disclosure agreement. In these cases, we advocate for basic details about the distributions over groups in the data, as well as any other details that could inform stakeholders on the kinds of biases the model may have encoded.*/@Aspect.name=\"mlModelTrainingData\"record TrainingData{/**Details on the dataset(s) used for training the MLModel*/trainingData:array[BaseData]}}{namespace com.linkedin.ml.metadata/**Quantitative analyses should be disaggregated, that is, broken down by the chosen factors. Quantitative analyses should provide the results of evaluating the MLModel according to the chosen metrics, providing confidence interval values when possible.*/@Aspect.name=\"mlModelQuantitativeAnalyses\"record QuantitativeAnalyses{/**Link to a dashboard with results showing how the MLModel performed with respect to each factor*/unitaryResults:optional/**A union of all supported metadata aspects for ResultsType*/typeref ResultsType=union[string]/**Link to a dashboard with results showing how the MLModel performed with respect to the intersection of evaluated factors?*/intersectionalResults:optional ResultsType}}{namespace com.linkedin.ml.metadata/**This section is intended to demonstrate the ethical considerations that went into MLModel development, surfacing ethical challenges and solutions to stakeholders.*/@Aspect.name=\"mlModelEthicalConsiderations\"record EthicalConsiderations{/**Does the MLModel use any sensitive data (e.g., protected classes)?*/data:optional array[string]/** Is the MLModel intended to inform decisions about matters central to human life or flourishing - e.g., health or safety? Or could it be used in such a way?*/humanLife:optional array[string]/**What risk mitigation strategies were used during MLModel development?*/mitigations:optional array[string]/**What risks may be present in MLModel usage? Try to identify the potential recipients, likelihood, and magnitude of harms. If these cannot be determined, note that they were considered but remain unknown.*/risksAndHarms:optional array[string]/**Are there any known MLModel use cases that are especially fraught? This may connect directly to the intended use section*/useCases:optional array[string]}}{namespace com.linkedin.ml.metadata/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/@Aspect.name=\"mlModelCaveatsAndRecommendations\"record CaveatsAndRecommendations{/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset?*/caveats:optional/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/record CaveatDetails{/**Did the results suggest any further testing?*/needsFurtherTesting:optional boolean/**Caveat Description\nFor ex: Given gender classes are binary (male/not male), which we include as male/female. Further work needed to evaluate across a spectrum of genders.*/caveatDescription:optional string/**Relevant groups that were not represented in the evaluation dataset?*/groupsNotRepresented:optional array[string]}/**Recommendations on where this MLModel should be used.*/recommendations:optional string/**Ideal characteristics of an evaluation dataset for this MLModel*/idealDatasetCharacteristics:optional array[string]}}com.linkedin.common.InstitutionalMemory{namespace com.linkedin.ml.metadata/**Source Code*/@Aspect.name=\"sourceCode\"record SourceCode{/**Source Code along with types*/sourceCode:array[/**Source Code Url Entity*/record SourceCodeUrl{/**Source Code Url Types*/type:enum SourceCodeUrlType{ML_MODEL_SOURCE_CODE,TRAINING_PIPELINE_SOURCE_CODE,EVALUATION_PIPELINE_SOURCE_CODE}/**Source Code Url*/sourceCodeUrl:com.linkedin.common.Url}]}}com.linkedin.common.Status{namespace com.linkedin.common@Aspect.name=\"cost\"record Cost{costType:/**Type of Cost Code*/enum CostType{/**Org Cost Type to which the Cost of this entity should be attributed to*/ORG_COST_TYPE}cost:/**A union of all supported Cost Value types*/typeref CostValue=union[costId:double,costCode:string]}}{namespace com.linkedin.common/**Deprecation status of an entity*/@Aspect.name=\"deprecation\"record Deprecation{/**Whether the entity is deprecated.*/@Searchable={\"addToFilters\":true,\"fieldType\":\"BOOLEAN\",\"filterNameOverride\":\"Deprecated\",\"weightsPerFieldValue\":{\"true\":0.5}}deprecated:boolean/**The time user plan to decommission this entity.*/decommissionTime:optional Time/**Additional information about the entity deprecation plan, such as the wiki, doc, RB.*/note:string/**The user URN which will be credited for modifying this deprecation content.*/actor:Urn,replacement:optional Urn}}com.linkedin.common.BrowsePaths,com.linkedin.common.GlobalTags,com.linkedin.common.DataPlatformInstance,com.linkedin.common.BrowsePathsV2]}]}@Entity={\"keyAspect\":\"mlPrimaryKeyKey\",\"name\":\"mlPrimaryKey\"}record MLPrimaryKeySnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.Urn/**The list of metadata aspects associated with the MLPrimaryKey. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a MLPrimaryKey*/typeref MLPrimaryKeyAspect=union[{namespace com.linkedin.metadata.key/**Key for an MLPrimaryKey*/@Aspect.name=\"mlPrimaryKeyKey\"record MLPrimaryKeyKey{/**Namespace for the primary key*/@Searchable.fieldType=\"TEXT_PARTIAL\"featureNamespace:string/**Name of the primary key*/@Searchable={\"boostScore\":8.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.ml.metadata/**Properties associated with a MLPrimaryKey*/@Aspect.name=\"mlPrimaryKeyProperties\"record MLPrimaryKeyProperties includes com.linkedin.common.CustomProperties{/**Documentation of the MLPrimaryKey*/description:optional string/**Data Type of the MLPrimaryKey*/dataType:optional{namespace com.linkedin.common/**MLFeature Data Type*/enum MLFeatureDataType{/**Useless data is unique, discrete data with no potential relationship with the outcome variable.\nA useless feature has high cardinality. An example would be bank account numbers that were generated randomly.*/USELESS/**Nominal data is made of discrete values with no numerical relationship between the different categories - mean and median are meaningless.\nAnimal species is one example. For example, pig is not higher than bird and lower than fish.*/NOMINAL/**Ordinal data are discrete integers that can be ranked or sorted.\nFor example, the distance between first and second may not be the same as the distance between second and third.*/ORDINAL/**Binary data is discrete data that can be in only one of two categories - either yes or no, 1 or 0, off or on, etc*/BINARY/**Count data is discrete whole number data - no negative numbers here.\nCount data often has many small values, such as zero and one.*/COUNT/**Time data is a cyclical, repeating continuous form of data.\nThe relevant time features can be any period- daily, weekly, monthly, annual, etc.*/TIME/**Interval data has equal spaces between the numbers and does not represent a temporal pattern.\nExamples include percentages, temperatures, and income.*/INTERVAL/**Image Data*/IMAGE/**Video Data*/VIDEO/**Audio Data*/AUDIO/**Text Data*/TEXT/**Mapping Data Type ex: dict, map*/MAP/**Sequence Data Type ex: list, tuple, range*/SEQUENCE/**Set Data Type ex: set, frozenset*/SET/**Continuous data are made of uncountable values, often the result of a measurement such as height, weight, age etc.*/CONTINUOUS/**Bytes data are binary-encoded values that can represent complex objects.*/BYTE/**Unknown data are data that we don't know the type for.*/UNKNOWN}}/**Version of the MLPrimaryKey*/version:optional com.linkedin.common.VersionTag/**Source of the MLPrimaryKey*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"DerivedFrom\"}sources:array[com.linkedin.common.Urn]}}com.linkedin.common.Ownership,com.linkedin.common.InstitutionalMemory,com.linkedin.common.Status,com.linkedin.common.Deprecation,com.linkedin.common.GlobalTags,com.linkedin.common.DataPlatformInstance]}]}@Entity={\"keyAspect\":\"mlFeatureKe" + "y\",\"name\":\"mlFeature\"}record MLFeatureSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.MLFeatureUrn/**The list of metadata aspects associated with the MLFeature. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a MLFeature*/typeref MLFeatureAspect=union[{namespace com.linkedin.metadata.key/**Key for an MLFeature*/@Aspect.name=\"mlFeatureKey\"record MLFeatureKey{/**Namespace for the feature*/@Searchable.fieldType=\"TEXT_PARTIAL\"featureNamespace:string/**Name of the feature*/@Searchable={\"boostScore\":8.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.ml.metadata/**Properties associated with a MLFeature*/@Aspect.name=\"mlFeatureProperties\"record MLFeatureProperties includes com.linkedin.common.CustomProperties{/**Documentation of the MLFeature*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Data Type of the MLFeature*/dataType:optional com.linkedin.common.MLFeatureDataType/**Version of the MLFeature*/version:optional com.linkedin.common.VersionTag/**Source of the MLFeature*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"DerivedFrom\"}sources:optional array[com.linkedin.common.Urn]}}com.linkedin.common.Ownership,com.linkedin.common.InstitutionalMemory,com.linkedin.common.Status,com.linkedin.common.Deprecation,com.linkedin.common.BrowsePaths,com.linkedin.common.GlobalTags,com.linkedin.common.DataPlatformInstance,com.linkedin.common.BrowsePathsV2]}]}@Entity={\"keyAspect\":\"mlFeatureTableKey\",\"name\":\"mlFeatureTable\"}record MLFeatureTableSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.Urn/**The list of metadata aspects associated with the MLFeatureTable. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a MLFeatureTable*/typeref MLFeatureTableAspect=union[{namespace com.linkedin.metadata.key/**Key for an MLFeatureTable*/@Aspect.name=\"mlFeatureTableKey\"record MLFeatureTableKey{/**Data platform urn associated with the feature table*/@Relationship={\"entityTypes\":[\"dataPlatform\"],\"name\":\"SourcePlatform\"}platform:com.linkedin.common.Urn/**Name of the feature table*/@Searchable={\"boostScore\":8.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.ml.metadata/**Properties associated with a MLFeatureTable*/@Aspect.name=\"mlFeatureTableProperties\"record MLFeatureTableProperties includes com.linkedin.common.CustomProperties{/**Documentation of the MLFeatureTable*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**List of features contained in the feature table*/@Relationship.`/*`={\"entityTypes\":[\"mlFeature\"],\"name\":\"Contains\"}@Searchable.`/*`={\"fieldName\":\"features\",\"fieldType\":\"URN\"}mlFeatures:optional array[com.linkedin.common.Urn]/**List of primary keys in the feature table (if multiple, assumed to act as a composite key)*/@Relationship.`/*`={\"entityTypes\":[\"mlPrimaryKey\"],\"name\":\"KeyedBy\"}@Searchable.`/*`={\"fieldName\":\"primaryKeys\",\"fieldType\":\"URN\"}mlPrimaryKeys:optional array[com.linkedin.common.Urn]}}com.linkedin.common.Ownership,com.linkedin.common.InstitutionalMemory,com.linkedin.common.Status,com.linkedin.common.Deprecation,com.linkedin.common.BrowsePaths,com.linkedin.common.GlobalTags,com.linkedin.common.DataPlatformInstance,com.linkedin.common.BrowsePathsV2]}]}@Entity={\"keyAspect\":\"mlModelDeploymentKey\",\"name\":\"mlModelDeployment\"}record MLModelDeploymentSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.Urn/**The list of metadata aspects associated with the MLModelDeployment. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a MLModelDeployment*/typeref MLModelDeploymentAspect=union[{namespace com.linkedin.metadata.key/**Key for an ML model deployment*/@Aspect.name=\"mlModelDeploymentKey\"record MLModelDeploymentKey{/**Standardized platform urn for the model Deployment*/platform:com.linkedin.common.Urn/**Name of the MLModelDeployment*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Fabric type where model Deployment belongs to or where it was generated*/@Searchable={\"addToFilters\":true,\"fieldType\":\"TEXT_PARTIAL\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}origin:com.linkedin.common.FabricType}}{namespace com.linkedin.ml.metadata/**Properties associated with an ML Model Deployment*/@Aspect.name=\"mlModelDeploymentProperties\"record MLModelDeploymentProperties includes com.linkedin.common.CustomProperties,com.linkedin.common.ExternalReference{/**Documentation of the MLModelDeployment*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Date when the MLModelDeployment was developed*/createdAt:optional com.linkedin.common.Time/**Version of the MLModelDeployment*/version:optional com.linkedin.common.VersionTag/**Status of the deployment*/@Searchable.fieldName=\"deploymentStatus\"status:optional/**Model endpoint statuses*/enum DeploymentStatus{/**Deployments out of service.*/OUT_OF_SERVICE/**Deployments being created.*/CREATING/**Deployments being updated.*/UPDATING/**Deployments being reverted to a previous version.*/ROLLING_BACK/**Deployments that are active.*/IN_SERVICE/**Deployments being deleted.*/DELETING/**Deployments with an error state.*/FAILED/**Deployments with unknown/unmappable state.*/UNKNOWN}}}com.linkedin.common.Ownership,com.linkedin.common.Status,com.linkedin.common.Deprecation,com.linkedin.common.GlobalTags,com.linkedin.common.DataPlatformInstance]}]}@Entity={\"keyAspect\":\"mlModelGroupKey\",\"name\":\"mlModelGroup\"}record MLModelGroupSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.Urn/**The list of metadata aspects associated with the MLModelGroup. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a MLModelGroup*/typeref MLModelGroupAspect=union[{namespace com.linkedin.metadata.key/**Key for an ML model group*/@Aspect.name=\"mlModelGroupKey\"record MLModelGroupKey{/**Standardized platform urn for the model group*/platform:com.linkedin.common.Urn/**Name of the MLModelGroup*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Fabric type where model group belongs to or where it was generated*/@Searchable={\"fieldType\":\"TEXT_PARTIAL\",\"queryByDefault\":false}origin:com.linkedin.common.FabricType}}{namespace com.linkedin.ml.metadata/**Properties associated with an ML Model Group*/@Aspect.name=\"mlModelGroupProperties\"record MLModelGroupProperties includes com.linkedin.common.CustomProperties,MLModelLineageInfo,com.linkedin.common.ExternalReference{/**Display name of the MLModelGroup*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}name:optional string/**Documentation of the MLModelGroup*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Date when the MLModelGroup was developed*/@deprecated,createdAt:optional com.linkedin.common.Time/**Time and Actor who created the MLModelGroup*/created:optional com.linkedin.common.TimeStamp/**Date when the MLModelGroup was last modified*/lastModified:optional com.linkedin.common.TimeStamp/**Version of the MLModelGroup*/version:optional com.linkedin.common.VersionTag}}com.linkedin.common.Ownership,com.linkedin.common.Status,com.linkedin.common.Deprecation,com.linkedin.common.BrowsePaths,com.linkedin.common.GlobalTags,com.linkedin.common.DataPlatformInstance,com.linkedin.common.BrowsePathsV2]}]}/**A metadata snapshot for a specific dataset entity.*/@Entity={\"keyAspect\":\"tagKey\",\"name\":\"tag\"}record TagSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.TagUrn/**The list of metadata aspects associated with the dataset. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a tag*/typeref TagAspect=union[{namespace com.linkedin.metadata.key/**Key for a Tag*/@Aspect.name=\"tagKey\"record TagKey{/**The tag name, which serves as a unique id*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldName\":\"id\",\"fieldType\":\"WORD_GRAM\"}name:string}}com.linkedin.common.Ownership{namespace com.linkedin.tag/**Properties associated with a Tag*/@Aspect.name=\"tagProperties\"record TagProperties{/**Display name of the tag*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Documentation of the tag*/@Searchable={}description:optional string/**The color associated with the Tag in Hex. For example #FFFFFF.*/colorHex:optional string}}com.linkedin.common.Status]}]}/**A metadata snapshot for a specific GlossaryTerm entity.*/@Entity={\"keyAspect\":\"glossaryTermKey\",\"name\":\"glossaryTerm\"}record GlossaryTermSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.GlossaryTermUrn/**The list of metadata aspects associated with the GlossaryTerm. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a CorpUser*/typeref GlossaryTermAspect=union[{namespace com.linkedin.metadata.key/**Key for a GlossaryTerm*/@Aspect.name=\"glossaryTermKey\"record GlossaryTermKey{/**The term name, which serves as a unique id*/@Searchable={\"enableAutocomplete\":true,\"fieldName\":\"id\",\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.glossary/**Properties associated with a GlossaryTerm*/@Aspect.name=\"glossaryTermInfo\"record GlossaryTermInfo includes com.linkedin.common.CustomProperties{/**Optional id for the term*/@Searchable.fieldType=\"TEXT_PARTIAL\"id:optional string/**Display name of the term*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:optional string/**Definition of business term.*/@Searchable={}definition:string/**Parent node of the glossary term*/@Relationship={\"entityTypes\":[\"glossaryNode\"],\"name\":\"IsPartOf\"}@Searchable={\"fieldName\":\"parentNode\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasParentNode\"}parentNode:optional{namespace com.linkedin.common/**Business Node*/@java.class=\"com.linkedin.common.urn.GlossaryNodeUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized business node identifier\",\"entityType\":\"glossaryNode\",\"fields\":[{\"doc\":\"The name of business node with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryNode\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryNodeUrn=string}/**Source of the Business Term (INTERNAL or EXTERNAL) with default value as INTERNAL*/@Searchable.fieldType=\"KEYWORD\"termSource:string/**External Reference to the business-term*/@Searchable.fieldType=\"KEYWORD\"sourceRef:optional string/**The abstracted URL such as https://spec.edmcouncil.org/fibo/ontology/FBC/FinancialInstruments/FinancialInstruments/CashInstrument.*/sourceUrl:optional com.linkedin.common.Url/**Schema definition of the glossary term*/@deprecated,rawSchema:optional string}}com.linkedin.common.Ownership,com.linkedin.common.Status,com.linkedin.common.BrowsePaths{namespace com.linkedin.glossary/**Has A / Is A lineage information about a glossary Term reporting the lineage*/@Aspect.name=\"glossaryRelatedTerms\"record GlossaryRelatedTerms{/**The relationship Is A with glossary term*/@Relationship.`/*`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"IsA\"}@Searchable.`/*`={\"fieldName\":\"isRelatedTerms\",\"fieldType\":\"URN\",\"queryByDefault\":false}isRelatedTerms:optional array[com.linkedin.common.GlossaryTermUrn]/**The relationship Has A with glossary term*/@Relationship.`/*`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"HasA\"}@Searchable.`/*`={\"fieldName\":\"hasRelatedTerms\",\"fieldType\":\"URN\",\"queryByDefault\":false}hasRelatedTerms:optional array[com.linkedin.common.GlossaryTermUrn]/**The relationship Has Value with glossary term.\nThese are fixed value a term has. For example a ColorEnum where RED, GREEN and YELLOW are fixed values.*/@Relationship.`/*`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"HasValue\"}@Searchable.`/*`={\"fieldName\":\"values\",\"fieldType\":\"URN\"}values:optional array[com.linkedin.common.GlossaryTermUrn]/**The relationship isRelatedTo with glossary term*/@Relationship.`/*`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"IsRelatedTo\"}@Searchable.`/*`={\"fieldName\":\"relatedTerms\",\"fieldType\":\"URN\"}relatedTerms:optional array[com.linkedin.common.GlossaryTermUrn]}}]}]}/**A metadata snapshot for a specific GlossaryNode entity.*/@Entity={\"keyAspect\":\"glossaryNodeKey\",\"name\":\"glossaryNode\"}record GlossaryNodeSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.GlossaryNodeUrn/**The list of metadata aspects associated with the GlossaryNode. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a GlossaryNode*/typeref GlossaryNodeAspect=union[{namespace com.linkedin.metadata.key/**Key for a GlossaryNode*/@Aspect.name=\"glossaryNodeKey\"record GlossaryNodeKey{@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}name:string}}{namespace com.linkedin.glossary/**Properties associated with a GlossaryNode*/@Aspect.name=\"glossaryNodeInfo\"record GlossaryNodeInfo includes com.linkedin.common.CustomProperties{/**Definition of business node*/@Searchable={}definition:string/**Parent node of the glossary term*/@Relationship={\"entityTypes\":[\"glossaryNode\"],\"name\":\"IsPartOf\"}@Searchable={\"fieldName\":\"parentNode\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasParentNode\"}parentNode:optional com.linkedin.common.GlossaryNodeUrn/**Display name of the node*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldName\":\"displayName\",\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:optional string/**Optional id for the GlossaryNode*/@Searchable.fieldType=\"TEXT_PARTIAL\"id:optional string}}com.linkedin.common.Ownership,com.linkedin.common.Status]}]}/**A metadata snapshot for DataHub Access Policy data.*/@Entity={\"keyAspect\":\"dataHubPolicyKey\",\"name\":\"dataHubPolicy\"}record DataHubPolicySnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.Urn/**The list of metadata aspects associated with the DataHub access policy.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a DataHub access policy.*/typeref DataHubPolicyAspect=union[{namespace com.linkedin.metadata.key/**Key for a DataHub Policy*/@Aspect.name=\"dataHubPolicyKey\"record DataHubPolicyKey{/**A unique id for the DataHub access policy record. Generated on the server side at policy creation time.*/id:string}}{namespace com.linkedin.policy/**Information about a DataHub (UI) access policy.*/@Aspect.name=\"dataHubPolicyInfo\"record DataHubPolicyInfo{/**Display name of the Policy*/@Searchable.fieldType=\"TEXT_PARTIAL\"displayName:string/**Description of the Policy*/@Searchable.fieldType=\"TEXT\"description:string/**The type of policy*/@Searchable.fieldType=\"KEYWORD\"type:string/**The state of policy, ACTIVE or INACTIVE*/@Searchable.fieldType=\"KEYWORD\"state:string/**The resource that the policy applies to. Not required for some 'Platform' privileges.*/resources:optional/**Information used to filter DataHub resource.*/record DataHubResourceFilter{/**The type of resource that the policy applies to. This will most often be a data asset entity name, for\nexample 'dataset'. It is not strictly required because in the future we will want to support filtering a resource\nby domain, as well.*/@deprecated,type:optional string/**A specific set of resources to apply the policy to, e.g. asset urns*/@deprecated,resources:optional array[string]/**Whether the policy should be applied to all assets matching the filter.*/@deprecated,allResources:boolean=false/**Filter to apply privileges to*/filter:optional/**The filter for specifying the resource or actor to apply privileges to*/record PolicyMatchFilter{/**A list of criteria to apply conjunctively (so all criteria must pass)*/criteria:array[/**A criterion for matching a field with given value*/record PolicyMatchCriterion{/**The name of the field that the criterion refers to*/field:string/**Values. Matches criterion if any one of the values matches condition (OR-relationship)*/values:array[string]/**The condition for the criterion*/condition:/**The matching condition in a filter criterion*/enum PolicyMatchCondition{/**Whether the field matches the value*/EQUALS/**Whether the field value starts with the value*/STARTS_WITH/**Whether the field does not match the value*/NOT_EQUALS}=\"EQUALS\"}]}/**Constraints around what sub-resources operations are allowed to modify, i.e. NOT_EQUALS - cannot modify a particular defined tag, EQUALS - can only modify a particular defined tag, STARTS_WITH - can only modify a tag starting with xyz*/privilegeConstraints:optional PolicyMatchFilter}/**The privileges that the policy grants.*/@Searchable.`/*`={\"addToFilters\":true,\"fieldType\":\"KEYWORD\"}privileges:array[string]/**The actors that the policy applies to.*/actors:/**Information used to filter DataHub actors.*/record DataHubActorFilter{/**A specific set of users to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"users:optional array[com.linkedin.common.Urn]/**A specific set of groups to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"groups:optional array[com.linkedin.common.Urn]/**Whether the filter should return true for owners of a particular resource.\nOnly applies to policies of type 'Metadata', which have a resource associated with them.*/resourceOwners:boolean=false/**Define type of ownership for the policy*/resourceOwnersTypes:optional array[com.linkedin.common.Urn]/**Whether the filter should apply to all users.*/@Searchable.fieldType=\"BOOLEAN\"allUsers:boolean=false/**Whether the filter should apply to all groups.*/@Searchable.fieldType=\"BOOLEAN\"allGroups:boolean=false/**A specific set of roles to apply the policy to (disjunctive).*/@Relationship.`/*`={\"entityTypes\":[\"dataHubRole\"],\"name\":\"IsAssociatedWithRole\"}@Searchable.`/*`.fieldType=\"URN\"roles:optional array[com.linkedin.common.Urn]}/**Whether the policy should be editable via the UI*/@Searchable.fieldType=\"BOOLEAN\"editable:boolean=true/**Timestamp when the policy was last updated*/@Searchable.fieldType=\"DATETIME\"lastUpdatedTimestamp:optional long}}]}]}/**A metadata snapshot for a specific schema field entity.*/@Entity={\"keyAspect\":\"schemaFieldKey\",\"name\":\"schemaField\"}record SchemaFieldSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.Urn/**The list of metadata aspects associated with the dataset. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a SchemaField*/typeref SchemaFieldAspect=union[{namespace com.linkedin.metadata.key/**Key for a SchemaField*/@Aspect.name=\"schemaFieldKey\"record SchemaFieldKey{/**Parent associated with the schema field*/@Searchable.fieldType=\"URN\"parent:com.linkedin.common.Urn/**fieldPath identifying the schema field*/@Searchable.fieldType=\"KEYWORD\"fieldPath:string}}]}]}/**A metadata snapshot for DataHub Access Policy data.*/@Entity={\"keyAspect\":\"dataHubRetentionKey\",\"name\":\"dataHubRetention\"}record DataHubRetentionSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:com.linkedin.common.Urn/**The list of metadata aspects associated with the DataHub access policy.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a DataHub access policy.*/typeref DataHubRetentionAspect=union[{namespace com.linkedin.metadata.key/**Key for a DataHub Retention*/@Aspect.name=\"dataHubRetentionKey\"record DataHubRetentionKey{/**Entity name to apply retention to. * (or empty) for applying defaults.*/entityName:string/**Aspect name to apply retention to. * (or empty) for applying defaults.*/aspectName:string}}{namespace com.linkedin.retention@Aspect.name=\"dataHubRetentionConfig\"record DataHubRetentionConfig{retention:/**Base class that encapsulates different retention policies.\nOnly one of the fields should be set*/record Retention{version:optional/**Keep max N latest records*/record VersionBasedRetention{maxVersions:int}time:optional/**Keep records that are less than X seconds old*/record TimeBasedRetention{maxAgeInSeconds:int}}}}]}]}]}/**Metadata around how the old snapshot was produced.*/oldSystemMetadata:optional/**Metadata associated with each metadata change that is processed by the system*/@Aspect.name=\"systemMetadata\"record SystemMetadata{/**The timestamp the metadata was observed at*/lastObserved:optional long=0/**The original run id that produced the metadata. Populated in case of batch-ingestion.*/runId:optional string=\"no-run-id-provided\"/**The last run id that produced the metadata. Populated in case of batch-ingestion.*/lastRunId:optional string=\"no-run-id-provided\"/**The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion.*/pipelineName:optional string/**The model registry name that was used to process this event*/registryName:optional string/**The model registry version that was used to process this event*/registryVersion:optional string/**Additional properties*/properties:optional map[string,string]/**Aspect version\n   Initial implementation will use the aspect version's number, however stored as\n   a string in the case where a different aspect versioning scheme is later adopted.*/version:optional string/**When the aspect was initially created and who created it, detected by version 0 -> 1 change*/aspectCreated:optional com.linkedin.common.AuditStamp/**When the aspect was last modified and the actor that performed the modification*/aspectModified:optional com.linkedin.common.AuditStamp}/**Snapshot of the metadata after the update. Only the metadata aspects affected by the update are included in the snapshot.*/newSnapshot:com.linkedin.metadata.snapshot.Snapshot/**Metadata around how the new snapshot was produced.*/newSystemMetadata:optional SystemMetadata,operation:optional enum MetadataAuditOperation{UPDATE,DELETE}}", SchemaFormatType.PDL);
    private KafkaAuditHeader _auditHeaderField = null;
    private Snapshot _oldSnapshotField = null;
    private SystemMetadata _oldSystemMetadataField = null;
    private Snapshot _newSnapshotField = null;
    private SystemMetadata _newSystemMetadataField = null;
    private MetadataAuditOperation _operationField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_AuditHeader = SCHEMA.getField("auditHeader");
    private static final RecordDataSchema.Field FIELD_OldSnapshot = SCHEMA.getField("oldSnapshot");
    private static final RecordDataSchema.Field FIELD_OldSystemMetadata = SCHEMA.getField("oldSystemMetadata");
    private static final RecordDataSchema.Field FIELD_NewSnapshot = SCHEMA.getField("newSnapshot");
    private static final RecordDataSchema.Field FIELD_NewSystemMetadata = SCHEMA.getField("newSystemMetadata");
    private static final RecordDataSchema.Field FIELD_Operation = SCHEMA.getField("operation");

    public MetadataAuditEvent() {
        super(new DataMap(8, 0.75f), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public MetadataAuditEvent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAuditHeader() {
        if (this._auditHeaderField != null) {
            return true;
        }
        return this._map.containsKey("auditHeader");
    }

    public void removeAuditHeader() {
        this._map.remove("auditHeader");
    }

    @Nullable
    public KafkaAuditHeader getAuditHeader(GetMode mode) {
        return this.getAuditHeader();
    }

    @Nullable
    public KafkaAuditHeader getAuditHeader() {
        if (this._auditHeaderField != null) {
            return this._auditHeaderField;
        }
        Object __rawValue = this._map.get("auditHeader");
        this._auditHeaderField = __rawValue == null ? null : new KafkaAuditHeader(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditHeaderField;
    }

    public MetadataAuditEvent setAuditHeader(@Nullable KafkaAuditHeader value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditHeader(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditHeader();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
                this._auditHeaderField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
                this._auditHeaderField = value;
            }
        }
        return this;
    }

    public MetadataAuditEvent setAuditHeader(@Nonnull KafkaAuditHeader value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditHeader of com.linkedin.mxe.MetadataAuditEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
        this._auditHeaderField = value;
        return this;
    }

    public boolean hasOldSnapshot() {
        if (this._oldSnapshotField != null) {
            return true;
        }
        return this._map.containsKey("oldSnapshot");
    }

    public void removeOldSnapshot() {
        this._map.remove("oldSnapshot");
    }

    @Nullable
    public Snapshot getOldSnapshot(GetMode mode) {
        return this.getOldSnapshot();
    }

    @Nullable
    public Snapshot getOldSnapshot() {
        if (this._oldSnapshotField != null) {
            return this._oldSnapshotField;
        }
        Object __rawValue = this._map.get("oldSnapshot");
        this._oldSnapshotField = __rawValue == null ? null : new Snapshot(__rawValue);
        return this._oldSnapshotField;
    }

    public MetadataAuditEvent setOldSnapshot(@Nullable Snapshot value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOldSnapshot(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOldSnapshot();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "oldSnapshot", value.data());
                this._oldSnapshotField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "oldSnapshot", value.data());
                this._oldSnapshotField = value;
            }
        }
        return this;
    }

    public MetadataAuditEvent setOldSnapshot(@Nonnull Snapshot value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field oldSnapshot of com.linkedin.mxe.MetadataAuditEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "oldSnapshot", value.data());
        this._oldSnapshotField = value;
        return this;
    }

    public boolean hasOldSystemMetadata() {
        if (this._oldSystemMetadataField != null) {
            return true;
        }
        return this._map.containsKey("oldSystemMetadata");
    }

    public void removeOldSystemMetadata() {
        this._map.remove("oldSystemMetadata");
    }

    @Nullable
    public SystemMetadata getOldSystemMetadata(GetMode mode) {
        return this.getOldSystemMetadata();
    }

    @Nullable
    public SystemMetadata getOldSystemMetadata() {
        if (this._oldSystemMetadataField != null) {
            return this._oldSystemMetadataField;
        }
        Object __rawValue = this._map.get("oldSystemMetadata");
        this._oldSystemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._oldSystemMetadataField;
    }

    public MetadataAuditEvent setOldSystemMetadata(@Nullable SystemMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOldSystemMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOldSystemMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "oldSystemMetadata", value.data());
                this._oldSystemMetadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "oldSystemMetadata", value.data());
                this._oldSystemMetadataField = value;
            }
        }
        return this;
    }

    public MetadataAuditEvent setOldSystemMetadata(@Nonnull SystemMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field oldSystemMetadata of com.linkedin.mxe.MetadataAuditEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "oldSystemMetadata", value.data());
        this._oldSystemMetadataField = value;
        return this;
    }

    public boolean hasNewSnapshot() {
        if (this._newSnapshotField != null) {
            return true;
        }
        return this._map.containsKey("newSnapshot");
    }

    public void removeNewSnapshot() {
        this._map.remove("newSnapshot");
    }

    @Nullable
    public Snapshot getNewSnapshot(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNewSnapshot();
            }
            case DEFAULT: 
            case NULL: {
                if (this._newSnapshotField != null) {
                    return this._newSnapshotField;
                }
                Object __rawValue = this._map.get("newSnapshot");
                this._newSnapshotField = __rawValue == null ? null : new Snapshot(__rawValue);
                return this._newSnapshotField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Snapshot getNewSnapshot() {
        if (this._newSnapshotField != null) {
            return this._newSnapshotField;
        }
        Object __rawValue = this._map.get("newSnapshot");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("newSnapshot");
        }
        this._newSnapshotField = __rawValue == null ? null : new Snapshot(__rawValue);
        return this._newSnapshotField;
    }

    public MetadataAuditEvent setNewSnapshot(@Nullable Snapshot value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNewSnapshot(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field newSnapshot of com.linkedin.mxe.MetadataAuditEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "newSnapshot", value.data());
                this._newSnapshotField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNewSnapshot();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "newSnapshot", value.data());
                this._newSnapshotField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "newSnapshot", value.data());
                this._newSnapshotField = value;
            }
        }
        return this;
    }

    public MetadataAuditEvent setNewSnapshot(@Nonnull Snapshot value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field newSnapshot of com.linkedin.mxe.MetadataAuditEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "newSnapshot", value.data());
        this._newSnapshotField = value;
        return this;
    }

    public boolean hasNewSystemMetadata() {
        if (this._newSystemMetadataField != null) {
            return true;
        }
        return this._map.containsKey("newSystemMetadata");
    }

    public void removeNewSystemMetadata() {
        this._map.remove("newSystemMetadata");
    }

    @Nullable
    public SystemMetadata getNewSystemMetadata(GetMode mode) {
        return this.getNewSystemMetadata();
    }

    @Nullable
    public SystemMetadata getNewSystemMetadata() {
        if (this._newSystemMetadataField != null) {
            return this._newSystemMetadataField;
        }
        Object __rawValue = this._map.get("newSystemMetadata");
        this._newSystemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._newSystemMetadataField;
    }

    public MetadataAuditEvent setNewSystemMetadata(@Nullable SystemMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNewSystemMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNewSystemMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "newSystemMetadata", value.data());
                this._newSystemMetadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "newSystemMetadata", value.data());
                this._newSystemMetadataField = value;
            }
        }
        return this;
    }

    public MetadataAuditEvent setNewSystemMetadata(@Nonnull SystemMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field newSystemMetadata of com.linkedin.mxe.MetadataAuditEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "newSystemMetadata", value.data());
        this._newSystemMetadataField = value;
        return this;
    }

    public boolean hasOperation() {
        if (this._operationField != null) {
            return true;
        }
        return this._map.containsKey("operation");
    }

    public void removeOperation() {
        this._map.remove("operation");
    }

    @Nullable
    public MetadataAuditOperation getOperation(GetMode mode) {
        return this.getOperation();
    }

    @Nullable
    public MetadataAuditOperation getOperation() {
        if (this._operationField != null) {
            return this._operationField;
        }
        Object __rawValue = this._map.get("operation");
        this._operationField = DataTemplateUtil.coerceEnumOutput(__rawValue, MetadataAuditOperation.class, MetadataAuditOperation.$UNKNOWN);
        return this._operationField;
    }

    public MetadataAuditEvent setOperation(@Nullable MetadataAuditOperation value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operation", value.name());
                this._operationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operation", value.name());
                this._operationField = value;
            }
        }
        return this;
    }

    public MetadataAuditEvent setOperation(@Nonnull MetadataAuditOperation value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operation of com.linkedin.mxe.MetadataAuditEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operation", value.name());
        this._operationField = value;
        return this;
    }

    @Override
    public MetadataAuditEvent clone() throws CloneNotSupportedException {
        MetadataAuditEvent __clone = (MetadataAuditEvent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MetadataAuditEvent copy() throws CloneNotSupportedException {
        MetadataAuditEvent __copy = (MetadataAuditEvent)super.copy();
        __copy._auditHeaderField = null;
        __copy._newSnapshotField = null;
        __copy._oldSystemMetadataField = null;
        __copy._operationField = null;
        __copy._oldSnapshotField = null;
        __copy._newSystemMetadataField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MetadataAuditEvent __objectRef;

        private ChangeListener(MetadataAuditEvent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "auditHeader": {
                    this.__objectRef._auditHeaderField = null;
                    break;
                }
                case "newSnapshot": {
                    this.__objectRef._newSnapshotField = null;
                    break;
                }
                case "oldSystemMetadata": {
                    this.__objectRef._oldSystemMetadataField = null;
                    break;
                }
                case "operation": {
                    this.__objectRef._operationField = null;
                    break;
                }
                case "oldSnapshot": {
                    this.__objectRef._oldSnapshotField = null;
                    break;
                }
                case "newSystemMetadata": {
                    this.__objectRef._newSystemMetadataField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public KafkaAuditHeader.Fields auditHeader() {
            return new KafkaAuditHeader.Fields(this.getPathComponents(), "auditHeader");
        }

        public Snapshot.Fields oldSnapshot() {
            return new Snapshot.Fields(this.getPathComponents(), "oldSnapshot");
        }

        public SystemMetadata.Fields oldSystemMetadata() {
            return new SystemMetadata.Fields(this.getPathComponents(), "oldSystemMetadata");
        }

        public Snapshot.Fields newSnapshot() {
            return new Snapshot.Fields(this.getPathComponents(), "newSnapshot");
        }

        public SystemMetadata.Fields newSystemMetadata() {
            return new SystemMetadata.Fields(this.getPathComponents(), "newSystemMetadata");
        }

        public PathSpec operation() {
            return new PathSpec(this.getPathComponents(), "operation");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private KafkaAuditHeader.ProjectionMask _auditHeaderMask;
        private Snapshot.ProjectionMask _oldSnapshotMask;
        private SystemMetadata.ProjectionMask _oldSystemMetadataMask;
        private Snapshot.ProjectionMask _newSnapshotMask;
        private SystemMetadata.ProjectionMask _newSystemMetadataMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withAuditHeader(Function<KafkaAuditHeader.ProjectionMask, KafkaAuditHeader.ProjectionMask> nestedMask) {
            this._auditHeaderMask = nestedMask.apply(this._auditHeaderMask == null ? KafkaAuditHeader.createMask() : this._auditHeaderMask);
            this.getDataMap().put("auditHeader", this._auditHeaderMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditHeader() {
            this._auditHeaderMask = null;
            this.getDataMap().put("auditHeader", 1);
            return this;
        }

        public ProjectionMask withOldSnapshot(Function<Snapshot.ProjectionMask, Snapshot.ProjectionMask> nestedMask) {
            this._oldSnapshotMask = nestedMask.apply(this._oldSnapshotMask == null ? Snapshot.createMask() : this._oldSnapshotMask);
            this.getDataMap().put("oldSnapshot", this._oldSnapshotMask.getDataMap());
            return this;
        }

        public ProjectionMask withOldSnapshot() {
            this._oldSnapshotMask = null;
            this.getDataMap().put("oldSnapshot", 1);
            return this;
        }

        public ProjectionMask withOldSystemMetadata(Function<SystemMetadata.ProjectionMask, SystemMetadata.ProjectionMask> nestedMask) {
            this._oldSystemMetadataMask = nestedMask.apply(this._oldSystemMetadataMask == null ? SystemMetadata.createMask() : this._oldSystemMetadataMask);
            this.getDataMap().put("oldSystemMetadata", this._oldSystemMetadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withOldSystemMetadata() {
            this._oldSystemMetadataMask = null;
            this.getDataMap().put("oldSystemMetadata", 1);
            return this;
        }

        public ProjectionMask withNewSnapshot(Function<Snapshot.ProjectionMask, Snapshot.ProjectionMask> nestedMask) {
            this._newSnapshotMask = nestedMask.apply(this._newSnapshotMask == null ? Snapshot.createMask() : this._newSnapshotMask);
            this.getDataMap().put("newSnapshot", this._newSnapshotMask.getDataMap());
            return this;
        }

        public ProjectionMask withNewSnapshot() {
            this._newSnapshotMask = null;
            this.getDataMap().put("newSnapshot", 1);
            return this;
        }

        public ProjectionMask withNewSystemMetadata(Function<SystemMetadata.ProjectionMask, SystemMetadata.ProjectionMask> nestedMask) {
            this._newSystemMetadataMask = nestedMask.apply(this._newSystemMetadataMask == null ? SystemMetadata.createMask() : this._newSystemMetadataMask);
            this.getDataMap().put("newSystemMetadata", this._newSystemMetadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withNewSystemMetadata() {
            this._newSystemMetadataMask = null;
            this.getDataMap().put("newSystemMetadata", 1);
            return this;
        }

        public ProjectionMask withOperation() {
            this.getDataMap().put("operation", 1);
            return this;
        }
    }
}

