/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.TimeStamp;
import com.linkedin.common.UrnArray;
import com.linkedin.common.VersionTag;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLModelGroupProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Properties associated with an ML Model Group*/@Aspect.name=\"mlModelGroupProperties\"record MLModelGroupProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}/**A set of re-usable fields used to capture lineage information for ML Models and ML Model Groups*/record MLModelLineageInfo{/**List of jobs or process instances (if any) used to train the model or group. Visible in Lineage. Note that ML Models can also be specified as the output of a specific Data Process Instances (runs) via the DataProcessInstanceOutputs aspect.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"name\":\"TrainedBy\"}trainingJobs:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**List of jobs or process instances (if any) that use the model or group.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"UsedBy\"}downstreamJobs:optional array[com.linkedin.common.Urn]}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Display name of the MLModelGroup*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}name:optional string/**Documentation of the MLModelGroup*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Date when the MLModelGroup was developed*/@deprecated,createdAt:optional{namespace com.linkedin.common/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long}/**Time and Actor who created the MLModelGroup*/created:optional{namespace com.linkedin.common/**A standard event timestamp*/record TimeStamp{/**When did the event occur*/time:Time/**Optional: The actor urn involved in the event.*/actor:optional Urn}}/**Date when the MLModelGroup was last modified*/lastModified:optional com.linkedin.common.TimeStamp/**Version of the MLModelGroup*/version:optional{namespace com.linkedin.common/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}}}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private UrnArray _trainingJobsField = null;
    private UrnArray _downstreamJobsField = null;
    private Url _externalUrlField = null;
    private String _nameField = null;
    private String _descriptionField = null;
    private Long _createdAtField = null;
    private TimeStamp _createdField = null;
    private TimeStamp _lastModifiedField = null;
    private VersionTag _versionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_TrainingJobs;
    private static final RecordDataSchema.Field FIELD_DownstreamJobs;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_CreatedAt;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_Version;

    public MLModelGroupProperties() {
        super(new DataMap(14, 0.75f), SCHEMA, 8);
        this.addChangeListener(this.__changeListener);
    }

    public MLModelGroupProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public MLModelGroupProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.ml.metadata.MLModelGroupProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasTrainingJobs() {
        if (this._trainingJobsField != null) {
            return true;
        }
        return this._map.containsKey("trainingJobs");
    }

    public void removeTrainingJobs() {
        this._map.remove("trainingJobs");
    }

    @Nullable
    public UrnArray getTrainingJobs(GetMode mode) {
        return this.getTrainingJobs();
    }

    @Nullable
    public UrnArray getTrainingJobs() {
        if (this._trainingJobsField != null) {
            return this._trainingJobsField;
        }
        Object __rawValue = this._map.get("trainingJobs");
        this._trainingJobsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._trainingJobsField;
    }

    public MLModelGroupProperties setTrainingJobs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTrainingJobs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTrainingJobs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
                this._trainingJobsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
                this._trainingJobsField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setTrainingJobs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field trainingJobs of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
        this._trainingJobsField = value;
        return this;
    }

    public boolean hasDownstreamJobs() {
        if (this._downstreamJobsField != null) {
            return true;
        }
        return this._map.containsKey("downstreamJobs");
    }

    public void removeDownstreamJobs() {
        this._map.remove("downstreamJobs");
    }

    @Nullable
    public UrnArray getDownstreamJobs(GetMode mode) {
        return this.getDownstreamJobs();
    }

    @Nullable
    public UrnArray getDownstreamJobs() {
        if (this._downstreamJobsField != null) {
            return this._downstreamJobsField;
        }
        Object __rawValue = this._map.get("downstreamJobs");
        this._downstreamJobsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._downstreamJobsField;
    }

    public MLModelGroupProperties setDownstreamJobs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDownstreamJobs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDownstreamJobs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
                this._downstreamJobsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
                this._downstreamJobsField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setDownstreamJobs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field downstreamJobs of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
        this._downstreamJobsField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public MLModelGroupProperties setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        return this.getName();
    }

    @Nullable
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public MLModelGroupProperties setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public MLModelGroupProperties setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    @Deprecated
    public boolean hasCreatedAt() {
        if (this._createdAtField != null) {
            return true;
        }
        return this._map.containsKey("createdAt");
    }

    @Deprecated
    public void removeCreatedAt() {
        this._map.remove("createdAt");
    }

    @Deprecated
    @Nullable
    public Long getCreatedAt(GetMode mode) {
        return this.getCreatedAt();
    }

    @Deprecated
    @Nullable
    public Long getCreatedAt() {
        if (this._createdAtField != null) {
            return this._createdAtField;
        }
        Object __rawValue = this._map.get("createdAt");
        this._createdAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._createdAtField;
    }

    @Deprecated
    public MLModelGroupProperties setCreatedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreatedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreatedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
                this._createdAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
                this._createdAtField = value;
            }
        }
        return this;
    }

    @Deprecated
    public MLModelGroupProperties setCreatedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createdAt of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
        this._createdAtField = value;
        return this;
    }

    @Deprecated
    public MLModelGroupProperties setCreatedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
        this._createdAtField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public TimeStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public TimeStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public MLModelGroupProperties setCreated(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setCreated(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public TimeStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public TimeStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public MLModelGroupProperties setLastModified(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setLastModified(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public VersionTag getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public VersionTag getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = __rawValue == null ? null : new VersionTag(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._versionField;
    }

    public MLModelGroupProperties setVersion(@Nullable VersionTag value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
            }
        }
        return this;
    }

    public MLModelGroupProperties setVersion(@Nonnull VersionTag value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.ml.metadata.MLModelGroupProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value.data());
        this._versionField = value;
        return this;
    }

    @Override
    public MLModelGroupProperties clone() throws CloneNotSupportedException {
        MLModelGroupProperties __clone = (MLModelGroupProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLModelGroupProperties copy() throws CloneNotSupportedException {
        MLModelGroupProperties __copy = (MLModelGroupProperties)super.copy();
        __copy._externalUrlField = null;
        __copy._createdAtField = null;
        __copy._customPropertiesField = null;
        __copy._createdField = null;
        __copy._downstreamJobsField = null;
        __copy._nameField = null;
        __copy._descriptionField = null;
        __copy._lastModifiedField = null;
        __copy._versionField = null;
        __copy._trainingJobsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_TrainingJobs = SCHEMA.getField("trainingJobs");
        FIELD_DownstreamJobs = SCHEMA.getField("downstreamJobs");
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_CreatedAt = SCHEMA.getField("createdAt");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Version = SCHEMA.getField("version");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLModelGroupProperties __objectRef;

        private ChangeListener(MLModelGroupProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "createdAt": {
                    this.__objectRef._createdAtField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "downstreamJobs": {
                    this.__objectRef._downstreamJobsField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "trainingJobs": {
                    this.__objectRef._trainingJobsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec trainingJobs() {
            return new PathSpec(this.getPathComponents(), "trainingJobs");
        }

        public PathSpec trainingJobs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "trainingJobs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec downstreamJobs() {
            return new PathSpec(this.getPathComponents(), "downstreamJobs");
        }

        public PathSpec downstreamJobs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "downstreamJobs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        @Deprecated
        public PathSpec createdAt() {
            return new PathSpec(this.getPathComponents(), "createdAt");
        }

        public TimeStamp.Fields created() {
            return new TimeStamp.Fields(this.getPathComponents(), "created");
        }

        public TimeStamp.Fields lastModified() {
            return new TimeStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public VersionTag.Fields version() {
            return new VersionTag.Fields(this.getPathComponents(), "version");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeStamp.ProjectionMask _createdMask;
        private TimeStamp.ProjectionMask _lastModifiedMask;
        private VersionTag.ProjectionMask _versionMask;

        ProjectionMask() {
            super(14);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withTrainingJobs() {
            this.getDataMap().put("trainingJobs", 1);
            return this;
        }

        public ProjectionMask withTrainingJobs(Integer start, Integer count) {
            this.getDataMap().put("trainingJobs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("trainingJobs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingJobs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDownstreamJobs() {
            this.getDataMap().put("downstreamJobs", 1);
            return this;
        }

        public ProjectionMask withDownstreamJobs(Integer start, Integer count) {
            this.getDataMap().put("downstreamJobs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("downstreamJobs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("downstreamJobs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withCreatedAt() {
            this.getDataMap().put("createdAt", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? TimeStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? TimeStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withVersion(Function<VersionTag.ProjectionMask, VersionTag.ProjectionMask> nestedMask) {
            this._versionMask = nestedMask.apply(this._versionMask == null ? VersionTag.createMask() : this._versionMask);
            this.getDataMap().put("version", this._versionMask.getDataMap());
            return this;
        }

        public ProjectionMask withVersion() {
            this._versionMask = null;
            this.getDataMap().put("version", 1);
            return this;
        }
    }
}

