/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.datahub.util.RecordUtils;
import com.linkedin.common.AuditStamp;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.mxe.SystemMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMetadataUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemMetadataUtils.class);
    private static final String NO_OP_KEY = "isNoOp";

    private SystemMetadataUtils() {
    }

    public static SystemMetadata createDefaultSystemMetadata() {
        return SystemMetadataUtils.generateSystemMetadataIfEmpty(null);
    }

    public static SystemMetadata createDefaultSystemMetadata(@Nullable String runId) {
        return SystemMetadataUtils.generateSystemMetadataIfEmpty(new SystemMetadata().setRunId(runId, SetMode.REMOVE_IF_NULL).setLastObserved(System.currentTimeMillis()));
    }

    public static SystemMetadata generateSystemMetadataIfEmpty(@Nullable SystemMetadata systemMetadata) {
        SystemMetadata result;
        SystemMetadata systemMetadata2 = result = systemMetadata == null ? new SystemMetadata() : systemMetadata;
        if (result.getRunId() == null) {
            result.setRunId("no-run-id-provided");
        }
        if (!result.hasLastObserved() || result.getLastObserved() == 0L) {
            result.setLastObserved(System.currentTimeMillis());
        }
        return result;
    }

    public static SystemMetadata setAspectModified(@Nonnull SystemMetadata systemMetadata, @Nullable AuditStamp auditStamp) {
        if (auditStamp != null && !"urn:li:corpuser:__datahub_system".equals(auditStamp.getActor().toString())) {
            systemMetadata.setAspectModified(auditStamp);
        }
        return systemMetadata;
    }

    public static SystemMetadata parseSystemMetadata(String jsonSystemMetadata) {
        if (jsonSystemMetadata == null || jsonSystemMetadata.equals("")) {
            return SystemMetadataUtils.createDefaultSystemMetadata();
        }
        return RecordUtils.toRecordTemplate(SystemMetadata.class, jsonSystemMetadata);
    }

    public static boolean isNoOp(@Nullable SystemMetadata systemMetadata) {
        if (systemMetadata != null && systemMetadata.hasProperties()) {
            return Boolean.parseBoolean(systemMetadata.getProperties().getOrDefault(NO_OP_KEY, "false"));
        }
        return false;
    }

    @Nullable
    public static SystemMetadata setNoOp(@Nullable SystemMetadata systemMetadata, boolean isNoOp) {
        if (systemMetadata != null) {
            if (!systemMetadata.hasProperties()) {
                systemMetadata.setProperties(new StringMap());
            }
            systemMetadata.getProperties().put(NO_OP_KEY, String.valueOf(isNoOp));
        }
        return systemMetadata;
    }
}

