/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilterValue
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search,record FilterValue{value:string,entity:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}facetCount:long,filtered:optional boolean}", SchemaFormatType.PDL);
    private String _valueField = null;
    private Urn _entityField = null;
    private Long _facetCountField = null;
    private Boolean _filteredField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Value = SCHEMA.getField("value");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_FacetCount = SCHEMA.getField("facetCount");
    private static final RecordDataSchema.Field FIELD_Filtered = SCHEMA.getField("filtered");

    public FilterValue() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public FilterValue(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasValue() {
        if (this._valueField != null) {
            return true;
        }
        return this._map.containsKey("value");
    }

    public void removeValue() {
        this._map.remove("value");
    }

    @Nullable
    public String getValue(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValue();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valueField != null) {
                    return this._valueField;
                }
                Object __rawValue = this._map.get("value");
                this._valueField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._valueField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getValue() {
        if (this._valueField != null) {
            return this._valueField;
        }
        Object __rawValue = this._map.get("value");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("value");
        }
        this._valueField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._valueField;
    }

    public FilterValue setValue(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field value of com.linkedin.metadata.search.FilterValue");
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
            }
        }
        return this;
    }

    public FilterValue setValue(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field value of com.linkedin.metadata.search.FilterValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "value", value);
        this._valueField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        return this.getEntity();
    }

    @Nullable
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public FilterValue setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public FilterValue setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.metadata.search.FilterValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasFacetCount() {
        if (this._facetCountField != null) {
            return true;
        }
        return this._map.containsKey("facetCount");
    }

    public void removeFacetCount() {
        this._map.remove("facetCount");
    }

    @Nullable
    public Long getFacetCount(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFacetCount();
            }
            case DEFAULT: 
            case NULL: {
                if (this._facetCountField != null) {
                    return this._facetCountField;
                }
                Object __rawValue = this._map.get("facetCount");
                this._facetCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._facetCountField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getFacetCount() {
        if (this._facetCountField != null) {
            return this._facetCountField;
        }
        Object __rawValue = this._map.get("facetCount");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("facetCount");
        }
        this._facetCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._facetCountField;
    }

    public FilterValue setFacetCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFacetCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field facetCount of com.linkedin.metadata.search.FilterValue");
                }
                CheckedUtil.putWithoutChecking(this._map, "facetCount", DataTemplateUtil.coerceLongInput(value));
                this._facetCountField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFacetCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "facetCount", DataTemplateUtil.coerceLongInput(value));
                this._facetCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "facetCount", DataTemplateUtil.coerceLongInput(value));
                this._facetCountField = value;
            }
        }
        return this;
    }

    public FilterValue setFacetCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field facetCount of com.linkedin.metadata.search.FilterValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "facetCount", DataTemplateUtil.coerceLongInput(value));
        this._facetCountField = value;
        return this;
    }

    public FilterValue setFacetCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "facetCount", DataTemplateUtil.coerceLongInput(value));
        this._facetCountField = value;
        return this;
    }

    public boolean hasFiltered() {
        if (this._filteredField != null) {
            return true;
        }
        return this._map.containsKey("filtered");
    }

    public void removeFiltered() {
        this._map.remove("filtered");
    }

    @Nullable
    public Boolean isFiltered(GetMode mode) {
        return this.isFiltered();
    }

    @Nullable
    public Boolean isFiltered() {
        if (this._filteredField != null) {
            return this._filteredField;
        }
        Object __rawValue = this._map.get("filtered");
        this._filteredField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._filteredField;
    }

    public FilterValue setFiltered(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFiltered(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFiltered();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filtered", value);
                this._filteredField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filtered", value);
                this._filteredField = value;
            }
        }
        return this;
    }

    public FilterValue setFiltered(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filtered of com.linkedin.metadata.search.FilterValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filtered", value);
        this._filteredField = value;
        return this;
    }

    public FilterValue setFiltered(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "filtered", value);
        this._filteredField = value;
        return this;
    }

    @Override
    public FilterValue clone() throws CloneNotSupportedException {
        FilterValue __clone = (FilterValue)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FilterValue copy() throws CloneNotSupportedException {
        FilterValue __copy = (FilterValue)super.copy();
        __copy._filteredField = null;
        __copy._facetCountField = null;
        __copy._valueField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FilterValue __objectRef;

        private ChangeListener(FilterValue reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "filtered": {
                    this.__objectRef._filteredField = null;
                    break;
                }
                case "facetCount": {
                    this.__objectRef._facetCountField = null;
                    break;
                }
                case "value": {
                    this.__objectRef._valueField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec value() {
            return new PathSpec(this.getPathComponents(), "value");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public PathSpec facetCount() {
            return new PathSpec(this.getPathComponents(), "facetCount");
        }

        public PathSpec filtered() {
            return new PathSpec(this.getPathComponents(), "filtered");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withValue() {
            this.getDataMap().put("value", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withFacetCount() {
            this.getDataMap().put("facetCount", 1);
            return this;
        }

        public ProjectionMask withFiltered() {
            this.getDataMap().put("filtered", 1);
            return this;
        }
    }
}

