/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.run;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.run.IngestionRunSummaryArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IngestionRunSummaryList
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.run,record IngestionRunSummaryList{ingestionRunSummaries:array[record IngestionRunSummary{runId:string,timestamp:long,rows:long}]}", SchemaFormatType.PDL);
    private IngestionRunSummaryArray _ingestionRunSummariesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_IngestionRunSummaries = SCHEMA.getField("ingestionRunSummaries");

    public IngestionRunSummaryList() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public IngestionRunSummaryList(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasIngestionRunSummaries() {
        if (this._ingestionRunSummariesField != null) {
            return true;
        }
        return this._map.containsKey("ingestionRunSummaries");
    }

    public void removeIngestionRunSummaries() {
        this._map.remove("ingestionRunSummaries");
    }

    @Nullable
    public IngestionRunSummaryArray getIngestionRunSummaries(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getIngestionRunSummaries();
            }
            case DEFAULT: 
            case NULL: {
                if (this._ingestionRunSummariesField != null) {
                    return this._ingestionRunSummariesField;
                }
                Object __rawValue = this._map.get("ingestionRunSummaries");
                this._ingestionRunSummariesField = __rawValue == null ? null : new IngestionRunSummaryArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._ingestionRunSummariesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IngestionRunSummaryArray getIngestionRunSummaries() {
        if (this._ingestionRunSummariesField != null) {
            return this._ingestionRunSummariesField;
        }
        Object __rawValue = this._map.get("ingestionRunSummaries");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("ingestionRunSummaries");
        }
        this._ingestionRunSummariesField = __rawValue == null ? null : new IngestionRunSummaryArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._ingestionRunSummariesField;
    }

    public IngestionRunSummaryList setIngestionRunSummaries(@Nullable IngestionRunSummaryArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIngestionRunSummaries(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field ingestionRunSummaries of com.linkedin.metadata.run.IngestionRunSummaryList");
                }
                CheckedUtil.putWithoutChecking(this._map, "ingestionRunSummaries", value.data());
                this._ingestionRunSummariesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIngestionRunSummaries();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "ingestionRunSummaries", value.data());
                this._ingestionRunSummariesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "ingestionRunSummaries", value.data());
                this._ingestionRunSummariesField = value;
            }
        }
        return this;
    }

    public IngestionRunSummaryList setIngestionRunSummaries(@Nonnull IngestionRunSummaryArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field ingestionRunSummaries of com.linkedin.metadata.run.IngestionRunSummaryList to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "ingestionRunSummaries", value.data());
        this._ingestionRunSummariesField = value;
        return this;
    }

    @Override
    public IngestionRunSummaryList clone() throws CloneNotSupportedException {
        IngestionRunSummaryList __clone = (IngestionRunSummaryList)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IngestionRunSummaryList copy() throws CloneNotSupportedException {
        IngestionRunSummaryList __copy = (IngestionRunSummaryList)super.copy();
        __copy._ingestionRunSummariesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IngestionRunSummaryList __objectRef;

        private ChangeListener(IngestionRunSummaryList reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "ingestionRunSummaries": {
                    this.__objectRef._ingestionRunSummariesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public IngestionRunSummaryArray.Fields ingestionRunSummaries() {
            return new IngestionRunSummaryArray.Fields(this.getPathComponents(), "ingestionRunSummaries");
        }

        public PathSpec ingestionRunSummaries(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "ingestionRunSummaries");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private IngestionRunSummaryArray.ProjectionMask _ingestionRunSummariesMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withIngestionRunSummaries(Function<IngestionRunSummaryArray.ProjectionMask, IngestionRunSummaryArray.ProjectionMask> nestedMask) {
            this._ingestionRunSummariesMask = nestedMask.apply(this._ingestionRunSummariesMask == null ? IngestionRunSummaryArray.createMask() : this._ingestionRunSummariesMask);
            this.getDataMap().put("ingestionRunSummaries", this._ingestionRunSummariesMask.getDataMap());
            return this;
        }

        public ProjectionMask withIngestionRunSummaries() {
            this._ingestionRunSummariesMask = null;
            this.getDataMap().put("ingestionRunSummaries", 1);
            return this;
        }

        public ProjectionMask withIngestionRunSummaries(Function<IngestionRunSummaryArray.ProjectionMask, IngestionRunSummaryArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._ingestionRunSummariesMask = nestedMask.apply(this._ingestionRunSummariesMask == null ? IngestionRunSummaryArray.createMask() : this._ingestionRunSummariesMask);
            this.getDataMap().put("ingestionRunSummaries", this._ingestionRunSummariesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("ingestionRunSummaries").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("ingestionRunSummaries").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withIngestionRunSummaries(Integer start, Integer count) {
            this._ingestionRunSummariesMask = null;
            this.getDataMap().put("ingestionRunSummaries", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("ingestionRunSummaries").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("ingestionRunSummaries").put("$count", count);
            }
            return this;
        }
    }
}

