/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.key;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChartKey
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.key/**Key for a Chart*/@Aspect.name=\"chartKey\"record ChartKey{/**The name of the dashboard tool such as looker, redash etc.*/@Searchable={\"boostScore\":4.0,\"fieldName\":\"tool\",\"fieldType\":\"TEXT_PARTIAL\"}dashboardTool:string/**Unique id for the chart. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, chart URL could be used here for Looker such as 'looker.linkedin.com/looks/1234'*/chartId:string}", SchemaFormatType.PDL);
    private String _dashboardToolField = null;
    private String _chartIdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DashboardTool = SCHEMA.getField("dashboardTool");
    private static final RecordDataSchema.Field FIELD_ChartId = SCHEMA.getField("chartId");

    public ChartKey() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public ChartKey(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDashboardTool() {
        if (this._dashboardToolField != null) {
            return true;
        }
        return this._map.containsKey("dashboardTool");
    }

    public void removeDashboardTool() {
        this._map.remove("dashboardTool");
    }

    @Nullable
    public String getDashboardTool(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDashboardTool();
            }
            case DEFAULT: 
            case NULL: {
                if (this._dashboardToolField != null) {
                    return this._dashboardToolField;
                }
                Object __rawValue = this._map.get("dashboardTool");
                this._dashboardToolField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._dashboardToolField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDashboardTool() {
        if (this._dashboardToolField != null) {
            return this._dashboardToolField;
        }
        Object __rawValue = this._map.get("dashboardTool");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("dashboardTool");
        }
        this._dashboardToolField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._dashboardToolField;
    }

    public ChartKey setDashboardTool(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDashboardTool(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dashboardTool of com.linkedin.metadata.key.ChartKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
                this._dashboardToolField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDashboardTool();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
                this._dashboardToolField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
                this._dashboardToolField = value;
            }
        }
        return this;
    }

    public ChartKey setDashboardTool(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dashboardTool of com.linkedin.metadata.key.ChartKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
        this._dashboardToolField = value;
        return this;
    }

    public boolean hasChartId() {
        if (this._chartIdField != null) {
            return true;
        }
        return this._map.containsKey("chartId");
    }

    public void removeChartId() {
        this._map.remove("chartId");
    }

    @Nullable
    public String getChartId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getChartId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._chartIdField != null) {
                    return this._chartIdField;
                }
                Object __rawValue = this._map.get("chartId");
                this._chartIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._chartIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getChartId() {
        if (this._chartIdField != null) {
            return this._chartIdField;
        }
        Object __rawValue = this._map.get("chartId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("chartId");
        }
        this._chartIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._chartIdField;
    }

    public ChartKey setChartId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChartId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field chartId of com.linkedin.metadata.key.ChartKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "chartId", value);
                this._chartIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChartId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "chartId", value);
                this._chartIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "chartId", value);
                this._chartIdField = value;
            }
        }
        return this;
    }

    public ChartKey setChartId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field chartId of com.linkedin.metadata.key.ChartKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "chartId", value);
        this._chartIdField = value;
        return this;
    }

    @Override
    public ChartKey clone() throws CloneNotSupportedException {
        ChartKey __clone = (ChartKey)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ChartKey copy() throws CloneNotSupportedException {
        ChartKey __copy = (ChartKey)super.copy();
        __copy._chartIdField = null;
        __copy._dashboardToolField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ChartKey __objectRef;

        private ChangeListener(ChartKey reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "chartId": {
                    this.__objectRef._chartIdField = null;
                    break;
                }
                case "dashboardTool": {
                    this.__objectRef._dashboardToolField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec dashboardTool() {
            return new PathSpec(this.getPathComponents(), "dashboardTool");
        }

        public PathSpec chartId() {
            return new PathSpec(this.getPathComponents(), "chartId");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withDashboardTool() {
            this.getDataMap().put("dashboardTool", 1);
            return this;
        }

        public ProjectionMask withChartId() {
            this.getDataMap().put("chartId", 1);
            return this;
        }
    }
}

