/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.authorization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.StringArray;
import com.linkedin.metadata.authorization.ApiGroup;
import com.linkedin.metadata.authorization.ApiOperation;
import com.linkedin.metadata.authorization.Conjunctive;
import com.linkedin.metadata.authorization.Disjunctive;
import com.linkedin.policy.DataHubActorFilter;
import com.linkedin.policy.DataHubPolicyInfo;
import com.linkedin.policy.DataHubResourceFilter;
import com.linkedin.policy.PolicyMatchCondition;
import com.linkedin.policy.PolicyMatchCriterion;
import com.linkedin.policy.PolicyMatchCriterionArray;
import com.linkedin.policy.PolicyMatchFilter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;

public class PoliciesConfig {
    public static final String PLATFORM_POLICY_TYPE = "PLATFORM";
    public static final String METADATA_POLICY_TYPE = "METADATA";
    public static final String ACTIVE_POLICY_STATE = "ACTIVE";
    public static final String INACTIVE_POLICY_STATE = "INACTIVE";
    static final Privilege MANAGE_POLICIES_PRIVILEGE = Privilege.of("MANAGE_POLICIES", "Manage Policies", "Create and remove access control policies. Be careful - Actors with this privilege are effectively super users.");
    static final Privilege MANAGE_INGESTION_PRIVILEGE = Privilege.of("MANAGE_INGESTION", "Manage Metadata Ingestion", "Create, remove, and update Metadata Ingestion sources.");
    static final Privilege MANAGE_SECRETS_PRIVILEGE = Privilege.of("MANAGE_SECRETS", "Manage Secrets", "Create & remove Secrets stored inside DataHub.");
    static final Privilege MANAGE_USERS_AND_GROUPS_PRIVILEGE = Privilege.of("MANAGE_USERS_AND_GROUPS", "Manage Users & Groups", "Create, remove, and update users and groups on DataHub.");
    static final Privilege CREATE_USERS_AND_GROUPS_PRIVILEGE = Privilege.of("CREATE_USERS_AND_GROUPS", "Create Users & Groups", "Create users and groups on DataHub.");
    static final Privilege UPDATE_USERS_AND_GROUPS_PRIVILEGE = Privilege.of("UPDATE_USERS_AND_GROUPS", "Update Users & Groups", "Update users and groups on DataHub.");
    static final Privilege CREATE_USERS_PRIVILEGE = Privilege.of("CREATE_USERS", "Create Users", "Create users on DataHub.");
    static final Privilege UPDATE_USERS_PRIVILEGE = Privilege.of("UPDATE_USERS", "Update Users", "Update users on DataHub.");
    static final Privilege CREATE_GROUPS_PRIVILEGE = Privilege.of("CREATE_GROUPS", "Create Groups", "Create groups on DataHub.");
    static final Privilege UPDATE_GROUPS_PRIVILEGE = Privilege.of("UPDATE_GROUPS", "Update Groups", "Update groups on DataHub.");
    private static final Privilege VIEW_ANALYTICS_PRIVILEGE = Privilege.of("VIEW_ANALYTICS", "View Analytics", "View the DataHub analytics dashboard.");
    private static final Privilege GET_ANALYTICS_PRIVILEGE = Privilege.of("GET_ANALYTICS_PRIVILEGE", "Analytics API access", "API read access to raw analytics data.");
    public static final Privilege GENERATE_PERSONAL_ACCESS_TOKENS_PRIVILEGE = Privilege.of("GENERATE_PERSONAL_ACCESS_TOKENS", "Generate Personal Access Tokens", "Generate personal access tokens for use with DataHub APIs.");
    public static final Privilege MANAGE_ACCESS_TOKENS = Privilege.of("MANAGE_ACCESS_TOKENS", "Manage All Access Tokens", "Create, list and revoke access tokens on behalf of users in DataHub. Be careful - Actors with this privilege are effectively super users that can impersonate other users.");
    public static final Privilege MANAGE_DOMAINS_PRIVILEGE = Privilege.of("MANAGE_DOMAINS", "Manage Domains", "Create and remove Asset Domains.");
    public static final Privilege MANAGE_GLOBAL_ANNOUNCEMENTS_PRIVILEGE = Privilege.of("MANAGE_GLOBAL_ANNOUNCEMENTS", "Manage Home Page Posts", "Create and delete home page posts");
    public static final Privilege VIEW_TESTS_PRIVILEGE = Privilege.of("VIEW_TESTS", "View Tests", "View Asset Tests.");
    public static final Privilege MANAGE_TESTS_PRIVILEGE = Privilege.of("MANAGE_TESTS", "Manage Tests", "Create and remove Asset Tests.");
    public static final Privilege MANAGE_GLOSSARIES_PRIVILEGE = Privilege.of("MANAGE_GLOSSARIES", "Manage Glossaries", "Create, edit, and remove Glossary Entities");
    public static final Privilege MANAGE_USER_CREDENTIALS_PRIVILEGE = Privilege.of("MANAGE_USER_CREDENTIALS", "Manage User Credentials", "Manage credentials for native DataHub users, including inviting new users and resetting passwords");
    public static final Privilege MANAGE_TAGS_PRIVILEGE = Privilege.of("MANAGE_TAGS", "Manage Tags", "Create and remove Tags.");
    public static final Privilege VIEW_MANAGE_TAGS_PRIVILEGE = Privilege.of("VIEW_MANAGE_TAGS", "View Manage Tags", "View the 'Manage Tags' page.");
    public static final Privilege CREATE_TAGS_PRIVILEGE = Privilege.of("CREATE_TAGS", "Create Tags", "Create new Tags.");
    public static final Privilege CREATE_DOMAINS_PRIVILEGE = Privilege.of("CREATE_DOMAINS", "Create Domains", "Create new Domains.");
    public static final Privilege CREATE_GLOBAL_ANNOUNCEMENTS_PRIVILEGE = Privilege.of("CREATE_GLOBAL_ANNOUNCEMENTS", "Create Global Announcements", "Create new Global Announcements.");
    public static final Privilege MANAGE_GLOBAL_VIEWS = Privilege.of("MANAGE_GLOBAL_VIEWS", "Manage Public Views", "Create, update, and delete any Public (shared) Views.");
    public static final Privilege MANAGE_GLOBAL_OWNERSHIP_TYPES = Privilege.of("MANAGE_GLOBAL_OWNERSHIP_TYPES", "Manage Ownership Types", "Create, update and delete Ownership Types.");
    public static final Privilege CREATE_BUSINESS_ATTRIBUTE_PRIVILEGE = Privilege.of("CREATE_BUSINESS_ATTRIBUTE", "Create Business Attribute", "Create new Business Attribute.");
    public static final Privilege MANAGE_BUSINESS_ATTRIBUTE_PRIVILEGE = Privilege.of("MANAGE_BUSINESS_ATTRIBUTE", "Manage Business Attribute", "Create, update, delete Business Attribute");
    public static final Privilege MANAGE_CONNECTIONS_PRIVILEGE = Privilege.of("MANAGE_CONNECTIONS", "Manage Connections", "Manage connections to external DataHub platforms.");
    private static final Privilege MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE = Privilege.of("MANAGE_STRUCTURED_PROPERTIES", "Manage Structured Properties", "Manage structured properties in your instance.");
    public static final Privilege VIEW_STRUCTURED_PROPERTIES_PAGE_PRIVILEGE = Privilege.of("VIEW_STRUCTURED_PROPERTIES_PAGE", "View Structured Properties", "View structured properties in your instance.");
    public static final Privilege MANAGE_DOCUMENTATION_FORMS_PRIVILEGE = Privilege.of("MANAGE_DOCUMENTATION_FORMS", "Manage Documentation Forms", "Manage forms assigned to assets to assist in documentation efforts.");
    public static final Privilege MANAGE_FEATURES_PRIVILEGE = Privilege.of("MANAGE_FEATURES", "Manage Features", "Umbrella privilege to manage all features.");
    public static final Privilege MANAGE_SYSTEM_OPERATIONS_PRIVILEGE = Privilege.of("MANAGE_SYSTEM_OPERATIONS", "Manage System Operations", "Allow access to all system operations/management APIs and controls.");
    public static final Privilege GET_PLATFORM_EVENTS_PRIVILEGE = Privilege.of("GET_PLATFORM_EVENTS", "Get Platform Events", "The ability to use the Events API to read Platform Events - Entity Change Events and Notification Request Events.");
    public static final Privilege GET_METADATA_CHANGE_LOG_EVENTS = Privilege.of("GET_METADATA_CHANGE_LOG_EVENTS", "Get Metadata Change Log Events", "The ability to use the Events API to read Metadata Change Log, or all low-level Metadata Change Events.");
    public static final Privilege MANAGE_HOME_PAGE_TEMPLATES_PRIVILEGE = Privilege.of("MANAGE_HOME_PAGE_TEMPLATES", "Manage Home Page Templates", "Privilege allowing users to manage the default home page template and the global modules in it.");
    public static final List<Privilege> PLATFORM_PRIVILEGES = ImmutableList.of(MANAGE_POLICIES_PRIVILEGE, MANAGE_USERS_AND_GROUPS_PRIVILEGE, CREATE_USERS_AND_GROUPS_PRIVILEGE, UPDATE_USERS_AND_GROUPS_PRIVILEGE, CREATE_USERS_PRIVILEGE, UPDATE_USERS_PRIVILEGE, CREATE_GROUPS_PRIVILEGE, UPDATE_GROUPS_PRIVILEGE, VIEW_ANALYTICS_PRIVILEGE, GET_ANALYTICS_PRIVILEGE, MANAGE_DOMAINS_PRIVILEGE, MANAGE_GLOBAL_ANNOUNCEMENTS_PRIVILEGE, new Privilege[]{MANAGE_INGESTION_PRIVILEGE, MANAGE_SECRETS_PRIVILEGE, GENERATE_PERSONAL_ACCESS_TOKENS_PRIVILEGE, MANAGE_ACCESS_TOKENS, VIEW_TESTS_PRIVILEGE, MANAGE_TESTS_PRIVILEGE, MANAGE_GLOSSARIES_PRIVILEGE, MANAGE_USER_CREDENTIALS_PRIVILEGE, MANAGE_TAGS_PRIVILEGE, VIEW_MANAGE_TAGS_PRIVILEGE, CREATE_TAGS_PRIVILEGE, CREATE_DOMAINS_PRIVILEGE, CREATE_GLOBAL_ANNOUNCEMENTS_PRIVILEGE, MANAGE_GLOBAL_VIEWS, MANAGE_GLOBAL_OWNERSHIP_TYPES, CREATE_BUSINESS_ATTRIBUTE_PRIVILEGE, MANAGE_BUSINESS_ATTRIBUTE_PRIVILEGE, MANAGE_CONNECTIONS_PRIVILEGE, MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE, VIEW_STRUCTURED_PROPERTIES_PAGE_PRIVILEGE, MANAGE_DOCUMENTATION_FORMS_PRIVILEGE, MANAGE_FEATURES_PRIVILEGE, MANAGE_SYSTEM_OPERATIONS_PRIVILEGE, GET_PLATFORM_EVENTS_PRIVILEGE, GET_METADATA_CHANGE_LOG_EVENTS, MANAGE_HOME_PAGE_TEMPLATES_PRIVILEGE});
    static final Privilege VIEW_ENTITY_PAGE_PRIVILEGE = Privilege.of("VIEW_ENTITY_PAGE", "View Entity Page", "The ability to view the entity page.");
    static final Privilege EXISTS_ENTITY_PRIVILEGE = Privilege.of("EXISTS_ENTITY", "Entity Exists", "The ability to determine whether the entity exists.");
    static final Privilege EXECUTE_ENTITY_PRIVILEGE = Privilege.of("EXECUTE_ENTITY", "Execute Entity", "The ability to execute an Entity.");
    static final Privilege CREATE_ENTITY_PRIVILEGE = Privilege.of("CREATE_ENTITY", "Create Entity", "The ability to create an entity if it doesn't exist.");
    public static final Privilege EDIT_ENTITY_TAGS_PRIVILEGE = Privilege.of("EDIT_ENTITY_TAGS", "Edit Tags", "The ability to add and remove tags to an asset.");
    public static final Privilege EDIT_ENTITY_GLOSSARY_TERMS_PRIVILEGE = Privilege.of("EDIT_ENTITY_GLOSSARY_TERMS", "Edit Glossary Terms", "The ability to add and remove glossary terms to an asset.");
    public static final Privilege EDIT_ENTITY_OWNERS_PRIVILEGE = Privilege.of("EDIT_ENTITY_OWNERS", "Edit Owners", "The ability to add and remove owners of an entity.");
    public static final Privilege EDIT_ENTITY_DOCS_PRIVILEGE = Privilege.of("EDIT_ENTITY_DOCS", "Edit Description", "The ability to edit the description (documentation) of an entity.");
    public static final Privilege EDIT_ENTITY_DOC_LINKS_PRIVILEGE = Privilege.of("EDIT_ENTITY_DOC_LINKS", "Edit Links", "The ability to edit links associated with an entity.");
    public static final Privilege EDIT_ENTITY_STATUS_PRIVILEGE = Privilege.of("EDIT_ENTITY_STATUS", "Edit Status", "The ability to edit the status of an entity (soft deleted or not).");
    public static final Privilege EDIT_ENTITY_DOMAINS_PRIVILEGE = Privilege.of("EDIT_DOMAINS_PRIVILEGE", "Edit Domain", "The ability to edit the Domain of an entity.");
    public static final Privilege EDIT_ENTITY_APPLICATIONS_PRIVILEGE = Privilege.of("EDIT_ENTITY_APPLICATIONS_PRIVILEGE", "Edit Entity Applications", "The ability to edit the Applications of an entity.");
    public static final Privilege EDIT_ENTITY_DATA_PRODUCTS_PRIVILEGE = Privilege.of("EDIT_ENTITY_DATA_PRODUCTS", "Edit Data Product", "The ability to edit the Data Product of an entity.");
    public static final Privilege EDIT_ENTITY_DEPRECATION_PRIVILEGE = Privilege.of("EDIT_DEPRECATION_PRIVILEGE", "Edit Deprecation", "The ability to edit the Deprecation status of an entity.");
    public static final Privilege EDIT_ENTITY_ASSERTIONS_PRIVILEGE = Privilege.of("EDIT_ENTITY_ASSERTIONS", "Edit Assertions", "The ability to add and remove assertions from an entity.");
    public static final Privilege EDIT_ENTITY_OPERATIONS_PRIVILEGE = Privilege.of("EDIT_ENTITY_OPERATIONS", "Edit Operations", "The ability to report or edit operations information about an entity.");
    public static final Privilege EDIT_ENTITY_INCIDENTS_PRIVILEGE = Privilege.of("EDIT_ENTITY_INCIDENTS", "Edit Incidents", "The ability to create and remove incidents for an entity.");
    public static final Privilege EDIT_ENTITY_PRIVILEGE = Privilege.of("EDIT_ENTITY", "Edit Entity", "The ability to edit any information about an entity. Super user privileges for the entity.");
    static final Privilege DELETE_ENTITY_PRIVILEGE = Privilege.of("DELETE_ENTITY", "Delete", "The ability to delete this entity.");
    static final Privilege EDIT_LINEAGE_PRIVILEGE = Privilege.of("EDIT_LINEAGE", "Edit Lineage", "The ability to add and remove lineage edges for this entity.");
    public static final Privilege EDIT_ENTITY_EMBED_PRIVILEGE = Privilege.of("EDIT_ENTITY_EMBED", "Edit Embedded Content", "The ability to edit the embedded content for an entity.");
    public static final Privilege EDIT_ENTITY_PROPERTIES_PRIVILEGE = Privilege.of("EDIT_ENTITY_PROPERTIES", "Edit Properties", "The ability to edit the properties for an entity.");
    public static final Privilege CREATE_ER_MODEL_RELATIONSHIP_PRIVILEGE = Privilege.of("CREATE_ENTITY_ER_MODEL_RELATIONSHIP", "Create erModelRelationship", "The ability to add erModelRelationship on a dataset.");
    public static final Privilege MANAGE_ASSET_SUMMARY_PRIVILEGE = Privilege.of("MANAGE_ASSET_SUMMARY", "Manage Asset Summary", "The ability to manage the asset summary tab for an entity.");
    public static final List<Privilege> COMMON_ENTITY_PRIVILEGES = ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_TAGS_PRIVILEGE, EDIT_ENTITY_GLOSSARY_TERMS_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_DOC_LINKS_PRIVILEGE, EDIT_ENTITY_STATUS_PRIVILEGE, EDIT_ENTITY_DOMAINS_PRIVILEGE, EDIT_ENTITY_APPLICATIONS_PRIVILEGE, EDIT_ENTITY_DATA_PRODUCTS_PRIVILEGE, EDIT_ENTITY_DEPRECATION_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, new Privilege[]{DELETE_ENTITY_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, EDIT_ENTITY_INCIDENTS_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE, MANAGE_ASSET_SUMMARY_PRIVILEGE});
    public static final Privilege EDIT_DATASET_COL_TAGS_PRIVILEGE = Privilege.of("EDIT_DATASET_COL_TAGS", "Edit Dataset Column Tags", "The ability to edit the column (field) tags associated with a dataset schema.");
    public static final Privilege EDIT_DATASET_COL_GLOSSARY_TERMS_PRIVILEGE = Privilege.of("EDIT_DATASET_COL_GLOSSARY_TERMS", "Edit Dataset Column Glossary Terms", "The ability to edit the column (field) glossary terms associated with a dataset schema.");
    public static final Privilege EDIT_DATASET_COL_DESCRIPTION_PRIVILEGE = Privilege.of("EDIT_DATASET_COL_DESCRIPTION", "Edit Dataset Column Descriptions", "The ability to edit the column (field) descriptions associated with a dataset schema.");
    public static final Privilege VIEW_DATASET_USAGE_PRIVILEGE = Privilege.of("VIEW_DATASET_USAGE", "View Dataset Usage", "The ability to access dataset usage information (includes usage statistics and queries).");
    public static final Privilege VIEW_DATASET_PROFILE_PRIVILEGE = Privilege.of("VIEW_DATASET_PROFILE", "View Dataset Profile", "The ability to access dataset profile (snapshot statistics)");
    public static final Privilege VIEW_DATASET_OPERATIONS_PRIVILEGE = Privilege.of("VIEW_DATASET_OPERATIONS", "View Dataset Operations", "The ability to access dataset operations (changes to dataset)");
    public static final Privilege EDIT_QUERIES_PRIVILEGE = Privilege.of("EDIT_ENTITY_QUERIES", "Edit Dataset Queries", "The ability to edit the Queries for a Dataset.");
    public static final Privilege EDIT_ENTITY_DATA_CONTRACT_PRIVILEGE = Privilege.of("EDIT_ENTITY_DATA_CONTRACT", "Edit Data Contract", "The ability to edit the Data Contract for an entity.");
    public static final Privilege DATA_READ_ONLY_PRIVILEGE = Privilege.of("DATA_READ_ONLY", "Iceberg Catalog Read only data-access", "The ability to read the data in a dataset.");
    public static final Privilege DATA_READ_WRITE_PRIVILEGE = Privilege.of("DATA_READ_WRITE", "Iceberg Catalog Read-write data-access", "The ability to read & write the data in a dataset.");
    public static final Privilege DATA_MANAGE_TABLES_PRIVILEGE = Privilege.of("DATA_MANAGE_TABLES", "Manage Iceberg Tables", "The ability to create and drop Iceberg tables registered in DataHub.");
    public static final Privilege DATA_MANAGE_VIEWS_PRIVILEGE = Privilege.of("DATA_MANAGE_VIEWS", "Manage Iceberg Views", "The ability to create and drop views registered in DataHub.");
    public static final Privilege DATA_MANAGE_NAMESPACES_PRIVILEGE = Privilege.of("DATA_MANAGE_NAMESPACES", "Manage Iceberg Namespaces", "The ability to create and drop Iceberg namespaces registered in DataHub.");
    public static final Privilege DATA_LIST_ENTITIES_PRIVILEGE = Privilege.of("DATA_LIST_ENTITIES", "List Iceberg Tables, Views & Namespaces", "The ability to list Iceberg tables, views and namespaces registered in DataHub.");
    public static final Privilege EDIT_TAG_COLOR_PRIVILEGE = Privilege.of("EDIT_TAG_COLOR", "Edit Tag Color", "The ability to change the color of a Tag.");
    public static final Privilege EDIT_GROUP_MEMBERS_PRIVILEGE = Privilege.of("EDIT_GROUP_MEMBERS", "Edit Group Members", "The ability to add and remove members to a group.");
    public static final Privilege EDIT_USER_PROFILE_PRIVILEGE = Privilege.of("EDIT_USER_PROFILE", "Edit User Profile", "The ability to change the user's profile including display name, bio, title, profile image, etc.");
    public static final Privilege EDIT_CONTACT_INFO_PRIVILEGE = Privilege.of("EDIT_CONTACT_INFO", "Edit Contact Information", "The ability to change the contact information such as email & chat handles.");
    public static final Privilege MANAGE_GLOSSARY_CHILDREN_PRIVILEGE = Privilege.of("MANAGE_GLOSSARY_CHILDREN", "Manage Direct Glossary Children", "The ability to create and delete the direct children of this entity.");
    public static final Privilege MANAGE_ALL_GLOSSARY_CHILDREN_PRIVILEGE = Privilege.of("MANAGE_ALL_GLOSSARY_CHILDREN", "Manage All Glossary Children", "The ability to create and delete everything underneath this entity.");
    public static final Privilege GET_TIMELINE_PRIVILEGE = Privilege.of("GET_TIMELINE_PRIVILEGE", "Get Timeline API", "The ability to use the GET Timeline API.");
    static final Privilege GET_ENTITY_PRIVILEGE = Privilege.of("GET_ENTITY_PRIVILEGE", "Get Entity + Relationships API", "The ability to use the GET Entity and Relationships API.");
    static final Privilege GET_TIMESERIES_ASPECT_PRIVILEGE = Privilege.of("GET_TIMESERIES_ASPECT_PRIVILEGE", "Get Timeseries Aspect API", "The ability to use the GET Timeseries Aspect API.");
    static final Privilege GET_COUNTS_PRIVILEGE = Privilege.of("GET_COUNTS_PRIVILEGE", "Get Aspect/Entity Count APIs", "The ability to use the GET Aspect/Entity Count APIs.");
    public static final Privilege RESTORE_INDICES_PRIVILEGE = Privilege.of("RESTORE_INDICES_PRIVILEGE", "Restore Indices API", "The ability to use the Restore Indices API.");
    public static final Privilege GET_TIMESERIES_INDEX_SIZES_PRIVILEGE = Privilege.of("GET_TIMESERIES_INDEX_SIZES_PRIVILEGE", "Get Timeseries index sizes API", "The ability to use the get Timeseries indices size API.");
    public static final Privilege TRUNCATE_TIMESERIES_INDEX_PRIVILEGE = Privilege.of("TRUNCATE_TIMESERIES_INDEX_PRIVILEGE", "Truncate timeseries aspect index size API", "The ability to use the API to truncate a timeseries index.");
    public static final Privilege GET_ES_TASK_STATUS_PRIVILEGE = Privilege.of("GET_ES_TASK_STATUS_PRIVILEGE", "Get ES task status API", "The ability to use the get task status API for an ElasticSearch task.");
    public static final Privilege ES_EXPLAIN_QUERY_PRIVILEGE = Privilege.of("ES_EXPLAIN_QUERY_PRIVILEGE", "Explain ElasticSearch Query API", "The ability to use the Operations API explain endpoint.");
    @Deprecated
    static final Privilege SEARCH_PRIVILEGE = Privilege.of("SEARCH_PRIVILEGE", "Search API", "The ability to access search APIs.");
    public static final Privilege SET_WRITEABLE_PRIVILEGE = Privilege.of("SET_WRITEABLE_PRIVILEGE", "Enable/Disable Writeability API", "The ability to enable or disable GMS writeability for data migrations.");
    public static final Privilege APPLY_RETENTION_PRIVILEGE = Privilege.of("APPLY_RETENTION_PRIVILEGE", "Apply Retention API", "The ability to apply retention using the API.");
    public static final Privilege PRODUCE_PLATFORM_EVENT_PRIVILEGE = Privilege.of("PRODUCE_PLATFORM_EVENT_PRIVILEGE", "Produce Platform Event API", "The ability to produce Platform Events using the API.");
    public static final Privilege EDIT_DATASET_COL_BUSINESS_ATTRIBUTE_PRIVILEGE = Privilege.of("EDIT_DATASET_COL_BUSINESS_ATTRIBUTE_PRIVILEGE", "Edit Dataset Column Business Attribute", "The ability to edit the column (field) Business Attribute associated with a dataset schema.");
    public static final ResourcePrivileges DATASET_PRIVILEGES = ResourcePrivileges.of("dataset", "Datasets", "Datasets indexed by DataHub", Stream.of(COMMON_ENTITY_PRIVILEGES, ImmutableList.of(VIEW_DATASET_USAGE_PRIVILEGE, VIEW_DATASET_PROFILE_PRIVILEGE, VIEW_DATASET_OPERATIONS_PRIVILEGE, EDIT_DATASET_COL_DESCRIPTION_PRIVILEGE, EDIT_DATASET_COL_TAGS_PRIVILEGE, EDIT_DATASET_COL_GLOSSARY_TERMS_PRIVILEGE, EDIT_ENTITY_ASSERTIONS_PRIVILEGE, EDIT_LINEAGE_PRIVILEGE, EDIT_ENTITY_EMBED_PRIVILEGE, EDIT_QUERIES_PRIVILEGE, DATA_READ_ONLY_PRIVILEGE, DATA_READ_WRITE_PRIVILEGE, new Privilege[]{EDIT_DATASET_COL_BUSINESS_ATTRIBUTE_PRIVILEGE})).flatMap(Collection::stream).collect(Collectors.toList()));
    public static final ResourcePrivileges CHART_PRIVILEGES = ResourcePrivileges.of("chart", "Charts", "Charts indexed by DataHub", Stream.concat(COMMON_ENTITY_PRIVILEGES.stream(), ImmutableList.of(EDIT_LINEAGE_PRIVILEGE, EDIT_ENTITY_EMBED_PRIVILEGE).stream()).collect(Collectors.toList()));
    public static final ResourcePrivileges DASHBOARD_PRIVILEGES = ResourcePrivileges.of("dashboard", "Dashboards", "Dashboards indexed by DataHub", Stream.concat(COMMON_ENTITY_PRIVILEGES.stream(), ImmutableList.of(EDIT_LINEAGE_PRIVILEGE, EDIT_ENTITY_EMBED_PRIVILEGE).stream()).collect(Collectors.toList()));
    public static final ResourcePrivileges NOTEBOOK_PRIVILEGES = ResourcePrivileges.of("notebook", "Notebook", "Notebook indexed by DataHub", COMMON_ENTITY_PRIVILEGES);
    public static final ResourcePrivileges DATA_FLOW_PRIVILEGES = ResourcePrivileges.of("dataFlow", "Data Pipelines", "Data Pipelines indexed by DataHub", COMMON_ENTITY_PRIVILEGES);
    public static final ResourcePrivileges DATA_JOB_PRIVILEGES = ResourcePrivileges.of("dataJob", "Data Tasks", "Data Tasks indexed by DataHub", Stream.concat(COMMON_ENTITY_PRIVILEGES.stream(), ImmutableList.of(EDIT_LINEAGE_PRIVILEGE).stream()).collect(Collectors.toList()));
    public static final ResourcePrivileges TAG_PRIVILEGES = ResourcePrivileges.of("tag", "Tags", "Tags indexed by DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_TAG_COLOR_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges CONTAINER_PRIVILEGES = ResourcePrivileges.of("container", "Containers", "Containers indexed by DataHub", Stream.of(COMMON_ENTITY_PRIVILEGES, ImmutableList.of(DATA_MANAGE_NAMESPACES_PRIVILEGE, DATA_MANAGE_TABLES_PRIVILEGE, DATA_MANAGE_VIEWS_PRIVILEGE, DATA_LIST_ENTITIES_PRIVILEGE)).flatMap(Collection::stream).collect(Collectors.toList()));
    public static final Privilege MANAGE_DATA_PRODUCTS_PRIVILEGE = Privilege.of("MANAGE_DATA_PRODUCTS", "Manage Data Products", "The ability to create, edit, and delete Data Products within a Domain");
    public static final ResourcePrivileges DOMAIN_PRIVILEGES = ResourcePrivileges.of("domain", "Domains", "Domains created on DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_DOC_LINKS_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, MANAGE_DATA_PRODUCTS_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges DATA_PRODUCT_PRIVILEGES = ResourcePrivileges.of("dataProduct", "Data Products", "Data Products created on DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_DOC_LINKS_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, EDIT_ENTITY_TAGS_PRIVILEGE, EDIT_ENTITY_GLOSSARY_TERMS_PRIVILEGE, EDIT_ENTITY_DOMAINS_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE, new Privilege[0]));
    public static final ResourcePrivileges APPLICATION_PRIVILEGES = ResourcePrivileges.of("application", "Applications", "Applications created on DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_DOC_LINKS_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, EDIT_ENTITY_TAGS_PRIVILEGE, EDIT_ENTITY_GLOSSARY_TERMS_PRIVILEGE, EDIT_ENTITY_DOMAINS_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges GLOSSARY_TERM_PRIVILEGES = ResourcePrivileges.of("glossaryTerm", "Glossary Terms", "Glossary Terms created on DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_DOC_LINKS_PRIVILEGE, EDIT_ENTITY_DEPRECATION_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges GLOSSARY_NODE_PRIVILEGES = ResourcePrivileges.of("glossaryNode", "Glossary Term Groups", "Glossary Term Groups created on DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_DOC_LINKS_PRIVILEGE, EDIT_ENTITY_DEPRECATION_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, MANAGE_GLOSSARY_CHILDREN_PRIVILEGE, MANAGE_ALL_GLOSSARY_CHILDREN_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges CORP_GROUP_PRIVILEGES = ResourcePrivileges.of("corpGroup", "Groups", "Groups on DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_GROUP_MEMBERS_PRIVILEGE, EDIT_CONTACT_INFO_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges CORP_USER_PRIVILEGES = ResourcePrivileges.of("corpuser", "Users", "Users on DataHub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_CONTACT_INFO_PRIVILEGE, EDIT_USER_PROFILE_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, EDIT_ENTITY_PROPERTIES_PRIVILEGE, CREATE_ENTITY_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges STRUCTURED_PROPERTIES_PRIVILEGES = ResourcePrivileges.of("structuredProperty", "Structured Properties", "Structured Properties", ImmutableList.of(CREATE_ENTITY_PRIVILEGE, VIEW_ENTITY_PAGE_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges ER_MODEL_RELATIONSHIP_PRIVILEGES = ResourcePrivileges.of("erModelRelationship", "ERModelRelationship", "update privileges for ermodelrelations", COMMON_ENTITY_PRIVILEGES);
    public static final ResourcePrivileges BUSINESS_ATTRIBUTE_PRIVILEGES = ResourcePrivileges.of("businessAttribute", "Business Attribute", "Business Attribute created on Datahub", ImmutableList.of(VIEW_ENTITY_PAGE_PRIVILEGE, EDIT_ENTITY_OWNERS_PRIVILEGE, EDIT_ENTITY_DOCS_PRIVILEGE, EDIT_ENTITY_TAGS_PRIVILEGE, EDIT_ENTITY_GLOSSARY_TERMS_PRIVILEGE));
    public static final ResourcePrivileges INGESTION_SOURCE_PRIVILEGES = ResourcePrivileges.of("dataHubIngestionSource", "Ingestion Source", "Privileges for Ingestion sources", ImmutableList.of(DELETE_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, EXECUTE_ENTITY_PRIVILEGE));
    public static final ResourcePrivileges VERSION_SET_PRIVILEGES = ResourcePrivileges.of("versionSet", "Version Set", "A logical collection of versioned entities.", COMMON_ENTITY_PRIVILEGES);
    public static final ResourcePrivileges PLATFORM_INSTANCE_PRIVILEGES = ResourcePrivileges.of("dataPlatformInstance", "Data Platform Instance", "Data Platform Instances on Datahub", ImmutableList.of(DATA_READ_ONLY_PRIVILEGE, DATA_READ_WRITE_PRIVILEGE, DATA_MANAGE_VIEWS_PRIVILEGE, DATA_MANAGE_TABLES_PRIVILEGE, DATA_MANAGE_NAMESPACES_PRIVILEGE, DATA_LIST_ENTITIES_PRIVILEGE));
    public static final List<ResourcePrivileges> ENTITY_RESOURCE_PRIVILEGES = ImmutableList.of(DATASET_PRIVILEGES, DASHBOARD_PRIVILEGES, CHART_PRIVILEGES, DATA_FLOW_PRIVILEGES, DATA_JOB_PRIVILEGES, TAG_PRIVILEGES, CONTAINER_PRIVILEGES, DOMAIN_PRIVILEGES, GLOSSARY_TERM_PRIVILEGES, GLOSSARY_NODE_PRIVILEGES, CORP_GROUP_PRIVILEGES, CORP_USER_PRIVILEGES, new ResourcePrivileges[]{NOTEBOOK_PRIVILEGES, DATA_PRODUCT_PRIVILEGES, ER_MODEL_RELATIONSHIP_PRIVILEGES, BUSINESS_ATTRIBUTE_PRIVILEGES, STRUCTURED_PROPERTIES_PRIVILEGES, INGESTION_SOURCE_PRIVILEGES, VERSION_SET_PRIVILEGES, PLATFORM_INSTANCE_PRIVILEGES, APPLICATION_PRIVILEGES});
    public static final ResourcePrivileges ALL_RESOURCE_PRIVILEGES = ResourcePrivileges.of("all", "All Types", "All Types", ENTITY_RESOURCE_PRIVILEGES.stream().flatMap(resourcePrivileges -> resourcePrivileges.getPrivileges().stream()).distinct().collect(Collectors.toList()));
    public static final List<ResourcePrivileges> RESOURCE_PRIVILEGES = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(ENTITY_RESOURCE_PRIVILEGES)).add(ALL_RESOURCE_PRIVILEGES)).build();
    public static Map<ApiGroup, Map<ApiOperation, Disjunctive<Conjunctive<Privilege>>>> API_PRIVILEGE_MAP = ImmutableMap.builder().put(ApiGroup.ENTITY, ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(CREATE_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.READ, Disjunctive.disjoint(VIEW_ENTITY_PAGE_PRIVILEGE, GET_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.EXECUTE, Disjunctive.disjoint(EXECUTE_ENTITY_PRIVILEGE)).put(ApiOperation.EXISTS, Disjunctive.disjoint(EXISTS_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, VIEW_ENTITY_PAGE_PRIVILEGE, SEARCH_PRIVILEGE)).build()).put(ApiGroup.LINEAGE, ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE, EDIT_LINEAGE_PRIVILEGE)).put(ApiOperation.READ, Disjunctive.disjoint(VIEW_ENTITY_PAGE_PRIVILEGE, GET_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, EDIT_LINEAGE_PRIVILEGE, DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE, EDIT_LINEAGE_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, EDIT_LINEAGE_PRIVILEGE)).put(ApiOperation.EXISTS, Disjunctive.disjoint(EXISTS_ENTITY_PRIVILEGE, VIEW_ENTITY_PAGE_PRIVILEGE, SEARCH_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, EDIT_LINEAGE_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, GET_ENTITY_PRIVILEGE)).build()).put(ApiGroup.RELATIONSHIP, ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.READ, Disjunctive.disjoint(VIEW_ENTITY_PAGE_PRIVILEGE, GET_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.EXISTS, Disjunctive.disjoint(EXISTS_ENTITY_PRIVILEGE, VIEW_ENTITY_PAGE_PRIVILEGE, SEARCH_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, GET_ENTITY_PRIVILEGE)).build()).put(ApiGroup.ANALYTICS, ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.DENY_ACCESS).put(ApiOperation.READ, Disjunctive.disjoint(VIEW_ANALYTICS_PRIVILEGE, GET_ANALYTICS_PRIVILEGE, MANAGE_SYSTEM_OPERATIONS_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.DENY_ACCESS).put(ApiOperation.DELETE, Disjunctive.DENY_ACCESS).put(ApiOperation.EXISTS, Disjunctive.disjoint(VIEW_ANALYTICS_PRIVILEGE, GET_ANALYTICS_PRIVILEGE, SEARCH_PRIVILEGE, MANAGE_SYSTEM_OPERATIONS_PRIVILEGE)).build()).put(ApiGroup.TIMESERIES, ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.READ, Disjunctive.disjoint(GET_TIMESERIES_ASPECT_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.EXISTS, Disjunctive.disjoint(EXISTS_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, SEARCH_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, GET_TIMESERIES_ASPECT_PRIVILEGE, VIEW_ENTITY_PAGE_PRIVILEGE)).build()).put(ApiGroup.COUNTS, ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.DENY_ACCESS).put(ApiOperation.READ, Disjunctive.disjoint(GET_COUNTS_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.DENY_ACCESS).put(ApiOperation.DELETE, Disjunctive.DENY_ACCESS).put(ApiOperation.EXISTS, Disjunctive.DENY_ACCESS).build()).build();
    public static final Map<String, Map<ApiOperation, Disjunctive<Conjunctive<Privilege>>>> API_ENTITY_PRIVILEGE_MAP = ImmutableMap.builder().put("dataHubPolicy", ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(MANAGE_POLICIES_PRIVILEGE)).put(ApiOperation.READ, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.READ)).put(ApiOperation.UPDATE, Disjunctive.disjoint(MANAGE_POLICIES_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(MANAGE_POLICIES_PRIVILEGE)).put(ApiOperation.EXISTS, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.EXISTS)).build()).put("corpuser", ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(CREATE_USERS_AND_GROUPS_PRIVILEGE, MANAGE_USERS_AND_GROUPS_PRIVILEGE, CREATE_USERS_PRIVILEGE, UPDATE_USERS_PRIVILEGE)).put(ApiOperation.READ, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.READ)).put(ApiOperation.UPDATE, Disjunctive.disjoint(UPDATE_USERS_AND_GROUPS_PRIVILEGE, MANAGE_USERS_AND_GROUPS_PRIVILEGE, UPDATE_USERS_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(MANAGE_USERS_AND_GROUPS_PRIVILEGE, UPDATE_USERS_PRIVILEGE)).put(ApiOperation.EXISTS, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.EXISTS)).build()).put("corpGroup", ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(CREATE_USERS_AND_GROUPS_PRIVILEGE, MANAGE_USERS_AND_GROUPS_PRIVILEGE, CREATE_GROUPS_PRIVILEGE, UPDATE_GROUPS_PRIVILEGE)).put(ApiOperation.READ, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.READ)).put(ApiOperation.UPDATE, Disjunctive.disjoint(UPDATE_USERS_AND_GROUPS_PRIVILEGE, MANAGE_USERS_AND_GROUPS_PRIVILEGE, UPDATE_GROUPS_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(MANAGE_USERS_AND_GROUPS_PRIVILEGE, UPDATE_GROUPS_PRIVILEGE)).put(ApiOperation.EXISTS, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.EXISTS)).build()).put("dataHubIngestionSource", ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(MANAGE_INGESTION_PRIVILEGE)).put(ApiOperation.READ, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.READ)).put(ApiOperation.UPDATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE, MANAGE_INGESTION_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(DELETE_ENTITY_PRIVILEGE, MANAGE_INGESTION_PRIVILEGE)).put(ApiOperation.EXECUTE, Disjunctive.disjoint(EXECUTE_ENTITY_PRIVILEGE, MANAGE_INGESTION_PRIVILEGE)).put(ApiOperation.EXISTS, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.EXISTS)).build()).put("dataHubSecret", ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(MANAGE_SECRETS_PRIVILEGE)).put(ApiOperation.READ, Disjunctive.disjoint(MANAGE_SECRETS_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.disjoint(MANAGE_SECRETS_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(MANAGE_SECRETS_PRIVILEGE)).put(ApiOperation.EXISTS, API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.EXISTS)).build()).put("dataHubAccessToken", ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(MANAGE_ACCESS_TOKENS, CREATE_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.READ, Disjunctive.disjoint(MANAGE_ACCESS_TOKENS, VIEW_ENTITY_PAGE_PRIVILEGE, GET_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.disjoint(MANAGE_ACCESS_TOKENS, EDIT_ENTITY_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(MANAGE_ACCESS_TOKENS, DELETE_ENTITY_PRIVILEGE)).put(ApiOperation.EXISTS, Disjunctive.disjoint(MANAGE_ACCESS_TOKENS, EXISTS_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, VIEW_ENTITY_PAGE_PRIVILEGE, SEARCH_PRIVILEGE)).build()).put("structuredProperty", ImmutableMap.builder().put(ApiOperation.CREATE, Disjunctive.disjoint(MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE)).put(ApiOperation.READ, Disjunctive.disjoint(VIEW_ENTITY_PAGE_PRIVILEGE, MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE)).put(ApiOperation.UPDATE, Disjunctive.disjoint(EDIT_ENTITY_PRIVILEGE, MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE)).put(ApiOperation.DELETE, Disjunctive.disjoint(DELETE_ENTITY_PRIVILEGE, MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE)).put(ApiOperation.EXECUTE, Disjunctive.disjoint(EXECUTE_ENTITY_PRIVILEGE, MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE)).put(ApiOperation.EXISTS, Disjunctive.disjoint(MANAGE_STRUCTURED_PROPERTIES_PRIVILEGE, EXISTS_ENTITY_PRIVILEGE, EDIT_ENTITY_PRIVILEGE, DELETE_ENTITY_PRIVILEGE, VIEW_ENTITY_PAGE_PRIVILEGE, SEARCH_PRIVILEGE)).build()).build();

    public static List<DataHubPolicyInfo> getDefaultPolicies(Urn actorUrn) {
        return ((ImmutableList.Builder)ImmutableList.builder().add(new DataHubPolicyInfo().setDisplayName("View Self").setDescription("View self entity page.").setActors(new DataHubActorFilter().setUsers(new UrnArray(actorUrn, new Urn[0]))).setPrivileges(API_PRIVILEGE_MAP.get((Object)ApiGroup.ENTITY).get((Object)ApiOperation.READ).stream().flatMap(Collection::stream).map(Privilege::getType).collect(Collectors.toCollection(StringArray::new))).setType(METADATA_POLICY_TYPE).setState(ACTIVE_POLICY_STATE).setEditable(false).setResources(new DataHubResourceFilter().setFilter(new PolicyMatchFilter().setCriteria(new PolicyMatchCriterionArray(List.of(new PolicyMatchCriterion().setField("URN").setCondition(PolicyMatchCondition.EQUALS).setValues(new StringArray(List.of(actorUrn.toString())))))))))).build();
    }

    private PoliciesConfig() {
    }

    public static class ResourcePrivileges {
        private String resourceType;
        private String resourceTypeDisplayName;
        private String resourceTypeDescription;
        private List<Privilege> privileges;

        static ResourcePrivileges of(String resourceType, String resourceTypeDisplayName, String resourceTypeDescription, List<Privilege> privileges) {
            return new ResourcePrivileges(resourceType, resourceTypeDisplayName, resourceTypeDescription, privileges);
        }

        @Generated
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Generated
        public void setResourceTypeDisplayName(String resourceTypeDisplayName) {
            this.resourceTypeDisplayName = resourceTypeDisplayName;
        }

        @Generated
        public void setResourceTypeDescription(String resourceTypeDescription) {
            this.resourceTypeDescription = resourceTypeDescription;
        }

        @Generated
        public void setPrivileges(List<Privilege> privileges) {
            this.privileges = privileges;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourcePrivileges)) {
                return false;
            }
            ResourcePrivileges other = (ResourcePrivileges)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resourceType = this.getResourceType();
            String other$resourceType = other.getResourceType();
            if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
                return false;
            }
            String this$resourceTypeDisplayName = this.getResourceTypeDisplayName();
            String other$resourceTypeDisplayName = other.getResourceTypeDisplayName();
            if (this$resourceTypeDisplayName == null ? other$resourceTypeDisplayName != null : !this$resourceTypeDisplayName.equals(other$resourceTypeDisplayName)) {
                return false;
            }
            String this$resourceTypeDescription = this.getResourceTypeDescription();
            String other$resourceTypeDescription = other.getResourceTypeDescription();
            if (this$resourceTypeDescription == null ? other$resourceTypeDescription != null : !this$resourceTypeDescription.equals(other$resourceTypeDescription)) {
                return false;
            }
            List<Privilege> this$privileges = this.getPrivileges();
            List<Privilege> other$privileges = other.getPrivileges();
            return !(this$privileges == null ? other$privileges != null : !((Object)this$privileges).equals(other$privileges));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourcePrivileges;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resourceType = this.getResourceType();
            result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
            String $resourceTypeDisplayName = this.getResourceTypeDisplayName();
            result = result * 59 + ($resourceTypeDisplayName == null ? 43 : $resourceTypeDisplayName.hashCode());
            String $resourceTypeDescription = this.getResourceTypeDescription();
            result = result * 59 + ($resourceTypeDescription == null ? 43 : $resourceTypeDescription.hashCode());
            List<Privilege> $privileges = this.getPrivileges();
            result = result * 59 + ($privileges == null ? 43 : ((Object)$privileges).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PoliciesConfig.ResourcePrivileges(resourceType=" + this.getResourceType() + ", resourceTypeDisplayName=" + this.getResourceTypeDisplayName() + ", resourceTypeDescription=" + this.getResourceTypeDescription() + ", privileges=" + String.valueOf(this.getPrivileges()) + ")";
        }

        @Generated
        public String getResourceType() {
            return this.resourceType;
        }

        @Generated
        public String getResourceTypeDisplayName() {
            return this.resourceTypeDisplayName;
        }

        @Generated
        public String getResourceTypeDescription() {
            return this.resourceTypeDescription;
        }

        @Generated
        public List<Privilege> getPrivileges() {
            return this.privileges;
        }

        @Generated
        public ResourcePrivileges(String resourceType, String resourceTypeDisplayName, String resourceTypeDescription, List<Privilege> privileges) {
            this.resourceType = resourceType;
            this.resourceTypeDisplayName = resourceTypeDisplayName;
            this.resourceTypeDescription = resourceTypeDescription;
            this.privileges = privileges;
        }
    }

    public static class Privilege {
        @Nonnull
        private String type;
        private String displayName;
        private String description;

        static Privilege of(String type, String displayName, String description) {
            return new Privilege(type, displayName, description);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Privilege privilege = (Privilege)o;
            return this.type.equals(privilege.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        @Generated
        public void setType(@Nonnull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public String toString() {
            return "PoliciesConfig.Privilege(type=" + this.getType() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
        }

        @Nonnull
        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Privilege(@Nonnull String type, String displayName, String description) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.displayName = displayName;
            this.description = description;
        }
    }
}

