/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.Edge;
import com.linkedin.common.urn.Urn;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;

public class PatchUtil {
    private static final String TIME_KEY = "time";
    private static final String ACTOR_KEY = "actor";
    private static final String IMPERSONATOR_KEY = "impersonator";
    private static final String MESSAGE_KEY = "message";
    private static final String LAST_MODIFIED_KEY = "lastModified";
    private static final String CREATED_KEY = "created";
    private static final String DESTINATION_URN_KEY = "destinationUrn";
    private static final String SOURCE_URN_KEY = "sourceUrn";
    private static final String PROPERTIES_KEY = "properties";

    private PatchUtil() {
    }

    public static ObjectNode createEdgeValue(@Nonnull Edge edge) {
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        ObjectNode created = JsonNodeFactory.instance.objectNode();
        if (edge.getCreated() == null) {
            created.put(TIME_KEY, System.currentTimeMillis()).put(ACTOR_KEY, "urn:li:corpuser:UNKNOWN");
        } else {
            created.put(TIME_KEY, edge.getCreated().getTime()).put(ACTOR_KEY, edge.getCreated().getActor().toString());
            if (edge.getCreated().getImpersonator() != null) {
                created.put(IMPERSONATOR_KEY, edge.getCreated().getImpersonator().toString());
            }
            if (edge.getCreated().getMessage() != null) {
                created.put(MESSAGE_KEY, edge.getCreated().getMessage());
            }
        }
        value.set(CREATED_KEY, created);
        ObjectNode lastModified = JsonNodeFactory.instance.objectNode();
        if (edge.getLastModified() == null) {
            lastModified.put(TIME_KEY, System.currentTimeMillis()).put(ACTOR_KEY, "urn:li:corpuser:UNKNOWN");
        } else {
            lastModified.put(TIME_KEY, edge.getLastModified().getTime()).put(ACTOR_KEY, edge.getLastModified().getActor().toString());
            if (edge.getLastModified().getImpersonator() != null) {
                lastModified.put(IMPERSONATOR_KEY, edge.getLastModified().getImpersonator().toString());
            }
            if (edge.getLastModified().getMessage() != null) {
                lastModified.put(MESSAGE_KEY, edge.getLastModified().getMessage());
            }
        }
        value.set(LAST_MODIFIED_KEY, lastModified);
        if (edge.getProperties() != null) {
            ObjectNode propertiesNode = JsonNodeFactory.instance.objectNode();
            edge.getProperties().forEach((k, v) -> propertiesNode.set((String)k, JsonNodeFactory.instance.textNode((String)v)));
            value.set(PROPERTIES_KEY, propertiesNode);
        }
        value.put(DESTINATION_URN_KEY, edge.getDestinationUrn().toString());
        if (edge.getSourceUrn() != null) {
            value.put(SOURCE_URN_KEY, edge.getSourceUrn().toString());
        }
        return value;
    }

    public static ObjectNode createEdgeValue(@Nonnull Urn urn) {
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        ObjectNode auditStamp = JsonNodeFactory.instance.objectNode();
        auditStamp.put(TIME_KEY, System.currentTimeMillis()).put(ACTOR_KEY, "urn:li:corpuser:UNKNOWN");
        value.put(DESTINATION_URN_KEY, urn.toString()).set(LAST_MODIFIED_KEY, auditStamp);
        value.set(CREATED_KEY, auditStamp);
        return value;
    }
}

