/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import com.linkedin.metadata.aspect.patch.builder.subtypesupport.IntermediatePatchBuilder;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class CustomPropertiesPatchBuilder<T extends AbstractMultiFieldPatchBuilder<T>>
implements IntermediatePatchBuilder<T> {
    public static final String CUSTOM_PROPERTIES_BASE_PATH = "/customProperties";
    private final T parent;
    private final List<ImmutableTriple<String, String, JsonNode>> operations;

    public CustomPropertiesPatchBuilder(T parentBuilder) {
        this.parent = parentBuilder;
        this.operations = parentBuilder != null ? ((AbstractMultiFieldPatchBuilder)parentBuilder).getPathValues() : new ArrayList<ImmutableTriple<String, String, JsonNode>>();
    }

    public CustomPropertiesPatchBuilder<T> addProperty(String key, String value) {
        this.operations.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/customProperties/" + key, JsonNodeFactory.instance.textNode(value)));
        return this;
    }

    public CustomPropertiesPatchBuilder<T> removeProperty(String key) {
        this.operations.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/customProperties/" + key, null));
        return this;
    }

    public CustomPropertiesPatchBuilder<T> setProperties(Map<String, String> properties) {
        ObjectNode propertiesNode = JsonNodeFactory.instance.objectNode();
        properties.forEach((key, value) -> propertiesNode.set((String)key, JsonNodeFactory.instance.textNode((String)value)));
        this.operations.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), CUSTOM_PROPERTIES_BASE_PATH, propertiesNode));
        return this;
    }

    @Override
    public T getParent() {
        return this.parent;
    }
}

