/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.entity.EnvelopedAspect;
import com.linkedin.metadata.aspect.EntityAspect;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.mxe.SystemMetadata;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;

public class EnvelopedSystemAspect
implements SystemAspect {
    @Nonnull
    private final Urn urn;
    @Nonnull
    private final EnvelopedAspect envelopedAspect;
    @Nonnull
    private final EntitySpec entitySpec;
    @Nonnull
    private final AspectSpec aspectSpec;

    public static SystemAspect of(@Nonnull Urn urn, @Nonnull EnvelopedAspect envelopedAspect, @Nonnull EntitySpec entitySpec) {
        return new EnvelopedSystemAspect(urn, envelopedAspect, entitySpec);
    }

    public EnvelopedSystemAspect(@Nonnull Urn urn, @Nonnull EnvelopedAspect envelopedAspect, @Nonnull EntitySpec entitySpec) {
        this.urn = urn;
        this.envelopedAspect = envelopedAspect;
        this.entitySpec = entitySpec;
        this.aspectSpec = this.entitySpec.getAspectSpec(envelopedAspect.getName());
    }

    @Override
    @Nullable
    public RecordTemplate getRecordTemplate() {
        return this.envelopedAspect.getValue();
    }

    @Override
    @Nullable
    public SystemMetadata getSystemMetadata() {
        return this.envelopedAspect.getSystemMetadata();
    }

    @Override
    public long getVersion() {
        return this.envelopedAspect.getVersion();
    }

    @Override
    public Timestamp getCreatedOn() {
        return Timestamp.from(Instant.ofEpochMilli(this.envelopedAspect.getCreated().getTime()));
    }

    @Override
    public String getCreatedBy() {
        return this.envelopedAspect.getCreated().getActor().toString();
    }

    @Override
    @Nonnull
    public SystemAspect copy() {
        try {
            return new EnvelopedSystemAspect(this.urn, new EnvelopedAspect(this.envelopedAspect.copy().data()), this.entitySpec, this.aspectSpec);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public EntityAspect asLatest() {
        throw new NotImplementedException();
    }

    @Override
    @Nonnull
    public EntityAspect withVersion(long version) {
        throw new NotImplementedException();
    }

    @Override
    @Nonnull
    public SystemAspect setSystemMetadata(@Nullable SystemMetadata systemMetadata) {
        throw new NotImplementedException();
    }

    @Override
    @Nonnull
    public SystemAspect setRecordTemplate(@Nonnull RecordTemplate recordTemplate) {
        throw new NotImplementedException();
    }

    @Override
    @Nonnull
    public SystemAspect setAuditStamp(@Nonnull AuditStamp auditStamp) {
        throw new NotImplementedException();
    }

    @Override
    @Nonnull
    public SystemAspect setDatabaseAspect(@Nonnull SystemAspect databaseAspect) {
        throw new NotImplementedException();
    }

    @Override
    @Nonnull
    public Optional<SystemAspect> getDatabaseAspect() {
        return Optional.empty();
    }

    @Generated
    public static EnvelopedSystemAspectBuilder builder() {
        return new EnvelopedSystemAspectBuilder();
    }

    @Generated
    public EnvelopedSystemAspectBuilder toBuilder() {
        return new EnvelopedSystemAspectBuilder().urn(this.urn).envelopedAspect(this.envelopedAspect).entitySpec(this.entitySpec).aspectSpec(this.aspectSpec);
    }

    @Generated
    public EnvelopedSystemAspect(@Nonnull Urn urn, @Nonnull EnvelopedAspect envelopedAspect, @Nonnull EntitySpec entitySpec, @Nonnull AspectSpec aspectSpec) {
        if (urn == null) {
            throw new NullPointerException("urn is marked non-null but is null");
        }
        if (envelopedAspect == null) {
            throw new NullPointerException("envelopedAspect is marked non-null but is null");
        }
        if (entitySpec == null) {
            throw new NullPointerException("entitySpec is marked non-null but is null");
        }
        if (aspectSpec == null) {
            throw new NullPointerException("aspectSpec is marked non-null but is null");
        }
        this.urn = urn;
        this.envelopedAspect = envelopedAspect;
        this.entitySpec = entitySpec;
        this.aspectSpec = aspectSpec;
    }

    @Override
    @Nonnull
    @Generated
    public Urn getUrn() {
        return this.urn;
    }

    @Override
    @Nonnull
    @Generated
    public EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    @Override
    @Nonnull
    @Generated
    public AspectSpec getAspectSpec() {
        return this.aspectSpec;
    }

    @Generated
    public static class EnvelopedSystemAspectBuilder {
        @Generated
        private Urn urn;
        @Generated
        private EnvelopedAspect envelopedAspect;
        @Generated
        private EntitySpec entitySpec;
        @Generated
        private AspectSpec aspectSpec;

        @Generated
        EnvelopedSystemAspectBuilder() {
        }

        @Generated
        public EnvelopedSystemAspectBuilder urn(@Nonnull Urn urn) {
            if (urn == null) {
                throw new NullPointerException("urn is marked non-null but is null");
            }
            this.urn = urn;
            return this;
        }

        @Generated
        public EnvelopedSystemAspectBuilder envelopedAspect(@Nonnull EnvelopedAspect envelopedAspect) {
            if (envelopedAspect == null) {
                throw new NullPointerException("envelopedAspect is marked non-null but is null");
            }
            this.envelopedAspect = envelopedAspect;
            return this;
        }

        @Generated
        public EnvelopedSystemAspectBuilder entitySpec(@Nonnull EntitySpec entitySpec) {
            if (entitySpec == null) {
                throw new NullPointerException("entitySpec is marked non-null but is null");
            }
            this.entitySpec = entitySpec;
            return this;
        }

        @Generated
        public EnvelopedSystemAspectBuilder aspectSpec(@Nonnull AspectSpec aspectSpec) {
            if (aspectSpec == null) {
                throw new NullPointerException("aspectSpec is marked non-null but is null");
            }
            this.aspectSpec = aspectSpec;
            return this;
        }

        @Generated
        public EnvelopedSystemAspect build() {
            return new EnvelopedSystemAspect(this.urn, this.envelopedAspect, this.entitySpec, this.aspectSpec);
        }

        @Generated
        public String toString() {
            return "EnvelopedSystemAspect.EnvelopedSystemAspectBuilder(urn=" + String.valueOf(this.urn) + ", envelopedAspect=" + String.valueOf(this.envelopedAspect) + ", entitySpec=" + String.valueOf(this.entitySpec) + ", aspectSpec=" + String.valueOf(this.aspectSpec) + ")";
        }
    }
}

