/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RoleMembership
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Carries information about which roles a user or group is assigned to.*/@Aspect.name=\"roleMembership\"record RoleMembership{@Relationship.`/*`={\"entityTypes\":[\"dataHubRole\"],\"name\":\"IsMemberOfRole\"}roles:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]}", SchemaFormatType.PDL);
    private UrnArray _rolesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Roles = SCHEMA.getField("roles");

    public RoleMembership() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public RoleMembership(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasRoles() {
        if (this._rolesField != null) {
            return true;
        }
        return this._map.containsKey("roles");
    }

    public void removeRoles() {
        this._map.remove("roles");
    }

    @Nullable
    public UrnArray getRoles(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRoles();
            }
            case DEFAULT: 
            case NULL: {
                if (this._rolesField != null) {
                    return this._rolesField;
                }
                Object __rawValue = this._map.get("roles");
                this._rolesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._rolesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getRoles() {
        if (this._rolesField != null) {
            return this._rolesField;
        }
        Object __rawValue = this._map.get("roles");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("roles");
        }
        this._rolesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._rolesField;
    }

    public RoleMembership setRoles(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRoles(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field roles of com.linkedin.identity.RoleMembership");
                }
                CheckedUtil.putWithoutChecking(this._map, "roles", value.data());
                this._rolesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRoles();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "roles", value.data());
                this._rolesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "roles", value.data());
                this._rolesField = value;
            }
        }
        return this;
    }

    public RoleMembership setRoles(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field roles of com.linkedin.identity.RoleMembership to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "roles", value.data());
        this._rolesField = value;
        return this;
    }

    @Override
    public RoleMembership clone() throws CloneNotSupportedException {
        RoleMembership __clone = (RoleMembership)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public RoleMembership copy() throws CloneNotSupportedException {
        RoleMembership __copy = (RoleMembership)super.copy();
        __copy._rolesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final RoleMembership __objectRef;

        private ChangeListener(RoleMembership reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "roles": {
                    this.__objectRef._rolesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec roles() {
            return new PathSpec(this.getPathComponents(), "roles");
        }

        public PathSpec roles(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "roles");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withRoles() {
            this.getDataMap().put("roles", 1);
            return this;
        }

        public ProjectionMask withRoles(Integer start, Integer count) {
            this.getDataMap().put("roles", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("roles").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("roles").put("$count", count);
            }
            return this;
        }
    }
}

