/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.event.notification.settings;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.event.notification.NotificationSinkTypeArray;
import com.linkedin.event.notification.settings.EmailNotificationSettings;
import com.linkedin.event.notification.settings.SlackNotificationSettings;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NotificationSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.event.notification.settings/**Notification settings for an actor or subscription.*/record NotificationSettings{/**Sink types that notifications are sent to.*/sinkTypes:array[{namespace com.linkedin.event.notification/**A type of sink / platform to send a notification to.*/enum NotificationSinkType{/**Slack target type.*/SLACK/**Email target type.*/EMAIL}}]/**Slack Notification Settings*/slackSettings:optional/**Slack Notification settings for an actor.*/record SlackNotificationSettings{/**Optional user handle*/userHandle:optional string/**Optional list of channels to send notifications to*/channels:optional array[string]}/**Email Notification Settings*/emailSettings:optional/**Email Notification settings for an actor.*/record EmailNotificationSettings{/**Optional user or group email address*/email:string}}", SchemaFormatType.PDL);
    private NotificationSinkTypeArray _sinkTypesField = null;
    private SlackNotificationSettings _slackSettingsField = null;
    private EmailNotificationSettings _emailSettingsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SinkTypes = SCHEMA.getField("sinkTypes");
    private static final RecordDataSchema.Field FIELD_SlackSettings = SCHEMA.getField("slackSettings");
    private static final RecordDataSchema.Field FIELD_EmailSettings = SCHEMA.getField("emailSettings");

    public NotificationSettings() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public NotificationSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSinkTypes() {
        if (this._sinkTypesField != null) {
            return true;
        }
        return this._map.containsKey("sinkTypes");
    }

    public void removeSinkTypes() {
        this._map.remove("sinkTypes");
    }

    @Nullable
    public NotificationSinkTypeArray getSinkTypes(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSinkTypes();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sinkTypesField != null) {
                    return this._sinkTypesField;
                }
                Object __rawValue = this._map.get("sinkTypes");
                this._sinkTypesField = __rawValue == null ? null : new NotificationSinkTypeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._sinkTypesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public NotificationSinkTypeArray getSinkTypes() {
        if (this._sinkTypesField != null) {
            return this._sinkTypesField;
        }
        Object __rawValue = this._map.get("sinkTypes");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("sinkTypes");
        }
        this._sinkTypesField = __rawValue == null ? null : new NotificationSinkTypeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._sinkTypesField;
    }

    public NotificationSettings setSinkTypes(@Nullable NotificationSinkTypeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSinkTypes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field sinkTypes of com.linkedin.event.notification.settings.NotificationSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "sinkTypes", value.data());
                this._sinkTypesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSinkTypes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sinkTypes", value.data());
                this._sinkTypesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sinkTypes", value.data());
                this._sinkTypesField = value;
            }
        }
        return this;
    }

    public NotificationSettings setSinkTypes(@Nonnull NotificationSinkTypeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sinkTypes of com.linkedin.event.notification.settings.NotificationSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sinkTypes", value.data());
        this._sinkTypesField = value;
        return this;
    }

    public boolean hasSlackSettings() {
        if (this._slackSettingsField != null) {
            return true;
        }
        return this._map.containsKey("slackSettings");
    }

    public void removeSlackSettings() {
        this._map.remove("slackSettings");
    }

    @Nullable
    public SlackNotificationSettings getSlackSettings(GetMode mode) {
        return this.getSlackSettings();
    }

    @Nullable
    public SlackNotificationSettings getSlackSettings() {
        if (this._slackSettingsField != null) {
            return this._slackSettingsField;
        }
        Object __rawValue = this._map.get("slackSettings");
        this._slackSettingsField = __rawValue == null ? null : new SlackNotificationSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._slackSettingsField;
    }

    public NotificationSettings setSlackSettings(@Nullable SlackNotificationSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSlackSettings(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSlackSettings();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "slackSettings", value.data());
                this._slackSettingsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "slackSettings", value.data());
                this._slackSettingsField = value;
            }
        }
        return this;
    }

    public NotificationSettings setSlackSettings(@Nonnull SlackNotificationSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field slackSettings of com.linkedin.event.notification.settings.NotificationSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "slackSettings", value.data());
        this._slackSettingsField = value;
        return this;
    }

    public boolean hasEmailSettings() {
        if (this._emailSettingsField != null) {
            return true;
        }
        return this._map.containsKey("emailSettings");
    }

    public void removeEmailSettings() {
        this._map.remove("emailSettings");
    }

    @Nullable
    public EmailNotificationSettings getEmailSettings(GetMode mode) {
        return this.getEmailSettings();
    }

    @Nullable
    public EmailNotificationSettings getEmailSettings() {
        if (this._emailSettingsField != null) {
            return this._emailSettingsField;
        }
        Object __rawValue = this._map.get("emailSettings");
        this._emailSettingsField = __rawValue == null ? null : new EmailNotificationSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._emailSettingsField;
    }

    public NotificationSettings setEmailSettings(@Nullable EmailNotificationSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEmailSettings(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEmailSettings();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "emailSettings", value.data());
                this._emailSettingsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "emailSettings", value.data());
                this._emailSettingsField = value;
            }
        }
        return this;
    }

    public NotificationSettings setEmailSettings(@Nonnull EmailNotificationSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field emailSettings of com.linkedin.event.notification.settings.NotificationSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "emailSettings", value.data());
        this._emailSettingsField = value;
        return this;
    }

    @Override
    public NotificationSettings clone() throws CloneNotSupportedException {
        NotificationSettings __clone = (NotificationSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public NotificationSettings copy() throws CloneNotSupportedException {
        NotificationSettings __copy = (NotificationSettings)super.copy();
        __copy._slackSettingsField = null;
        __copy._sinkTypesField = null;
        __copy._emailSettingsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final NotificationSettings __objectRef;

        private ChangeListener(NotificationSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "slackSettings": {
                    this.__objectRef._slackSettingsField = null;
                    break;
                }
                case "sinkTypes": {
                    this.__objectRef._sinkTypesField = null;
                    break;
                }
                case "emailSettings": {
                    this.__objectRef._emailSettingsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec sinkTypes() {
            return new PathSpec(this.getPathComponents(), "sinkTypes");
        }

        public PathSpec sinkTypes(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "sinkTypes");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public SlackNotificationSettings.Fields slackSettings() {
            return new SlackNotificationSettings.Fields(this.getPathComponents(), "slackSettings");
        }

        public EmailNotificationSettings.Fields emailSettings() {
            return new EmailNotificationSettings.Fields(this.getPathComponents(), "emailSettings");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SlackNotificationSettings.ProjectionMask _slackSettingsMask;
        private EmailNotificationSettings.ProjectionMask _emailSettingsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withSinkTypes() {
            this.getDataMap().put("sinkTypes", 1);
            return this;
        }

        public ProjectionMask withSinkTypes(Integer start, Integer count) {
            this.getDataMap().put("sinkTypes", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("sinkTypes").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("sinkTypes").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSlackSettings(Function<SlackNotificationSettings.ProjectionMask, SlackNotificationSettings.ProjectionMask> nestedMask) {
            this._slackSettingsMask = nestedMask.apply(this._slackSettingsMask == null ? SlackNotificationSettings.createMask() : this._slackSettingsMask);
            this.getDataMap().put("slackSettings", this._slackSettingsMask.getDataMap());
            return this;
        }

        public ProjectionMask withSlackSettings() {
            this._slackSettingsMask = null;
            this.getDataMap().put("slackSettings", 1);
            return this;
        }

        public ProjectionMask withEmailSettings(Function<EmailNotificationSettings.ProjectionMask, EmailNotificationSettings.ProjectionMask> nestedMask) {
            this._emailSettingsMask = nestedMask.apply(this._emailSettingsMask == null ? EmailNotificationSettings.createMask() : this._emailSettingsMask);
            this.getDataMap().put("emailSettings", this._emailSettingsMask.getDataMap());
            return this;
        }

        public ProjectionMask withEmailSettings() {
            this._emailSettingsMask = null;
            this.getDataMap().put("emailSettings", 1);
            return this;
        }
    }
}

