/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datajob.datahub;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.datajob.datahub.IngestionCheckpointState;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatahubIngestionCheckpoint
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datajob.datahub/**Checkpoint of a datahub ingestion run for a given job.*/@Aspect={\"name\":\"datahubIngestionCheckpoint\",\"type\":\"timeseries\"}record DatahubIngestionCheckpoint includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{/**The name of the pipeline that ran ingestion, a stable unique user provided identifier.\n e.g. my_snowflake1-to-datahub.*/@TimeseriesField={}pipelineName:string/**The id of the instance against which the ingestion pipeline ran.\ne.g.: Bigquery project ids, MySQL hostnames etc.*/@TimeseriesField={}platformInstanceId:string/**Json-encoded string representation of the non-secret members of the config .*/config:string/**Opaque blob of the state representation.*/state:/**The checkpoint state object of a datahub ingestion run for a given job.*/record IngestionCheckpointState{/**The version of the state format.*/formatVersion:string/**The serialization/deserialization protocol.*/serde:string/**Opaque blob of the state representation.*/payload:optional bytes}/**The run identifier of this job.*/@TimeseriesField={}runId:string}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private String _pipelineNameField = null;
    private String _platformInstanceIdField = null;
    private String _configField = null;
    private IngestionCheckpointState _stateField = null;
    private String _runIdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_PipelineName;
    private static final RecordDataSchema.Field FIELD_PlatformInstanceId;
    private static final RecordDataSchema.Field FIELD_Config;
    private static final RecordDataSchema.Field FIELD_State;
    private static final RecordDataSchema.Field FIELD_RunId;

    public DatahubIngestionCheckpoint() {
        super(new DataMap(12, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DatahubIngestionCheckpoint(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public DatahubIngestionCheckpoint setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public DatahubIngestionCheckpoint setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public DatahubIngestionCheckpoint setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public DatahubIngestionCheckpoint setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public DatahubIngestionCheckpoint setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasPipelineName() {
        if (this._pipelineNameField != null) {
            return true;
        }
        return this._map.containsKey("pipelineName");
    }

    public void removePipelineName() {
        this._map.remove("pipelineName");
    }

    @Nullable
    public String getPipelineName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPipelineName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pipelineNameField != null) {
                    return this._pipelineNameField;
                }
                Object __rawValue = this._map.get("pipelineName");
                this._pipelineNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._pipelineNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getPipelineName() {
        if (this._pipelineNameField != null) {
            return this._pipelineNameField;
        }
        Object __rawValue = this._map.get("pipelineName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("pipelineName");
        }
        this._pipelineNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._pipelineNameField;
    }

    public DatahubIngestionCheckpoint setPipelineName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPipelineName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pipelineName of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint");
                }
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePipelineName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
                this._pipelineNameField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setPipelineName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pipelineName of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pipelineName", value);
        this._pipelineNameField = value;
        return this;
    }

    public boolean hasPlatformInstanceId() {
        if (this._platformInstanceIdField != null) {
            return true;
        }
        return this._map.containsKey("platformInstanceId");
    }

    public void removePlatformInstanceId() {
        this._map.remove("platformInstanceId");
    }

    @Nullable
    public String getPlatformInstanceId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPlatformInstanceId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._platformInstanceIdField != null) {
                    return this._platformInstanceIdField;
                }
                Object __rawValue = this._map.get("platformInstanceId");
                this._platformInstanceIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._platformInstanceIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getPlatformInstanceId() {
        if (this._platformInstanceIdField != null) {
            return this._platformInstanceIdField;
        }
        Object __rawValue = this._map.get("platformInstanceId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("platformInstanceId");
        }
        this._platformInstanceIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._platformInstanceIdField;
    }

    public DatahubIngestionCheckpoint setPlatformInstanceId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatformInstanceId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field platformInstanceId of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint");
                }
                CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
                this._platformInstanceIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatformInstanceId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
                this._platformInstanceIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
                this._platformInstanceIdField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setPlatformInstanceId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platformInstanceId of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platformInstanceId", value);
        this._platformInstanceIdField = value;
        return this;
    }

    public boolean hasConfig() {
        if (this._configField != null) {
            return true;
        }
        return this._map.containsKey("config");
    }

    public void removeConfig() {
        this._map.remove("config");
    }

    @Nullable
    public String getConfig(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getConfig();
            }
            case DEFAULT: 
            case NULL: {
                if (this._configField != null) {
                    return this._configField;
                }
                Object __rawValue = this._map.get("config");
                this._configField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._configField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getConfig() {
        if (this._configField != null) {
            return this._configField;
        }
        Object __rawValue = this._map.get("config");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("config");
        }
        this._configField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._configField;
    }

    public DatahubIngestionCheckpoint setConfig(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setConfig(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field config of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint");
                }
                CheckedUtil.putWithoutChecking(this._map, "config", value);
                this._configField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeConfig();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "config", value);
                this._configField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "config", value);
                this._configField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setConfig(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field config of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "config", value);
        this._configField = value;
        return this;
    }

    public boolean hasState() {
        if (this._stateField != null) {
            return true;
        }
        return this._map.containsKey("state");
    }

    public void removeState() {
        this._map.remove("state");
    }

    @Nullable
    public IngestionCheckpointState getState(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getState();
            }
            case DEFAULT: 
            case NULL: {
                if (this._stateField != null) {
                    return this._stateField;
                }
                Object __rawValue = this._map.get("state");
                this._stateField = __rawValue == null ? null : new IngestionCheckpointState(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._stateField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IngestionCheckpointState getState() {
        if (this._stateField != null) {
            return this._stateField;
        }
        Object __rawValue = this._map.get("state");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("state");
        }
        this._stateField = __rawValue == null ? null : new IngestionCheckpointState(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._stateField;
    }

    public DatahubIngestionCheckpoint setState(@Nullable IngestionCheckpointState value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setState(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field state of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint");
                }
                CheckedUtil.putWithoutChecking(this._map, "state", value.data());
                this._stateField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeState();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "state", value.data());
                this._stateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "state", value.data());
                this._stateField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setState(@Nonnull IngestionCheckpointState value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field state of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "state", value.data());
        this._stateField = value;
        return this;
    }

    public boolean hasRunId() {
        if (this._runIdField != null) {
            return true;
        }
        return this._map.containsKey("runId");
    }

    public void removeRunId() {
        this._map.remove("runId");
    }

    @Nullable
    public String getRunId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRunId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._runIdField != null) {
                    return this._runIdField;
                }
                Object __rawValue = this._map.get("runId");
                this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._runIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRunId() {
        if (this._runIdField != null) {
            return this._runIdField;
        }
        Object __rawValue = this._map.get("runId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("runId");
        }
        this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._runIdField;
    }

    public DatahubIngestionCheckpoint setRunId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRunId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field runId of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint");
                }
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRunId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
            }
        }
        return this;
    }

    public DatahubIngestionCheckpoint setRunId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field runId of com.linkedin.datajob.datahub.DatahubIngestionCheckpoint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "runId", value);
        this._runIdField = value;
        return this;
    }

    @Override
    public DatahubIngestionCheckpoint clone() throws CloneNotSupportedException {
        DatahubIngestionCheckpoint __clone = (DatahubIngestionCheckpoint)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatahubIngestionCheckpoint copy() throws CloneNotSupportedException {
        DatahubIngestionCheckpoint __copy = (DatahubIngestionCheckpoint)super.copy();
        __copy._pipelineNameField = null;
        __copy._timestampMillisField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._stateField = null;
        __copy._runIdField = null;
        __copy._partitionSpecField = null;
        __copy._configField = null;
        __copy._platformInstanceIdField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_PipelineName = SCHEMA.getField("pipelineName");
        FIELD_PlatformInstanceId = SCHEMA.getField("platformInstanceId");
        FIELD_Config = SCHEMA.getField("config");
        FIELD_State = SCHEMA.getField("state");
        FIELD_RunId = SCHEMA.getField("runId");
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatahubIngestionCheckpoint __objectRef;

        private ChangeListener(DatahubIngestionCheckpoint reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "pipelineName": {
                    this.__objectRef._pipelineNameField = null;
                    break;
                }
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "state": {
                    this.__objectRef._stateField = null;
                    break;
                }
                case "runId": {
                    this.__objectRef._runIdField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "config": {
                    this.__objectRef._configField = null;
                    break;
                }
                case "platformInstanceId": {
                    this.__objectRef._platformInstanceIdField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec pipelineName() {
            return new PathSpec(this.getPathComponents(), "pipelineName");
        }

        public PathSpec platformInstanceId() {
            return new PathSpec(this.getPathComponents(), "platformInstanceId");
        }

        public PathSpec config() {
            return new PathSpec(this.getPathComponents(), "config");
        }

        public IngestionCheckpointState.Fields state() {
            return new IngestionCheckpointState.Fields(this.getPathComponents(), "state");
        }

        public PathSpec runId() {
            return new PathSpec(this.getPathComponents(), "runId");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;
        private IngestionCheckpointState.ProjectionMask _stateMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withPipelineName() {
            this.getDataMap().put("pipelineName", 1);
            return this;
        }

        public ProjectionMask withPlatformInstanceId() {
            this.getDataMap().put("platformInstanceId", 1);
            return this;
        }

        public ProjectionMask withConfig() {
            this.getDataMap().put("config", 1);
            return this;
        }

        public ProjectionMask withState(Function<IngestionCheckpointState.ProjectionMask, IngestionCheckpointState.ProjectionMask> nestedMask) {
            this._stateMask = nestedMask.apply(this._stateMask == null ? IngestionCheckpointState.createMask() : this._stateMask);
            this.getDataMap().put("state", this._stateMask.getDataMap());
            return this;
        }

        public ProjectionMask withState() {
            this._stateMask = null;
            this.getDataMap().put("state", 1);
            return this;
        }

        public ProjectionMask withRunId() {
            this.getDataMap().put("runId", 1);
            return this;
        }
    }
}

