/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.Data;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.NullUnionUnsupportedOperationException;
import com.linkedin.data.template.TemplateOutputCastException;

public class UnionTemplate
implements DataTemplate<Object> {
    protected Object _data;
    protected DataMap _map;
    protected final UnionDataSchema _schema;
    protected DataTemplate<?> _cache;
    protected Object _customTypeCache;

    protected UnionTemplate(Object object, UnionDataSchema schema) throws TemplateOutputCastException {
        if (object == null || object == Data.NULL) {
            this._map = null;
        } else if (object.getClass() == DataMap.class) {
            this._map = (DataMap)object;
        } else {
            throw new TemplateOutputCastException("Union not null or a DataMap");
        }
        this._data = object;
        this._schema = schema;
        this._cache = null;
    }

    @Override
    public DataSchema schema() {
        return this._schema;
    }

    @Override
    public Object data() {
        return this._map == null ? Data.NULL : this._map;
    }

    public DataSchema memberType() throws TemplateOutputCastException {
        String key = null;
        if (this._map == null) {
            key = "null";
        } else {
            if (this._map.size() != 1) {
                throw new TemplateOutputCastException("DataMap of union does not have exactly one field: " + this._map);
            }
            key = (String)this._map.keySet().iterator().next();
        }
        DataSchema memberType = this._schema.getTypeByMemberKey(key);
        if (memberType == null) {
            throw new TemplateOutputCastException(key + " is not a member of " + this._schema);
        }
        return memberType;
    }

    public String memberKeyName() {
        this.checkNotNull();
        return (String)this._map.keySet().iterator().next();
    }

    public boolean memberIs(String key) {
        return this._map != null && this._map.size() == 1 && this._map.get(key) != null;
    }

    public boolean isNull() {
        return this._map == null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof UnionTemplate) {
            return ((UnionTemplate)object).data().equals(this.data());
        }
        return false;
    }

    public UnionTemplate clone() throws CloneNotSupportedException {
        UnionTemplate clone = (UnionTemplate)super.clone();
        if (clone._map != null) {
            clone._map = clone._map.clone();
            clone._data = clone._map;
        } else assert (clone._data == Data.NULL);
        return clone;
    }

    public UnionTemplate copy() throws CloneNotSupportedException {
        UnionTemplate copy = (UnionTemplate)super.clone();
        if (copy._map != null) {
            copy._map = copy._map.copy();
            copy._data = copy._map;
            copy._cache = null;
        } else assert (copy._data == Data.NULL);
        return copy;
    }

    public int hashCode() {
        return this.data().hashCode();
    }

    public String toString() {
        return this.data().toString();
    }

    protected void checkNotNull() throws NullUnionUnsupportedOperationException {
        if (this._map == null) {
            throw new NullUnionUnsupportedOperationException("Operation not supported on a null union");
        }
    }

    protected <T> void selectDirect(DataSchema memberSchema, Class<T> memberClass, String key, T value) throws ClassCastException, NullUnionUnsupportedOperationException {
        this.selectDirect(memberSchema, memberClass, memberClass.isEnum() ? String.class : memberClass, key, value);
    }

    protected <T> void selectDirect(DataSchema memberSchema, Class<T> memberClass, Class<?> dataClass, String key, T value) throws ClassCastException, NullUnionUnsupportedOperationException {
        this.checkNotNull();
        DataSchema memberType = this._schema.getTypeByMemberKey(key);
        assert (memberType != null);
        Object object = DataTemplateUtil.coerceInput(value, memberClass, dataClass);
        this._map.clear();
        this._map.put(key, object);
    }

    protected <T> void selectCustomType(DataSchema memberSchema, Class<T> memberClass, Class<?> dataClass, String key, T value) throws ClassCastException, NullUnionUnsupportedOperationException {
        this.checkNotNull();
        DataSchema memberType = this._schema.getTypeByMemberKey(key);
        assert (memberType != null);
        Object object = DataTemplateUtil.coerceInput(value, memberClass, dataClass);
        this._map.clear();
        this._map.put(key, object);
        this._customTypeCache = value;
    }

    protected <T extends DataTemplate<?>> void selectWrapped(DataSchema memberSchema, Class<T> memberClass, String key, T value) throws ClassCastException, NullUnionUnsupportedOperationException {
        this.checkNotNull();
        DataSchema memberType = this._schema.getTypeByMemberKey(key);
        assert (memberType != null);
        if (value.getClass() != memberClass) {
            throw new ClassCastException("Input " + value + " should be a " + memberClass.getName());
        }
        this._map.clear();
        this._map.put(key, value.data());
        this._cache = value;
    }

    protected <T> T obtainDirect(DataSchema memberSchema, Class<T> memberClass, String key) throws NullUnionUnsupportedOperationException, TemplateOutputCastException {
        this.checkNotNull();
        Object found = this._map.get(key);
        if (found == null) {
            return null;
        }
        return DataTemplateUtil.coerceOutput(found, memberClass);
    }

    protected <T> T obtainCustomType(DataSchema memberSchema, Class<T> memberClass, String key) throws NullUnionUnsupportedOperationException, TemplateOutputCastException {
        T coerced;
        this.checkNotNull();
        Object found = this._map.get(key);
        if (found == null) {
            return null;
        }
        if (this._customTypeCache != null && this._customTypeCache.getClass() == memberClass) {
            coerced = memberClass.cast(this._customTypeCache);
        } else {
            coerced = DataTemplateUtil.coerceOutput(found, memberClass);
            this._customTypeCache = coerced;
        }
        return coerced;
    }

    protected <T extends DataTemplate<?>> T obtainWrapped(DataSchema memberSchema, Class<T> memberClass, String key) throws NullUnionUnsupportedOperationException, TemplateOutputCastException {
        DataTemplate wrapped;
        this.checkNotNull();
        Object found = this._map.get(key);
        if (found == null) {
            wrapped = null;
        } else if (this._cache != null && this._cache.data() == found) {
            wrapped = (DataTemplate)memberClass.cast(this._cache);
        } else {
            wrapped = (DataTemplate)DataTemplateUtil.wrap(found, memberSchema, memberClass);
            this._cache = wrapped;
        }
        return (T)wrapped;
    }

    protected void addChangeListener(CheckedMap.ChangeListener<String, Object> listener) {
        if (this._map != null) {
            this._map.addChangeListener(listener);
        }
    }
}

